/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.excel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.aoju.bus.core.exception.InternalException;
import org.apache.poi.poifs.filesystem.FileMagic;

public class ExcelFileKit {
    public static boolean isXls(InputStream in) {
        return FileMagic.OLE2 == ExcelFileKit.getFileMagic(in);
    }

    public static boolean isXlsx(InputStream in) {
        return FileMagic.OOXML == ExcelFileKit.getFileMagic(in);
    }

    public static boolean isXlsx(File file) {
        try {
            return FileMagic.valueOf((File)file) == FileMagic.OOXML;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private static FileMagic getFileMagic(InputStream in) {
        FileMagic magic;
        in = FileMagic.prepareToCheckMagic((InputStream)in);
        try {
            magic = FileMagic.valueOf((InputStream)in);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return magic;
    }
}

