/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.wxpay;

import java.io.File;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pay.Builder;
import org.aoju.bus.pay.Mode;
import org.aoju.bus.pay.magic.Results;
import org.aoju.bus.pay.metric.HttpKit;
import org.aoju.bus.pay.metric.WxPayKit;
import org.aoju.bus.pay.provider.wxpay.enums.ApiUrl;
import org.aoju.bus.pay.provider.wxpay.enums.WxDomain;

public class WxpayProvider {
    private static final String OS = System.getProperty("os.name") + "/" + System.getProperty("os.version");
    private static final String VERSION = System.getProperty("java.version");

    public static String getReqUrl(ApiUrl apiUrl) {
        return WxpayProvider.getReqUrl(apiUrl, null, false);
    }

    public static String getReqUrl(ApiUrl apiUrl, boolean isSandBox) {
        return WxpayProvider.getReqUrl(apiUrl, null, isSandBox);
    }

    public static String getReqUrl(ApiUrl apiUrl, WxDomain wxDomain, boolean isSandBox) {
        if (wxDomain == null) {
            wxDomain = WxDomain.CHINA;
        }
        return wxDomain.getType().concat(isSandBox ? ApiUrl.SAND_BOX_NEW.getType() : "").concat(apiUrl.getType());
    }

    public static String execution(String apiUrl, Map<String, String> params) {
        return WxpayProvider.doPost(apiUrl, params);
    }

    public static String executionByGet(String apiUrl, Map<String, Object> params) {
        return WxpayProvider.doGet(apiUrl, params);
    }

    public static String execution(String apiUrl, Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.doPostSsl(apiUrl, params, certPath, certPass);
    }

    public static String executionByProtocol(String apiUrl, Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.doPostSslByProtocol(apiUrl, params, certPath, certPass, protocol);
    }

    public static String execution(String apiUrl, Map<String, String> params, String certPath) {
        return WxpayProvider.doPostSsl(apiUrl, params, certPath);
    }

    public static String executionByProtocol(String apiUrl, Map<String, String> params, String certPath, String protocol) {
        return WxpayProvider.doPostSslByProtocol(apiUrl, params, certPath, protocol);
    }

    public static String execution(String apiUrl, Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.doPostSsl(apiUrl, params, certFile, certPass);
    }

    public static String executionByProtocol(String apiUrl, Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.doPostSslByProtocol(apiUrl, params, certFile, certPass, protocol);
    }

    public static String execution(String apiUrl, Map<String, String> params, InputStream certFile) {
        return WxpayProvider.doPostSsl(apiUrl, params, certFile);
    }

    public static String executionByProtocol(String apiUrl, Map<String, String> params, InputStream certFile, String protocol) {
        return WxpayProvider.doPostSslByProtocol(apiUrl, params, certFile, protocol);
    }

    public static String execution(String apiUrl, Map<String, String> params, String certPath, String certPass, String filePath) {
        return WxpayProvider.doUploadSsl(apiUrl, params, certPath, certPass, filePath);
    }

    public static String executionByProtocol(String apiUrl, Map<String, String> params, String certPath, String certPass, String filePath, String protocol) {
        return WxpayProvider.doUploadSslByProtocol(apiUrl, params, certPath, certPass, filePath, protocol);
    }

    public static Results v3(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body, String nonceStr, long timestamp, String authType, File file) throws Exception {
        String authorization = WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, keyPath, body, nonceStr, timestamp, authType);
        if (StringKit.isEmpty(platSerialNo)) {
            platSerialNo = serialNo;
        }
        if ("GET".equals(method)) {
            return WxpayProvider.get(urlPrefix.concat(urlSuffix), authorization, platSerialNo, null);
        }
        if ("POST".equals(method)) {
            if (FileKit.isNotEmpty(file)) {
                return WxpayProvider.upload(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body, file);
            }
            return WxpayProvider.post(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        if ("DELETE".equals(method)) {
            return WxpayProvider.delete(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        if ("PUT".equals(method)) {
            return WxpayProvider.put(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        return null;
    }

    public static Results v3(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, PrivateKey privateKey, String body, String nonceStr, long timestamp, String authType, File file) throws Exception {
        String authorization = WxPayKit.buildAuthorization(method, urlSuffix, mchId, serialNo, privateKey, body, nonceStr, timestamp, authType);
        if (StringKit.isEmpty(platSerialNo)) {
            platSerialNo = serialNo;
        }
        if ("GET".equals(method)) {
            return WxpayProvider.get(urlPrefix.concat(urlSuffix), authorization, platSerialNo, null);
        }
        if ("POST".equals(method)) {
            if (FileKit.isNotEmpty(file)) {
                return WxpayProvider.upload(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body, file);
            }
            return WxpayProvider.post(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        if ("DELETE".equals(method)) {
            return WxpayProvider.delete(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        if ("PUT".equals(method)) {
            return WxpayProvider.put(urlPrefix.concat(urlSuffix), authorization, platSerialNo, body);
        }
        return null;
    }

    public static Results v3(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateString();
        return WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body, nonceStr, timestamp, authType, null);
    }

    public static Results v3(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, PrivateKey privateKey, String body) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateString();
        return WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, privateKey, body, nonceStr, timestamp, authType, null);
    }

    public static Results v3(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, Map<String, String> params) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateString();
        if (null != params && !params.keySet().isEmpty()) {
            urlSuffix = urlSuffix.concat("?").concat(Builder.createLinkString(params, true));
        }
        return WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, "", nonceStr, timestamp, authType, null);
    }

    public static Results v3(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, PrivateKey privateKey, Map<String, String> params) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateString();
        if (null != params && !params.keySet().isEmpty()) {
            urlSuffix = urlSuffix.concat("?").concat(Builder.createLinkString(params, true));
        }
        return WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, privateKey, "", nonceStr, timestamp, authType, null);
    }

    public static Results v3(String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body, File file) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateString();
        return WxpayProvider.v3("POST", urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body, nonceStr, timestamp, authType, file);
    }

    public static Results v3(String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, PrivateKey privateKey, String body, File file) throws Exception {
        long timestamp = System.currentTimeMillis() / 1000L;
        String authType = "WECHATPAY2-SHA256-RSA2048";
        String nonceStr = WxPayKit.generateString();
        return WxpayProvider.v3("POST", urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, privateKey, body, nonceStr, timestamp, authType, file);
    }

    @Deprecated
    public static Map<String, Object> v3Execution(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body, String nonceStr, long timestamp, String authType, File file) throws Exception {
        Results response = WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body, nonceStr, timestamp, authType, file);
        return WxpayProvider.buildResMap(response);
    }

    @Deprecated
    public static Map<String, Object> v3Execution(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String keyPath, String body) throws Exception {
        Results response = WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, null, keyPath, body);
        return WxpayProvider.buildResMap(response);
    }

    @Deprecated
    public static Map<String, Object> v3Execution(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body) throws Exception {
        Results response = WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body);
        return WxpayProvider.buildResMap(response);
    }

    @Deprecated
    public static Map<String, Object> v3Execution(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, Map<String, String> params) throws Exception {
        Results response = WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, params);
        return WxpayProvider.buildResMap(response);
    }

    @Deprecated
    public static Map<String, Object> v3Execution(String method, String urlPrefix, String urlSuffix, String mchId, String serialNo, String keyPath, Map<String, String> params) throws Exception {
        Results response = WxpayProvider.v3(method, urlPrefix, urlSuffix, mchId, serialNo, null, keyPath, params);
        return WxpayProvider.buildResMap(response);
    }

    @Deprecated
    public static Map<String, Object> v3Upload(String urlPrefix, String urlSuffix, String mchId, String serialNo, String platSerialNo, String keyPath, String body, File file) throws Exception {
        Results response = WxpayProvider.v3(urlPrefix, urlSuffix, mchId, serialNo, platSerialNo, keyPath, body, file);
        return WxpayProvider.buildResMap(response);
    }

    @Deprecated
    public static Map<String, Object> v3Upload(String urlPrefix, String urlSuffix, String mchId, String serialNo, String keyPath, String body, File file) throws Exception {
        return WxpayProvider.v3Upload(urlPrefix, urlSuffix, mchId, serialNo, null, keyPath, body, file);
    }

    public static String getSignKey(String mchId, String partnerKey, Algorithm algorithm) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        String nonceStr = WxPayKit.generateString();
        map.put("mch_id", mchId);
        map.put("nonce_str", nonceStr);
        map.put("sign", WxPayKit.createSign(map, partnerKey, algorithm));
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_SIGN_KEY), map);
    }

    public static String pushOrder(Map<String, String> params) {
        return WxpayProvider.pushOrder(false, null, params);
    }

    public static String pushOrder(boolean isSandbox, Map<String, String> params) {
        return WxpayProvider.pushOrder(isSandbox, null, params);
    }

    public static String pushOrder(boolean isSandbox, WxDomain wxDomain, Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.UNIFIED_ORDER, wxDomain, isSandbox), params);
    }

    public static String orderQuery(Map<String, String> params) {
        return WxpayProvider.orderQuery(false, null, params);
    }

    public static String orderQuery(boolean isSandbox, Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.ORDER_QUERY, null, isSandbox), params);
    }

    public static String orderQuery(boolean isSandbox, WxDomain wxDomain, Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.ORDER_QUERY, wxDomain, isSandbox), params);
    }

    public static String closeOrder(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.CLOSE_ORDER), params);
    }

    public static String orderReverse(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.REVERSE), params, certPath, certPass);
    }

    public static String orderReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.REVERSE), params, certFile, certPass);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.REFUND, null, isSandbox), params, certPath, certPass);
    }

    public static String orderRefundByProtocol(boolean isSandbox, Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.REFUND, null, isSandbox), params, certPath, certPass, protocol);
    }

    public static String orderRefund(boolean isSandbox, Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.REFUND, null, isSandbox), params, certFile, certPass);
    }

    public static String orderRefundByProtocol(boolean isSandbox, Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.REFUND, null, isSandbox), params, certFile, certPass, protocol);
    }

    public static String orderRefundQuery(boolean isSandbox, Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.REFUND_QUERY, null, isSandbox), params);
    }

    public static String downloadBill(boolean isSandbox, Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DOWNLOAD_BILL, null, isSandbox), params);
    }

    public static String orderReport(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.REPORT, null, false), params);
    }

    public static String toShortUrl(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SHORT_URL, null, false), params);
    }

    public static String authCodeToOpenid(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.AUTH_CODE_TO_OPENID, null, false), params);
    }

    public static String microPay(boolean isSandbox, Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.MICRO_PAY, null, isSandbox), params);
    }

    public static String transfers(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.TRANSFER, null, false), params, certPath, certPass);
    }

    public static String transfersByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.TRANSFER, null, false), params, certPath, certPass, protocol);
    }

    public static String transfers(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.TRANSFER, null, false), params, certFile, certPass);
    }

    public static String transfersByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.TRANSFER, null, false), params, certFile, certPass, protocol);
    }

    public static String getTransferInfo(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_TRANSFER_INFO, null, false), params, certPath, certPass);
    }

    public static String getTransferInfo(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_TRANSFER_INFO, null, false), params, certFile, certPass);
    }

    public static String payBank(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.TRANSFER_BANK, null, false), params, certPath, certPass);
    }

    public static String payBankByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.TRANSFER_BANK, null, false), params, certPath, certPass, protocol);
    }

    public static String payBank(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.TRANSFER_BANK, null, false), params, certFile, certPass);
    }

    public static String payBankByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.TRANSFER_BANK, null, false), params, certFile, certPass, protocol);
    }

    public static String queryBank(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_TRANSFER_BANK_INFO, null, false), params, certPath, certPass);
    }

    public static String queryBank(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_TRANSFER_BANK_INFO, null, false), params, certFile, certPass);
    }

    public static String getPublicKey(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_PUBLIC_KEY, WxDomain.FRAUD, false), params, certPath, certPass);
    }

    public static String getPublicKey(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_PUBLIC_KEY, WxDomain.FRAUD, false), params, certFile, certPass);
    }

    public static String entrustWeb(Map<String, Object> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.executionByGet(WxpayProvider.getReqUrl(ApiUrl.ENTRUST_WEB), params);
        }
        return WxpayProvider.executionByGet(WxpayProvider.getReqUrl(ApiUrl.PARTNER_ENTRUST_WEB), params);
    }

    public static String preEntrustWeb(Map<String, Object> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.executionByGet(WxpayProvider.getReqUrl(ApiUrl.PRE_ENTRUST_WEB), params);
        }
        return WxpayProvider.executionByGet(WxpayProvider.getReqUrl(ApiUrl.PARTNER_PRE_ENTRUST_WEB), params);
    }

    public static String h5EntrustWeb(Map<String, Object> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.executionByGet(WxpayProvider.getReqUrl(ApiUrl.H5_ENTRUST_WEB), params);
        }
        return WxpayProvider.executionByGet(WxpayProvider.getReqUrl(ApiUrl.PARTNER_H5_ENTRUST_WEB), params);
    }

    public static String contractOrder(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PAY_CONTRACT_ORDER), params);
    }

    public static String queryContract(Map<String, String> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_ENTRUST_CONTRACT), params);
        }
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PARTNER_QUERY_ENTRUST_CONTRACT), params);
    }

    public static String papPayApply(Map<String, String> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PAP_PAY_APPLY), params);
        }
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PARTNER_PAP_PAY_APPLY), params);
    }

    public static String deleteContract(Map<String, String> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DELETE_ENTRUST_CONTRACT), params);
        }
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PARTNER_DELETE_ENTRUST_CONTRACT), params);
    }

    public static String contractBill(Map<String, String> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_ENTRUST_CONTRACT), params);
        }
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PARTNER_QUERY_ENTRUST_CONTRACT), params);
    }

    public static String papOrderQuery(Map<String, String> params, Mode mode) {
        if (mode == Mode.BUSINESS_MODEL) {
            return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PAP_ORDER_QUERY), params);
        }
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PARTNER_PAP_ORDER_QUERY), params);
    }

    public static String profitSharing(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING), params, certPath, certPass);
    }

    public static String profitSharing(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING), params, certFile, certPass);
    }

    public static String multiProfitSharing(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.MULTI_PROFIT_SHARING), params, certPath, certPass);
    }

    public static String multiProfitSharing(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.MULTI_PROFIT_SHARING), params, certFile, certPass);
    }

    public static String profitSharingQuery(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_QUERY), params);
    }

    public static String profitSharingAddReceiver(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFITS_HARING_ADD_RECEIVER), params);
    }

    public static String profitSharingRemoveReceiver(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_REMOVE_RECEIVER), params);
    }

    public static String profitSharingFinish(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_FINISH), params, certPath, certPass);
    }

    public static String profitSharingFinish(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_FINISH), params, certFile, certPass);
    }

    public static String profitSharingReturn(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_RETURN), params, certPath, certPass);
    }

    public static String profitSharingReturn(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_RETURN), params, certFile, certPass);
    }

    public static String profitSharingReturnQuery(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PROFIT_SHARING_RETURN_QUERY), params);
    }

    public static String sendCoupon(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_COUPON), params, certPath, certPass);
    }

    public static String sendCoupon(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_COUPON), params, certFile, certPass);
    }

    public static String queryCouponStock(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_COUPON_STOCK), params);
    }

    public static String queryCouponsInfo(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_COUPONS_INFO), params);
    }

    public static String batchQueryComment(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.BATCH_QUERY_COMMENT), params, certPath, certPass);
    }

    public static String batchQueryComment(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.BATCH_QUERY_COMMENT), params, certFile, certPass);
    }

    public static String depositFacePay(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_FACE_PAY), params);
    }

    public static String depositMicroPay(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_MICRO_PAY), params);
    }

    public static String depositOrderQuery(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_ORDER_QUERY), params);
    }

    public static String depositReverse(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_REVERSE), params, certPath, certPass);
    }

    public static String depositReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_REVERSE), params, certFile, certPass);
    }

    public static String depositConsume(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_CONSUME), params, certPath, certPass);
    }

    public static String depositConsume(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_CONSUME), params, certFile, certPass);
    }

    public static String depositRefund(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_REFUND), params, certPath, certPass);
    }

    public static String depositRefund(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_REFUND), params, certFile, certPass);
    }

    public static String depositRefundQuery(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DEPOSIT_REFUND_QUERY), params);
    }

    public static String downloadFundFlow(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DOWNLOAD_FUND_FLOW), params, certPath, certPass);
    }

    public static String downloadFundFlow(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.DOWNLOAD_FUND_FLOW), params, certFile, certPass);
    }

    public static String getAuthInfo(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_AUTH_INFO, WxDomain.PAY_APP, false), params);
    }

    public static String facePay(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.FACE_PAY), params);
    }

    public static String facePayQuery(Map<String, String> params) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.FACE_PAY_QUERY), params);
    }

    public static String facePayReverse(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.FACE_PAY_REVERSE), params, certPath, certPass);
    }

    public static String facePayReverse(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.FACE_PAY_REVERSE), params, certFile, certPass);
    }

    public static String sendRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_RED_PACK), params, certPath, certPass);
    }

    public static String sendRedPackByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_RED_PACK), params, certPath, certPass, protocol);
    }

    public static String sendRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_RED_PACK), params, certFile, certPass);
    }

    public static String sendRedPackByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_RED_PACK), params, certFile, certPass, protocol);
    }

    public static String sendGroupRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_GROUP_RED_PACK), params, certPath, certPass);
    }

    public static String sendGroupRedPackByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_GROUP_RED_PACK), params, certPath, certPass, protocol);
    }

    public static String sendGroupRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_GROUP_RED_PACK), params, certFile, certPass);
    }

    public static String sendGroupRedPackByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_GROUP_RED_PACK), params, certFile, certPass, protocol);
    }

    public static String getHbInfo(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_HB_INFO), params, certPath, certPass);
    }

    public static String getHbInfo(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.GET_HB_INFO), params, certFile, certPass);
    }

    public static String sendMiniProgramRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_MINI_PROGRAM_HB), params, certPath, certPass);
    }

    public static String sendMiniProgramRedPackByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_MINI_PROGRAM_HB), params, certPath, certPass, protocol);
    }

    public static String sendMiniProgramRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_MINI_PROGRAM_HB), params, certFile, certPass);
    }

    public static String sendMiniProgramRedPackByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_MINI_PROGRAM_HB), params, certFile, certPass, protocol);
    }

    public static String sendWorkWxRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_WORK_WX_RED_PACK), params, certPath, certPass);
    }

    public static String sendWorkWxRedPackByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_WORK_WX_RED_PACK), params, certPath, certPass, protocol);
    }

    public static String sendWorkWxRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.SEND_WORK_WX_RED_PACK), params, certFile, certPass);
    }

    public static String sendWorkWxRedPackByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.SEND_WORK_WX_RED_PACK), params, certFile, certPass, protocol);
    }

    public static String queryWorkWxRedPack(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_WORK_WX_RED_PACK), params, certPath, certPass);
    }

    public static String queryWorkWxRedPackByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.QUERY_WORK_WX_RED_PACK), params, certPath, certPass, protocol);
    }

    public static String queryWorkWxRedPack(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_WORK_WX_RED_PACK), params, certFile, certPass);
    }

    public static String queryWorkWxRedPackByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.QUERY_WORK_WX_RED_PACK), params, certFile, certPass, protocol);
    }

    public static String trans2pocket(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PAY_WWS_TRANS_2_POCKET), params, certPath, certPass);
    }

    public static String trans2pocketByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.PAY_WWS_TRANS_2_POCKET), params, certPath, certPass, protocol);
    }

    public static String trans2pocket(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.PAY_WWS_TRANS_2_POCKET), params, certFile, certPass);
    }

    public static String trans2pocketByProtocol(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.PAY_WWS_TRANS_2_POCKET), params, certFile, certPass, protocol);
    }

    public static String queryTrans2pocket(Map<String, String> params, String certPath, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_WWS_TRANS_2_POCKET), params, certPath, certPass);
    }

    public static String queryTrans2pocketByProtocol(Map<String, String> params, String certPath, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.QUERY_WWS_TRANS_2_POCKET), params, certPath, certPass, protocol);
    }

    public static String queryTrans2pocket(Map<String, String> params, InputStream certFile, String certPass) {
        return WxpayProvider.execution(WxpayProvider.getReqUrl(ApiUrl.QUERY_WWS_TRANS_2_POCKET), params, certFile, certPass);
    }

    public static String queryTrans2pocket(Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return WxpayProvider.executionByProtocol(WxpayProvider.getReqUrl(ApiUrl.QUERY_WWS_TRANS_2_POCKET), params, certFile, certPass, protocol);
    }

    public static String doGet(String url, Map<String, Object> params) {
        return HttpKit.get(url, params);
    }

    public static Results get(String url, Map<String, Object> params, Map<String, String> headers) {
        return HttpKit.get(url, params, headers);
    }

    public static Results get(String url, String authorization, String serialNumber, Map<String, Object> params) {
        return WxpayProvider.get(url, params, WxpayProvider.getHeaders(authorization, serialNumber));
    }

    public static Results post(String url, String data, Map<String, String> headers) {
        return HttpKit.post(url, data, headers);
    }

    public static Results post(String url, String authorization, String serialNumber, String data) {
        return WxpayProvider.post(url, data, WxpayProvider.getHeaders(authorization, serialNumber));
    }

    public static Results delete(String url, String data, Map<String, String> headers) {
        return HttpKit.delete(url, data, headers);
    }

    public static Results delete(String url, String authorization, String serialNumber, String data) {
        return WxpayProvider.delete(url, data, WxpayProvider.getHeaders(authorization, serialNumber));
    }

    public static Results upload(String url, Map<String, Object> params, Map<String, String> headers) {
        return HttpKit.post(url, params, headers);
    }

    public static Results upload(String url, String authorization, String serialNumber, String data, File file) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("file", file);
        paramMap.put("meta", data);
        return WxpayProvider.upload(url, paramMap, WxpayProvider.getUploadHeaders(authorization, serialNumber));
    }

    public static Results put(String url, String data, Map<String, String> headers) {
        return HttpKit.put(url, data, headers);
    }

    public static Results put(String url, String authorization, String serialNumber, String data) {
        return WxpayProvider.put(url, data, WxpayProvider.getHeaders(authorization, serialNumber));
    }

    public static String doPost(String url, Map<String, String> params) {
        return HttpKit.post(url, WxPayKit.toXml(params));
    }

    public static String doPostSsl(String url, Map<String, String> params, String certPath, String certPass) {
        return HttpKit.post(url, WxPayKit.toXml(params), certPath, certPass);
    }

    public static String doPostSslByProtocol(String url, Map<String, String> params, String certPath, String certPass, String protocol) {
        return HttpKit.post(url, WxPayKit.toXml(params), certPath, certPass, protocol);
    }

    public static String doPostSsl(String url, Map<String, String> params, InputStream certFile, String certPass) {
        return HttpKit.post(url, WxPayKit.toXml(params), certFile, certPass);
    }

    public static String doPostSslByProtocol(String url, Map<String, String> params, InputStream certFile, String certPass, String protocol) {
        return HttpKit.post(url, WxPayKit.toXml(params), certFile, certPass, protocol);
    }

    public static String doPostSsl(String url, Map<String, String> params, String certPath) {
        if (params.isEmpty() || !params.containsKey("mch_id")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u5305\u542b mch_id\uff0c\u5982\u63a5\u53e3\u53c2\u8003\u4e2d\u4e0d\u5305 mch_id\uff0c \u8bf7\u4f7f\u7528\u5176\u4ed6\u540c\u540d\u6784\u9020\u65b9\u6cd5\u3002");
        }
        String certPass = params.get("mch_id");
        return WxpayProvider.doPostSsl(url, params, certPath, certPass);
    }

    public static String doPostSslByProtocol(String url, Map<String, String> params, String certPath, String protocol) {
        if (params.isEmpty() || !params.containsKey("mch_id")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u5305\u542b mch_id\uff0c\u5982\u63a5\u53e3\u53c2\u8003\u4e2d\u4e0d\u5305 mch_id\uff0c \u8bf7\u4f7f\u7528\u5176\u4ed6\u540c\u540d\u6784\u9020\u65b9\u6cd5\u3002");
        }
        String certPass = params.get("mch_id");
        return WxpayProvider.doPostSslByProtocol(url, params, certPath, certPass, protocol);
    }

    public static String doPostSsl(String url, Map<String, String> params, InputStream certFile) {
        if (params.isEmpty() || !params.containsKey("mch_id")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u5305\u542b mch_id\uff0c\u5982\u63a5\u53e3\u53c2\u8003\u4e2d\u4e0d\u5305 mch_id\uff0c \u8bf7\u4f7f\u7528\u5176\u4ed6\u540c\u540d\u6784\u9020\u65b9\u6cd5\u3002");
        }
        String certPass = params.get("mch_id");
        return WxpayProvider.doPostSsl(url, params, certFile, certPass);
    }

    public static String doPostSslByProtocol(String url, Map<String, String> params, InputStream certFile, String protocol) {
        if (params.isEmpty() || !params.containsKey("mch_id")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u5305\u542b mch_id\uff0c\u5982\u63a5\u53e3\u53c2\u8003\u4e2d\u4e0d\u5305 mch_id\uff0c \u8bf7\u4f7f\u7528\u5176\u4ed6\u540c\u540d\u6784\u9020\u65b9\u6cd5\u3002");
        }
        String certPass = params.get("mch_id");
        return WxpayProvider.doPostSslByProtocol(url, params, certFile, certPass, protocol);
    }

    public static String doUploadSsl(String url, Map<String, String> params, String certPath, String certPass, String filePath) {
        return HttpKit.upload(url, WxPayKit.toXml(params), certPath, certPass, filePath);
    }

    public static String doUploadSslByProtocol(String url, Map<String, String> params, String certPath, String certPass, String filePath, String protocol) {
        return HttpKit.upload(url, WxPayKit.toXml(params), certPath, certPass, filePath, protocol);
    }

    public static String doUploadSsl(String url, Map<String, String> params, String certPath, String filePath) {
        if (params.isEmpty() || !params.containsKey("mch_id")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u5305\u542b mch_id\uff0c\u5982\u63a5\u53e3\u53c2\u8003\u4e2d\u4e0d\u5305 mch_id\uff0c \u8bf7\u4f7f\u7528\u5176\u4ed6\u540c\u540d\u6784\u9020\u65b9\u6cd5\u3002");
        }
        String certPass = params.get("mch_id");
        return WxpayProvider.doUploadSsl(url, params, certPath, certPass, filePath);
    }

    public static String doUploadSslByProtocol(String url, Map<String, String> params, String certPath, String filePath, String protocol) {
        if (params.isEmpty() || !params.containsKey("mch_id")) {
            throw new RuntimeException("\u8bf7\u6c42\u53c2\u6570\u4e2d\u5fc5\u987b\u5305\u542b mch_id\uff0c\u5982\u63a5\u53e3\u53c2\u8003\u4e2d\u4e0d\u5305 mch_id\uff0c \u8bf7\u4f7f\u7528\u5176\u4ed6\u540c\u540d\u6784\u9020\u65b9\u6cd5\u3002");
        }
        String certPass = params.get("mch_id");
        return WxpayProvider.doUploadSslByProtocol(url, params, certPath, certPass, filePath, protocol);
    }

    public static Map<String, String> getBaseHeaders(String authorization) {
        String userAgent = String.format("WeChatPay-IJPay-HttpClient/%s (%s) Java/%s", WxpayProvider.class.getPackage().getImplementationVersion(), OS, VERSION == null ? "Unknown" : VERSION);
        HashMap<String, String> headers = new HashMap<String, String>(5);
        headers.put("Accept", "application/json");
        headers.put("Authorization", authorization);
        headers.put("User-Agent", userAgent);
        return headers;
    }

    public static Map<String, String> getHeaders(String authorization, String serialNumber) {
        Map<String, String> headers = WxpayProvider.getBaseHeaders(authorization);
        headers.put("Content-Type", "application/json");
        if (StringKit.isNotEmpty(serialNumber)) {
            headers.put("Wechatpay-Serial", serialNumber);
        }
        return headers;
    }

    public static Map<String, String> getUploadHeaders(String authorization, String serialNumber) {
        Map<String, String> headers = WxpayProvider.getBaseHeaders(authorization);
        headers.put("Content-Type", "multipart/form-data;boundary=\"boundary\"");
        if (StringKit.isNotEmpty(serialNumber)) {
            headers.put("Wechatpay-Serial", serialNumber);
        }
        return headers;
    }

    public static Map<String, Object> buildResMap(Results response) {
        if (response == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        String timestamp = response.getHeader("Wechatpay-Timestamp");
        String nonceStr = response.getHeader("Wechatpay-Nonce");
        String serialNo = response.getHeader("Wechatpay-Serial");
        String signature = response.getHeader("Wechatpay-Signature");
        String body = response.getBody();
        int status = response.getStatus();
        map.put("timestamp", timestamp);
        map.put("nonceStr", nonceStr);
        map.put("serialNumber", serialNo);
        map.put("signature", signature);
        map.put("body", body);
        map.put("status", status);
        return map;
    }
}

