/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.aoju.bus.core.lang.ansi.Ansi4BitColor;
import org.aoju.bus.core.lang.ansi.AnsiEncoder;
import org.aoju.bus.extra.servlet.ServletKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.wrapper.CacheRequestWrapper;
import org.aoju.bus.starter.wrapper.CacheResponseWrapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class GenieWrapperHandler
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String method = request.getMethod().toUpperCase();
        this.requestInfo(request, method);
        if (("GET".equals(method) || "POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && request instanceof CacheRequestWrapper) {
            CacheRequestWrapper cacheRequestWrapper = (CacheRequestWrapper)request;
            Logger.info("==> {}", new String(cacheRequestWrapper.getBody()));
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        String method = request.getMethod();
        if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && response instanceof CacheResponseWrapper) {
            CacheResponseWrapper cacheResponseWrapper = (CacheResponseWrapper)response;
            Logger.info("<== {}", new String(cacheResponseWrapper.getBody()).length());
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    private void requestInfo(HttpServletRequest request, String method) {
        String requestMethod = AnsiEncoder.encode(Ansi4BitColor.GREEN, " %s ", method);
        switch (method) {
            case "ALL": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.WHITE, " %s ", method);
                break;
            }
            case "POST": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.MAGENTA, " %s ", method);
                break;
            }
            case "DELETE": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.BLUE, " %s ", method);
                break;
            }
            case "PUT": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.RED, " %s ", method);
                break;
            }
            case "OPTIONS": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.YELLOW, " %s ", method);
                break;
            }
            case "BEFORE": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.BLACK, " %s ", method);
                break;
            }
            case "AFTER": {
                requestMethod = AnsiEncoder.encode(Ansi4BitColor.CYAN, " %s ", method);
            }
        }
        Logger.info("{} {} {}", "==>", ServletKit.getClientIP(request, new String[0]), requestMethod, request.getRequestURL().toString());
    }
}

