/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.provider;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.aoju.bus.cache.Hitting;

public class MemoryHitting
implements Hitting {
    private ConcurrentMap<String, AtomicLong> hitMap = new ConcurrentHashMap<String, AtomicLong>();
    private ConcurrentMap<String, AtomicLong> requireMap = new ConcurrentHashMap<String, AtomicLong>();

    @Override
    public void hitIncr(String pattern, int count) {
        this.hitMap.computeIfAbsent(pattern, k -> new AtomicLong()).addAndGet(count);
    }

    @Override
    public void reqIncr(String pattern, int count) {
        this.requireMap.computeIfAbsent(pattern, k -> new AtomicLong()).addAndGet(count);
    }

    @Override
    public Map<String, Hitting.HittingDO> getHitting() {
        LinkedHashMap<String, Hitting.HittingDO> result = new LinkedHashMap<String, Hitting.HittingDO>();
        AtomicLong statisticsHit = new AtomicLong(0L);
        AtomicLong statisticsRequired = new AtomicLong(0L);
        this.requireMap.forEach((pattern, count) -> {
            long hit = this.hitMap.computeIfAbsent((String)pattern, key -> new AtomicLong(0L)).get();
            long require = count.get();
            statisticsHit.addAndGet(hit);
            statisticsRequired.addAndGet(require);
            result.put((String)pattern, Hitting.HittingDO.newInstance(hit, require));
        });
        result.put(this.summaryName(), Hitting.HittingDO.newInstance(statisticsHit.get(), statisticsRequired.get()));
        return result;
    }

    @Override
    public void reset(String pattern) {
        this.hitMap.remove(pattern);
        this.requireMap.remove(pattern);
    }

    @Override
    public void resetAll() {
        this.hitMap.clear();
        this.requireMap.clear();
    }
}

