/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.metric;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class OauthScope {

    public static interface Scope {
        public String getScope();

        public boolean isDefault();
    }

    public static enum Weibo implements Scope
    {
        ALL("all", "\u83b7\u53d6\u6240\u6709\u6743\u9650", true),
        EMAIL("email", "\u7528\u6237\u7684\u8054\u7cfb\u90ae\u7bb1\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/2/account/profile/email\">\u63a5\u53e3\u6587\u6863</a>", false),
        DIRECT_MESSAGES_WRITE("direct_messages_write", "\u79c1\u4fe1\u53d1\u9001\u63a5\u53e3\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/C/2/direct_messages/send\">\u63a5\u53e3\u6587\u6863</a>", false),
        DIRECT_MESSAGES_READ("direct_messages_read", "\u79c1\u4fe1\u8bfb\u53d6\u63a5\u53e3\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/C/2/direct_messages\">\u63a5\u53e3\u6587\u6863</a>", false),
        INVITATION_WRITE("invitation_write", "\u9080\u8bf7\u53d1\u9001\u63a5\u53e3\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/Messages#.E5.A5.BD.E5.8F.8B.E9.82.80.E8.AF.B7\">\u63a5\u53e3\u6587\u6863</a>", false),
        FRIENDSHIPS_GROUPS_READ("friendships_groups_read", "\u597d\u53cb\u5206\u7ec4\u8bfb\u53d6\u63a5\u53e3\u7ec4\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/API%E6%96%87%E6%A1%A3_V2#.E5.A5.BD.E5.8F.8B.E5.88.86.E7.BB.84\">\u63a5\u53e3\u6587\u6863</a>", false),
        FRIENDSHIPS_GROUPS_WRITE("friendships_groups_write", "\u597d\u53cb\u5206\u7ec4\u5199\u5165\u63a5\u53e3\u7ec4\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/API%E6%96%87%E6%A1%A3_V2#.E5.A5.BD.E5.8F.8B.E5.88.86.E7.BB.84\">\u63a5\u53e3\u6587\u6863</a>", false),
        STATUSES_TO_ME_READ("statuses_to_me_read", "\u5b9a\u5411\u5fae\u535a\u8bfb\u53d6\u63a5\u53e3\u7ec4\uff0c<a rel=\"nofollow\" href=\"http://open.weibo.com/wiki/API%E6%96%87%E6%A1%A3_V2#.E5.BE.AE.E5.8D.9A\">\u63a5\u53e3\u6587\u6863</a>", false),
        FOLLOW_APP_OFFICIAL_MICROBLOG("follow_app_official_microblog", "\u5173\u6ce8\u5e94\u7528\u5b98\u65b9\u5fae\u535a\uff0c\u8be5\u53c2\u6570\u4e0d\u5bf9\u5e94\u5177\u4f53\u63a5\u53e3\uff0c\u53ea\u9700\u5728\u5e94\u7528\u63a7\u5236\u53f0\u586b\u5199\u5b98\u65b9\u5e10\u53f7\u5373\u53ef\u3002\u586b\u5199\u7684\u8def\u5f84\uff1a\u6211\u7684\u5e94\u7528-\u9009\u62e9\u81ea\u5df1\u7684\u5e94\u7528-\u5e94\u7528\u4fe1\u606f-\u57fa\u672c\u4fe1\u606f-\u5b98\u65b9\u8fd0\u8425\u8d26\u53f7\uff08\u9ed8\u8ba4\u503c\u662f\u5e94\u7528\u5f00\u53d1\u8005\u5e10\u53f7\uff09", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Weibo(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum WechatMp implements Scope
    {
        SNSAPI_USERINFO("snsapi_userinfo", "\u5f39\u51fa\u6388\u6743\u9875\u9762\uff0c\u53ef\u901a\u8fc7openid\u62ff\u5230\u6635\u79f0\u3001\u6027\u522b\u3001\u6240\u5728\u5730\u3002\u5e76\u4e14\uff0c \u5373\u4f7f\u5728\u672a\u5173\u6ce8\u7684\u60c5\u51b5\u4e0b\uff0c\u53ea\u8981\u7528\u6237\u6388\u6743\uff0c\u4e5f\u80fd\u83b7\u53d6\u5176\u4fe1\u606f", true),
        SNSAPI_BASE("snsapi_base", "\u4e0d\u5f39\u51fa\u6388\u6743\u9875\u9762\uff0c\u76f4\u63a5\u8df3\u8f6c\uff0c\u53ea\u80fd\u83b7\u53d6\u7528\u6237openid", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private WechatMp(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Slack implements Scope
    {
        USERS_PROFILE_READ("users.profile:read", "View profile details about people in a workspace", true),
        USERS_READ("users:read", "View people in a workspace", true),
        USERS_READ_EMAIL("users:read.email", "View email addresses of people in a workspace", true),
        USERS_PROFILE_WRITE("users.profile:write", "Edit a user\u2019s profile information and status", false),
        USERS_PROFILE_WRITE_USER("users.profile:write:user", "Change the user's profile fields", false),
        USERS_WRITE("users:write", "Set presence for your slack app", false),
        ADMIN("admin", "Administer a workspace", false),
        ADMIN_ANALYTICS_READ("admin.analytics:read", "Access analytics data about the organization", false),
        ADMIN_APPS_READ("admin.apps:read", "View apps and app requests in a workspace", false),
        ADMIN_APPS_WRITE("admin.apps:write", "Manage apps in a workspace", false),
        ADMIN_BARRIERS_READ("admin.barriers:read", "Read information barriers in the organization", false),
        ADMIN_BARRIERS_WRITE("admin.barriers:write", "Manage information barriers in the organization", false),
        ADMIN_CONVERSATIONS_READ("admin.conversations:read", "View the channel\u2019s member list, topic, purpose and channel name", false),
        ADMIN_CONVERSATIONS_WRITE("admin.conversations:write", "Start a new conversation, modify a conversation and modify channel details", false),
        ADMIN_INVITES_READ("admin.invites:read", "Gain information about invite requests in a Grid organization.", false),
        ADMIN_INVITES_WRITE("admin.invites:write", "Approve or deny invite requests in a Grid organization.", false),
        ADMIN_TEAMS_READ("admin.teams:read", "Access information about a workspace", false),
        ADMIN_TEAMS_WRITE("admin.teams:write", "Make changes to a workspace", false),
        ADMIN_USERGROUPS_READ("admin.usergroups:read", "Access information about user groups", false),
        ADMIN_USERGROUPS_WRITE("admin.usergroups:write", "Make changes to your usergroups", false),
        ADMIN_USERS_READ("admin.users:read", "Access a workspace\u2019s profile information", false),
        ADMIN_USERS_WRITE("admin.users:write", "Modify account information", false),
        APP_MENTIONS_READ("app_mentions:read", "View messages that directly mention @your_slack_app in conversations that the app is in", false),
        AUDITLOGS_READ("auditlogs:read", "View events from all workspaces, channels and users (Enterprise Grid only)", false),
        BOT("bot", "Add the ability for people to direct message or mention @your_slack_app", false),
        CALLS_READ("calls:read", "View information about ongoing and past calls", false),
        CALLS_WRITE("calls:write", "Start and manage calls in a workspace", false),
        CHANNELS_HISTORY("channels:history", "View messages and other content in public channels that your slack app has been added to", false),
        CHANNELS_JOIN("channels:join", "Join public channels in a workspace", false),
        CHANNELS_MANAGE("channels:manage", "Manage public channels that your slack app has been added to and create new ones", false),
        CHANNELS_READ("channels:read", "View basic information about public channels in a workspace", false),
        CHANNELS_WRITE("channels:write", "Manage a user\u2019s public channels and create new ones on a user\u2019s behalf", false),
        CHAT_WRITE("chat:write", "Post messages in approved channels & conversations", false),
        CHAT_WRITE_CUSTOMIZE("chat:write.customize", "Send messages as @your_slack_app with a customized username and avatar", false),
        CHAT_WRITE_PUBLIC("chat:write.public", "Send messages to channels @your_slack_app isn't a member of", false),
        CHAT_WRITE_BOT("chat:write:bot", "Send messages as your slack app", false),
        CHAT_WRITE_USER("chat:write:user", "Send messages on a user\u2019s behalf", false),
        CLIENT("client", "Receive all events from a workspace in real time", false),
        COMMANDS("commands", "Add shortcuts and/or slash commands that people can use", false),
        CONVERSATIONS_HISTORY("conversations:history", "Deprecated: Retrieve conversation history for legacy workspace apps", false),
        CONVERSATIONS_READ("conversations:read", "Deprecated: Retrieve information on conversations for legacy workspace apps", false),
        CONVERSATIONS_WRITE("conversations:write", "Deprecated: Edit conversation attributes for legacy workspace apps", false),
        DND_READ("dnd:read", "View Do Not Disturb settings for people in a workspace", false),
        DND_WRITE("dnd:write", "Edit a user\u2019s Do Not Disturb settings", false),
        DND_WRITE_USER("dnd:write:user", "Change the user's Do Not Disturb settings", false),
        EMOJI_READ("emoji:read", "View custom emoji in a workspace", false),
        FILES_READ("files:read", "View files shared in channels and conversations that your slack app has been added to", false),
        FILES_WRITE("files:write", "Upload, edit, and delete files as your slack app", false),
        FILES_WRITE_USER("files:write:user", "Upload, edit, and delete files as your slack app", false),
        GROUPS_HISTORY("groups:history", "View messages and other content in private channels that your slack app has been added to", false),
        GROUPS_READ("groups:read", "View basic information about private channels that your slack app has been added to", false),
        GROUPS_WRITE("groups:write", "Manage private channels that your slack app has been added to and create new ones", false),
        IDENTIFY("identify", "View information about a user\u2019s identity", false),
        IDENTITY_AVATAR("identity.avatar", "View a user\u2019s Slack avatar", false),
        IDENTITY_AVATAR_READ_USER("identity.avatar:read:user", "View the user's profile picture", false),
        IDENTITY_BASIC("identity.basic", "View information about a user\u2019s identity", false),
        IDENTITY_EMAIL("identity.email", "View a user\u2019s email address", false),
        IDENTITY_EMAIL_READ_USER("identity.email:read:user", "This scope is not yet described.", false),
        IDENTITY_TEAM("identity.team", "View a user\u2019s Slack workspace name", false),
        IDENTITY_TEAM_READ_USER("identity.team:read:user", "View the workspace's name, domain, and icon", false),
        IDENTITY_READ_USER("identity:read:user", "This scope is not yet described.", false),
        IM_HISTORY("im:history", "View messages and other content in direct messages that your slack app has been added to", false),
        IM_READ("im:read", "View basic information about direct messages that your slack app has been added to", false),
        IM_WRITE("im:write", "Start direct messages with people", false),
        INCOMING_WEBHOOK("incoming-webhook", "Create one-way webhooks to post messages to a specific channel", false),
        LINKS_READ("links:read", "View  URLs in messages", false),
        LINKS_WRITE("links:write", "Show previews of  URLs in messages", false),
        MPIM_HISTORY("mpim:history", "View messages and other content in group direct messages that your slack app has been added to", false),
        MPIM_READ("mpim:read", "View basic information about group direct messages that your slack app has been added to", false),
        MPIM_WRITE("mpim:write", "Start group direct messages with people", false),
        NONE("none", "Execute methods without needing a scope", false),
        PINS_READ("pins:read", "View pinned content in channels and conversations that your slack app has been added to", false),
        PINS_WRITE("pins:write", "Add and remove pinned messages and files", false),
        POST("post", "Post messages to a workspace", false),
        REACTIONS_READ("reactions:read", "View emoji reactions and their associated content in channels and conversations that your slack app has been added to", false),
        REACTIONS_WRITE("reactions:write", "Add and edit emoji reactions", false),
        READ("read", "View all content in a workspace", false),
        REMINDERS_READ("reminders:read", "View reminders created by your slack app", false),
        REMINDERS_READ_USER("reminders:read:user", "Access reminders created by a user or for a user", false),
        REMINDERS_WRITE("reminders:write", "Add, remove, or mark reminders as complete", false),
        REMINDERS_WRITE_USER("reminders:write:user", "Add, remove, or complete reminders for the user", false),
        REMOTE_FILES_READ("remote_files:read", "View remote files added by the app in a workspace", false),
        REMOTE_FILES_SHARE("remote_files:share", "Share remote files on a user\u2019s behalf", false),
        REMOTE_FILES_WRITE("remote_files:write", "Add, edit, and delete remote files on a user\u2019s behalf", false),
        SEARCH_READ("search:read", "Search a workspace\u2019s content", false),
        STARS_READ("stars:read", "View messages and files that your slack app has starred", false),
        STARS_WRITE("stars:write", "Add or remove stars", false),
        TEAM_READ("team:read", "View the name, email domain, and icon for workspaces your slack app is connected to", false),
        TOKENS_BASIC("tokens.basic", "Execute methods without needing a scope", false),
        USERGROUPS_READ("usergroups:read", "View user groups in a workspace", false),
        USERGROUPS_WRITE("usergroups:write", "Create and manage user groups", false),
        WORKFLOW_STEPS_EXECUTE("workflow.steps:execute", "Add steps that people can use in Workflow Builder", false);

        private final String scope;
        private final String description;
        private final boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Slack(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum StackOverflow implements Scope
    {
        read_inbox("read_inbox", "access a user's global inbox", true),
        NO_EXPIRY("no_expiry", "access_token's with this scope do not expire", false),
        WRITE_ACCESS("write_access", "perform write operations as a user", false),
        PRIVATE_INFO("private_info", "access full history of a user's private actions on the site", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private StackOverflow(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Renren implements Scope
    {
        READ_USER_BLOG("read_user_blog", "\u83b7\u53d6\u7528\u6237\u65e5\u5fd7\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_CHECKIN("read_user_checkin", "\u83b7\u53d6\u7528\u6237\u62a5\u5230\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_FEED("read_user_feed", "\u83b7\u53d6\u7528\u6237\u65b0\u9c9c\u4e8b\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_GUESTBOOK("read_user_guestbook", "\u83b7\u53d6\u7528\u6237\u7559\u8a00\u677f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_INVITATION("read_user_invitation", "\u83b7\u53d6\u7528\u6237\u88ab\u9080\u8bf7\u7684\u72b6\u51b5\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_LIKE_HISTORY("read_user_like_history", "\u83b7\u53d6\u7528\u6237\u559c\u6b22\u7684\u5386\u53f2\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_MESSAGE("read_user_message", "\u83b7\u53d6\u7528\u6237\u7ad9\u5185\u4fe1\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_NOTIFICATION("read_user_notification", "\u83b7\u53d6\u7528\u6237\u5df2\u6536\u5230\u7684\u901a\u77e5\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_PHOTO("read_user_photo", "\u83b7\u53d6\u7528\u6237\u76f8\u518c\u76f8\u5173\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_STATUS("read_user_status", "\u83b7\u53d6\u7528\u6237\u72b6\u6001\u76f8\u5173\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_ALBUM("read_user_album", "\u83b7\u53d6\u7528\u6237\u76f8\u518c\u76f8\u5173\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_COMMENT("read_user_comment", "\u83b7\u53d6\u7528\u6237\u8bc4\u8bba\u76f8\u5173\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_SHARE("read_user_share", "\u83b7\u53d6\u7528\u6237\u5206\u4eab\u76f8\u5173\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        READ_USER_REQUEST("read_user_request", "\u83b7\u53d6\u7528\u6237\u597d\u53cb\u8bf7\u6c42\u3001\u5708\u4eba\u8bf7\u6c42\u7b49\u4fe1\u606f\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        PUBLISH_BLOG("publish_blog", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u5e03\u65e5\u5fd7\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        PUBLISH_CHECKIN("publish_checkin", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u5e03\u62a5\u5230\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        PUBLISH_FEED("publish_feed", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u9001\u65b0\u9c9c\u4e8b\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        PUBLISH_SHARE("publish_share", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u9001\u5206\u4eab\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        WRITE_GUESTBOOK("write_guestbook", "\u4ee5\u7528\u6237\u8eab\u4efd\u8fdb\u884c\u7559\u8a00\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        SEND_INVITATION("send_invitation", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u9001\u9080\u8bf7\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        SEND_REQUEST("send_request", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u9001\u597d\u53cb\u7533\u8bf7\u3001\u5708\u4eba\u8bf7\u6c42\u7b49\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        SEND_MESSAGE("send_message", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u9001\u7ad9\u5185\u4fe1\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        SEND_NOTIFICATION("send_notification", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u9001\u901a\u77e5\uff08user_to_user\uff09\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        PHOTO_UPLOAD("photo_upload", "\u4ee5\u7528\u6237\u8eab\u4efd\u4e0a\u4f20\u7167\u7247\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        STATUS_UPDATE("status_update", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u5e03\u72b6\u6001\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        CREATE_ALBUM("create_album", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u5e03\u76f8\u518c\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        PUBLISH_COMMENT("publish_comment", "\u4ee5\u7528\u6237\u8eab\u4efd\u53d1\u5e03\u8bc4\u8bba\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        OPERATE_LIKE("operate_like", "\u4ee5\u7528\u6237\u8eab\u4efd\u6267\u884c\u559c\u6b22\u64cd\u4f5c\u65f6\u9700\u8981\u7528\u6237\u6388\u4e88\u7684\u6743\u9650\u3002", false),
        ADMIN_PAGE("admin_page", "\u4ee5\u7528\u6237\u7684\u8eab\u4efd\uff0c\u7ba1\u7406\u5176\u53ef\u4ee5\u7ba1\u7406\u7684\u516c\u5171\u4e3b\u9875\u7684\u6743\u9650\u3002", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Renren(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Qq implements Scope
    {
        GET_USER_INFO("get_user_info", "\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u6635\u79f0\u3001\u5934\u50cf\u3001\u6027\u522b", true),
        GET_VIP_INFO("get_vip_info", "\u83b7\u53d6QQ\u4f1a\u5458\u7684\u57fa\u672c\u4fe1\u606f", false),
        GET_VIP_RICH_INFO("get_vip_rich_info", "\u83b7\u53d6QQ\u4f1a\u5458\u7684\u9ad8\u7ea7\u4fe1\u606f", false),
        LIST_ALBUM("list_album", "\u83b7\u53d6\u7528\u6237QQ\u7a7a\u95f4\u76f8\u518c\u5217\u8868", false),
        UPLOAD_PIC("upload_pic", "\u4e0a\u4f20\u4e00\u5f20\u7167\u7247\u5230QQ\u7a7a\u95f4\u76f8\u518c", false),
        ADD_ALBUM("add_album", "\u5728\u7528\u6237\u7684\u7a7a\u95f4\u76f8\u518c\u91cc\uff0c\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u4e2a\u4eba\u76f8\u518c", false),
        LIST_PHOTO("list_photo", "\u83b7\u53d6\u7528\u6237QQ\u7a7a\u95f4\u76f8\u518c\u4e2d\u7684\u7167\u7247\u5217\u8868", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Qq(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Pinterest implements Scope
    {
        READ_PUBLIC("read_public", "Use GET method on a user\u2019s Pins, boards.", true),
        WRITE_PUBLIC("write_public", "Use PATCH, POST and DELETE methods on a user\u2019s Pins and boards.", false),
        READ_RELATIONSHIPS("read_relationships", "Use GET method on a user\u2019s follows and followers (on boards, users and interests).", false),
        WRITE_RELATIONSHIPS("write_relationships", "Use PATCH, POST and DELETE methods on a user\u2019s follows and followers (on boards, users and interests).", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Pinterest(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Mi implements Scope
    {
        profile("user/profile", "\u83b7\u53d6\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f", true),
        OPENID("user/openIdV2", "\u83b7\u53d6\u7528\u6237\u7684OpenID", true),
        PHONE_EMAIL("user/phoneAndEmail", "\u83b7\u53d6\u7528\u6237\u7684\u624b\u673a\u53f7\u548c\u90ae\u7bb1", true);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Mi(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Microsoft implements Scope
    {
        PROFILE("profile", "\u5141\u8bb8\u5e94\u7528\u67e5\u770b\u7528\u6237\u7684\u57fa\u672c\u4e2a\u4eba\u8d44\u6599\uff08\u540d\u79f0\u3001\u56fe\u7247\u3001\u7528\u6237\u540d\u79f0\uff09", true),
        EMAIL("email", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u7528\u6237\u7684\u4e3b\u7535\u5b50\u90ae\u4ef6\u5730\u5740", true),
        OPENID("openid", "\u5141\u8bb8\u7528\u6237\u4ee5\u5176\u5de5\u4f5c\u6216\u5b66\u6821\u5e10\u6237\u767b\u5f55\u5e94\u7528\uff0c\u5e76\u5141\u8bb8\u5e94\u7528\u67e5\u770b\u7528\u6237\u7684\u57fa\u672c\u4e2a\u4eba\u8d44\u6599\u4fe1\u606f", true),
        OFFLINE_ACCESS("offline_access", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u548c\u66f4\u65b0\u7528\u6237\u6570\u636e\uff0c\u5373\u4f7f\u7528\u6237\u5f53\u524d\u6ca1\u6709\u5728\u4f7f\u7528\u6b64\u5e94\u7528\uff0c\u4e5f\u4e0d\u4f8b\u5916", true),
        USER_READ("User.Read", "\u767b\u5f55\u5e76\u8bfb\u53d6\u7528\u6237\u4e2a\u4eba\u8d44\u6599", false),
        USER_READWRITE("User.ReadWrite", "\u5bf9\u7528\u6237\u4e2a\u4eba\u8d44\u6599\u7684\u8bfb\u5199\u6743\u9650", false),
        USER_READBASIC_ALL("User.ReadBasic.All", "\u8bfb\u53d6\u6240\u6709\u7528\u6237\u7684\u57fa\u672c\u4e2a\u4eba\u8d44\u6599", false),
        USER_READ_ALL("User.Read.All", "\u8bfb\u53d6\u6240\u6709\u7528\u6237\u7684\u5b8c\u6574\u4e2a\u4eba\u8d44\u6599", false),
        USER_READWRITE_ALL("User.ReadWrite.All", "\u8bfb\u53d6\u548c\u5199\u5165\u6240\u6709\u7528\u6237\u7684\u5b8c\u6574\u4e2a\u4eba\u8d44\u6599", false),
        USER_INVITE_ALL("User.Invite.All", "\u5c06\u6765\u5bbe\u7528\u6237\u9080\u8bf7\u5230\u7ec4\u7ec7", false),
        USER_EXPORT_ALL("User.Export.All", "\u5bfc\u51fa\u7528\u6237\u6570\u636e", false),
        USER_MANAGEIDENTITIES_ALL("User.ManageIdentities.All", "\u7ba1\u7406\u6240\u6709\u7528\u6237\u6807\u8bc6", false),
        USERACTIVITY_READWRITE_CREATEDBYAPP("UserActivity.ReadWrite.CreatedByApp", "\u5c06\u5e94\u7528\u6d3b\u52a8\u8bfb\u53d6\u548c\u5199\u5165\u5230\u7528\u6237\u7684\u6d3b\u52a8\u6e90", false),
        FILES_READ("Files.Read", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u767b\u5f55\u7528\u6237\u7684\u6587\u4ef6", false),
        FILES_READ_ALL("Files.Read.All", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u767b\u5f55\u7528\u6237\u53ef\u4ee5\u8bbf\u95ee\u7684\u6240\u6709\u6587\u4ef6", false),
        FILES_READWRITE("Files.ReadWrite", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u3001\u521b\u5efa\u3001\u66f4\u65b0\u548c\u5220\u9664\u767b\u5f55\u7528\u6237\u7684\u6587\u4ef6", false),
        FILES_READWRITE_ALL("Files.ReadWrite.All", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u3001\u521b\u5efa\u3001\u66f4\u65b0\u548c\u5220\u9664\u767b\u5f55\u7528\u6237\u53ef\u4ee5\u8bbf\u95ee\u7684\u6240\u6709\u6587\u4ef6", false),
        FILES_READWRITE_APPFOLDER("Files.ReadWrite.AppFolder", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u3001\u521b\u5efa\u3001\u66f4\u65b0\u548c\u5220\u9664\u5e94\u7528\u7a0b\u5e8f\u6587\u4ef6\u5939\u4e2d\u7684\u6587\u4ef6", false),
        FILES_READ_SELECTED("Files.Read.Selected", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u7528\u6237\u9009\u62e9\u7684\u6587\u4ef6\u3002\u5728\u7528\u6237\u9009\u62e9\u6587\u4ef6\u540e\uff0c\u5e94\u7528\u6709\u51e0\u4e2a\u5c0f\u65f6\u7684\u8bbf\u95ee\u6743\u9650", false),
        FILES_READWRITE_SELECTED("Files.ReadWrite.Selected", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u548c\u5199\u5165\u7528\u6237\u9009\u62e9\u7684\u6587\u4ef6\u3002\u5728\u7528\u6237\u9009\u62e9\u6587\u4ef6\u540e\uff0c\u5e94\u7528\u6709\u51e0\u4e2a\u5c0f\u65f6\u7684\u8bbf\u95ee\u6743\u9650", false),
        ORGCONTACT_READ_ALL("OrgContact.Read.All", "\u5141\u8bb8\u5e94\u7528\u4ee3\u8868\u5df2\u767b\u5f55\u7528\u6237\u8bfb\u53d6\u6240\u6709\u7ec4\u7ec7\u8054\u7cfb\u4eba\u3002 \u8fd9\u4e9b\u8054\u7cfb\u4eba\u7531\u7ec4\u7ec7\u7ba1\u7406\uff0c\u4e0d\u540c\u4e8e\u7528\u6237\u7684\u4e2a\u4eba\u8054\u7cfb\u4eba", false),
        MAIL_READ("Mail.Read", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u7528\u6237\u90ae\u7bb1\u4e2d\u7684\u7535\u5b50\u90ae\u4ef6", false),
        MAIL_READBASIC("Mail.ReadBasic", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u5df2\u767b\u5f55\u7528\u6237\u7684\u90ae\u7bb1\uff0c\u4f46\u4e0d\u8bfb\u53d6 body\u3001bodyPreview\u3001uniqueBody\u3001attachments\u3001extensions \u548c\u4efb\u4f55\u6269\u5c55\u5c5e\u6027\u3002 \u4e0d\u5305\u542b\u90ae\u4ef6\u641c\u7d22\u6743\u9650", false),
        MAIL_READWRITE("Mail.ReadWrite", "\u5141\u8bb8\u5e94\u7528\u521b\u5efa\u3001\u8bfb\u53d6\u3001\u66f4\u65b0\u548c\u5220\u9664\u7528\u6237\u90ae\u7bb1\u4e2d\u7684\u7535\u5b50\u90ae\u4ef6\u3002\u4e0d\u5305\u62ec\u53d1\u9001\u7535\u5b50\u90ae\u4ef6\u7684\u6743\u9650", false),
        MAIL_READ_SHARED("Mail.Read.Shared", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u7528\u6237\u53ef\u4ee5\u8bbf\u95ee\u7684\u90ae\u4ef6\uff0c\u5305\u62ec\u7528\u6237\u4e2a\u4eba\u90ae\u4ef6\u548c\u5171\u4eab\u90ae\u4ef6", false),
        MAIL_READWRITE_SHARED("Mail.ReadWrite.Shared", "\u5141\u8bb8\u5e94\u7528\u521b\u5efa\u3001\u8bfb\u53d6\u3001\u66f4\u65b0\u548c\u5220\u9664\u7528\u6237\u6709\u6743\u8bbf\u95ee\u7684\u90ae\u4ef6\uff0c\u5305\u62ec\u7528\u6237\u4e2a\u4eba\u90ae\u4ef6\u548c\u5171\u4eab\u90ae\u4ef6\u3002\u4e0d\u5305\u62ec\u90ae\u4ef6\u53d1\u9001\u6743\u9650", false),
        MAIL_SEND("Mail.Send", "\u5141\u8bb8\u5e94\u7528\u4ee5\u7ec4\u7ec7\u7528\u6237\u8eab\u4efd\u53d1\u9001\u90ae\u4ef6", false),
        MAIL_SEND_SHARED("Mail.Send.Shared", "\u5141\u8bb8\u5e94\u7528\u4ee5\u767b\u5f55\u7528\u6237\u8eab\u4efd\u53d1\u9001\u90ae\u4ef6\uff0c\u5305\u62ec\u4ee3\u8868\u4ed6\u4eba\u53d1\u9001\u90ae\u4ef6", false),
        MAILBOXSETTINGS_READ("MailboxSettings.Read", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u7528\u6237\u7684\u90ae\u7bb1\u8bbe\u7f6e\u3002\u4e0d\u5305\u62ec\u90ae\u4ef6\u53d1\u9001\u6743\u9650", false),
        MAILBOXSETTINGS_READWRITE("MailboxSettings.ReadWrite", "\u5141\u8bb8\u5e94\u7528\u521b\u5efa\u3001\u8bfb\u53d6\u3001\u66f4\u65b0\u548c\u5220\u9664\u7528\u6237\u90ae\u7bb1\u8bbe\u7f6e\u3002 \u4e0d\u5305\u542b\u76f4\u63a5\u53d1\u9001\u90ae\u4ef6\u7684\u6743\u9650\uff0c\u4f46\u5141\u8bb8\u5e94\u7528\u521b\u5efa\u80fd\u591f\u8f6c\u53d1\u6216\u91cd\u5b9a\u5411\u90ae\u4ef6\u7684\u89c4\u5219", false),
        NOTES_READ("Notes.Read", "\u5141\u8bb8\u5e94\u7528\u4ee3\u8868\u5df2\u767b\u5f55\u7528\u6237\u8bfb\u53d6 OneNote \u7b14\u8bb0\u672c\u548c\u5206\u533a\u6807\u9898\u5e76\u521b\u5efa\u65b0\u7684\u9875\u9762\u3001\u7b14\u8bb0\u672c\u548c\u5206\u533a", false),
        NOTES_CREATE("Notes.Create", "\u5141\u8bb8\u5e94\u7528\u4ee3\u521b\u5efa\u7528\u6237 OneNote \u7b14\u8bb0\u672c", false),
        NOTES_READWRITE("Notes.ReadWrite", "\u5141\u8bb8\u5e94\u7528\u4ee3\u8868\u5df2\u767b\u5f55\u7528\u6237\u8bfb\u53d6\u3001\u5171\u4eab\u548c\u4fee\u6539 OneNote \u7b14\u8bb0\u672c", false),
        NOTES_READ_ALL("Notes.Read.All", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u767b\u5f55\u7528\u6237\u5728\u7ec4\u7ec7\u4e2d\u6709\u6743\u8bbf\u95ee\u7684 OneNote \u7b14\u8bb0\u672c", false),
        NOTES_READWRITE_ALL("Notes.ReadWrite.All", "\u5141\u8bb8\u5e94\u7528\u8bfb\u53d6\u3001\u5171\u4eab\u548c\u4fee\u6539\u5df2\u767b\u5f55\u7528\u6237\u5728\u7ec4\u7ec7\u4e2d\u6709\u6743\u8bbf\u95ee\u7684 OneNote \u7b14\u8bb0\u672c", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Microsoft(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Linkedin implements Scope
    {
        R_LITEPROFILE("r_liteprofile", "Use your name, headline, and photo", true),
        R_EMAILADDRESS("r_emailaddress", "Use the primary email address associated with your LinkedIn account", true),
        W_MEMBER_SOCIAL("w_member_social", "Post, comment and like posts on your behalf", true),
        R_MEMBER_SOCIAL("r_member_social", "Retrieve your posts, comments, likes, and other engagement data", false),
        R_AD_CAMPAIGNS("r_ad_campaigns", "View advertising campaigns you manage", false),
        R_ADS("r_ads", "Retrieve your advertising accounts", false),
        R_ADS_LEADGEN_AUTOMATION("r_ads_leadgen_automation", "Access your Lead Gen Forms and retrieve leads", false),
        R_ADS_REPORTING("r_ads_reporting", "Retrieve reporting for your advertising accounts", false),
        R_BASICPROFILE("r_basicprofile", "Use your basic profile including your name, photo, headline, and current positions", false),
        R_ORGANIZATION_SOCIAL("r_organization_social", "Retrieve your organizations' posts, including any comments, likes and other engagement data", false),
        RW_AD_CAMPAIGNS("rw_ad_campaigns", "Manage your advertising campaigns", false),
        RW_ADS("rw_ads", "Manage your advertising accounts", false),
        RW_COMPANY_ADMIN("rw_company_admin", "For V1 callsManage your organization's page and post updates", false),
        RW_DMP_SEGMENTS("rw_dmp_segments", "Create and manage your matched audiences", false),
        RW_ORGANIZATION_ADMIN("rw_organization_admin", "Manage your organizations' pages and retrieve reporting data", false),
        RW_ORGANIZATION("rw_organization", "For V2 callsManage your organization's page and post updates", false),
        W_ORGANIZATION_SOCIAL("w_organization_social", "Post, comment and like posts on your organization's behalf", false),
        W_SHARE("w_share", "Post updates to LinkedIn as you", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Linkedin(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Line implements Scope
    {
        PROFILE("profile", "Get profile details", true),
        OPENID("openid", "Get id token", true),
        EMAIL("email", "Get email (separate authorization required)", false);

        private final String scope;
        private final String description;
        private final boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Line(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Kujiale implements Scope
    {
        GET_USER_INFO("get_user_info", "\u83b7\u53d6\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f", true),
        GET_DESIGN("get_design", "\u83b7\u53d6\u6307\u5b9a\u65b9\u6848\u8be6\u60c5", false),
        GET_BUDGET_LIST("get_budget_list", "\u83b7\u53d6\u6e05\u5355\u9884\u7b97\u6982\u89c8\u6570\u636e", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Kujiale(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Jd implements Scope
    {
        SNSAPI_BASE("snsapi_base", "\u57fa\u7840\u6388\u6743", true);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Jd(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Huawei implements Scope
    {
        BASE_PROFILE("https://www.huawei.com/auth/account/base.profile", "\u83b7\u53d6\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f", true),
        MOBILE_NUMBER("https://www.huawei.com/auth/account/mobile.number", "\u83b7\u53d6\u7528\u6237\u7684\u624b\u673a\u53f7", false),
        ACCOUNTLIST("https://www.huawei.com/auth/account/accountlist", "\u83b7\u53d6\u7528\u6237\u7684\u8d26\u5355\u5217\u8868", false),
        SCOPE_DRIVE_FILE("https://www.huawei.com/auth/drive.file", "\u53ea\u5141\u8bb8\u8bbf\u95ee\u7531\u5e94\u7528\u7a0b\u5e8f\u521b\u5efa\u6216\u6253\u5f00\u7684\u6587\u4ef6", false),
        SCOPE_DRIVE_APPDATA("https://www.huawei.com/auth/drive.appdata", "\u53ea\u5141\u8bb8\u8bbf\u95ee\u7531\u5e94\u7528\u7a0b\u5e8f\u521b\u5efa\u6216\u6253\u5f00\u7684\u6587\u4ef6", false),
        SCOPE_DRIVE("https://www.huawei.com/auth/drive", "\u53ea\u5141\u8bb8\u8bbf\u95ee\u7531\u5e94\u7528\u7a0b\u5e8f\u521b\u5efa\u6216\u6253\u5f00\u7684\u6587\u4ef6", false),
        SCOPE_DRIVE_READONLY("https://www.huawei.com/auth/drive.readonly", "\u53ea\u5141\u8bb8\u8bbf\u95ee\u7531\u5e94\u7528\u7a0b\u5e8f\u521b\u5efa\u6216\u6253\u5f00\u7684\u6587\u4ef6", false),
        SCOPE_DRIVE_METADATA("https://www.huawei.com/auth/drive.metadata", "\u53ea\u5141\u8bb8\u8bbf\u95ee\u7531\u5e94\u7528\u7a0b\u5e8f\u521b\u5efa\u6216\u6253\u5f00\u7684\u6587\u4ef6", false),
        SCOPE_DRIVE_METADATA_READONLY("https://www.huawei.com/auth/drive.metadata.readonly", "\u53ea\u5141\u8bb8\u8bbf\u95ee\u7531\u5e94\u7528\u7a0b\u5e8f\u521b\u5efa\u6216\u6253\u5f00\u7684\u6587\u4ef6", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Huawei(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Google implements Scope
    {
        USER_OPENID("openid", "Associate you with your personal info on Google", true),
        USER_EMAIL("email", "View your email address", true),
        USER_PROFILE("profile", "View your basic profile info", true),
        USER_PHONENUMBERS_READ("https://www.googleapis.com/auth/user.phonenumbers.read", "View your phone numbers", false),
        USER_ORGANIZATION_READ("https://www.googleapis.com/auth/user.organization.read", "See your education, work history and org info", false),
        USER_GENDER_READ("https://www.googleapis.com/auth/user.gender.read", "See your gender", false),
        USER_EMAILS_READ("https://www.googleapis.com/auth/user.emails.read", "View your email addresses", false),
        USER_BIRTHDAY_READ("https://www.googleapis.com/auth/user.birthday.read", "View your complete date of birth", false),
        USER_ADDRESSES_READ("https://www.googleapis.com/auth/user.addresses.read", "View your street addresses", false),
        USERINFO_PROFILE("https://www.googleapis.com/auth/userinfo.profile", "See your personal info, including any personal info you've made publicly available", false),
        USERINFO_EMAIL("https://www.googleapis.com/auth/userinfo.email", "View your email address", false),
        YT_ANALYTICS_READONLY("https://www.googleapis.com/auth/yt-analytics.readonly", "View YouTube Analytics reports for your YouTube content", false),
        YT_ANALYTICS_MONETARY_READONLY("https://www.googleapis.com/auth/yt-analytics-monetary.readonly", "View monetary and non-monetary YouTube Analytics reports for your YouTube content", false),
        YOUTUBEPARTNER_CHANNEL_AUDIT("https://www.googleapis.com/auth/youtubepartner-channel-audit", "View private information of your YouTube channel relevant during the audit process with a YouTube partner", false),
        YOUTUBEPARTNER("https://www.googleapis.com/auth/youtubepartner", "View and manage your assets and associated content on YouTube", false),
        YOUTUBE_UPLOAD("https://www.googleapis.com/auth/youtube.upload", "Manage your YouTube videos", false),
        YOUTUBE_READONLY("https://www.googleapis.com/auth/youtube.readonly", "View your YouTube account", false),
        YOUTUBE_FORCE_SSL("https://www.googleapis.com/auth/youtube.force-ssl", "See, edit, and permanently delete your YouTube videos, ratings, comments and captions", false),
        YOUTUBE_CHANNEL_MEMBERSHIPS_CREATOR("https://www.googleapis.com/auth/youtube.channel-memberships.creator", "See a list of your current active channel members, their current level, and when they became a member", false),
        YOUTUBE("https://www.googleapis.com/auth/youtube", "Manage your YouTube account", false),
        WEBMASTERS_READONLY("https://www.googleapis.com/auth/webmasters.readonly", "View Search Console data for your verified sites", false),
        WEBMASTERS("https://www.googleapis.com/auth/webmasters", "View and manage Search Console data for your verified sites", false),
        VERIFIEDACCESS("https://www.googleapis.com/auth/verifiedaccess", "Verify your enterprise credentials", false),
        TRACE_APPEND("https://www.googleapis.com/auth/trace.append", "Write Trace data for a project or application", false),
        TASKS_READONLY("https://www.googleapis.com/auth/tasks.readonly", "View your tasks", false),
        TASKS("https://www.googleapis.com/auth/tasks", "Create, edit, organize, and delete all your tasks", false),
        TAGMANAGER_READONLY("https://www.googleapis.com/auth/tagmanager.readonly", "View your Google Tag Manager container and its subcomponents", false),
        TAGMANAGER_PUBLISH("https://www.googleapis.com/auth/tagmanager.publish", "Publish your Google Tag Manager container versions", false),
        TAGMANAGER_MANAGE_USERS("https://www.googleapis.com/auth/tagmanager.manage.users", "Manage user permissions of your Google Tag Manager account and container", false),
        TAGMANAGER_MANAGE_ACCOUNTS("https://www.googleapis.com/auth/tagmanager.manage.accounts", "View and manage your Google Tag Manager accounts", false),
        TAGMANAGER_EDIT_CONTAINERVERSIONS("https://www.googleapis.com/auth/tagmanager.edit.containerversions", "Manage your Google Tag Manager container versions", false),
        TAGMANAGER_EDIT_CONTAINERS("https://www.googleapis.com/auth/tagmanager.edit.containers", "Manage your Google Tag Manager container and its subcomponents, excluding versioning and publishing", false),
        TAGMANAGER_DELETE_CONTAINERS("https://www.googleapis.com/auth/tagmanager.delete.containers", "Delete your Google Tag Manager containers", false),
        STREETVIEWPUBLISH("https://www.googleapis.com/auth/streetviewpublish", "Publish and manage your 360 photos on Google Street View", false),
        SQLSERVICE_ADMIN("https://www.googleapis.com/auth/sqlservice.admin", "Manage your Google SQL Service instances", false),
        SPREADSHEETS_READONLY("https://www.googleapis.com/auth/spreadsheets.readonly", "View your Google Spreadsheets", false),
        SPREADSHEETS("https://www.googleapis.com/auth/spreadsheets", "See, edit, create, and delete your spreadsheets in Google Drive", false),
        SPANNER_DATA("https://www.googleapis.com/auth/spanner.data", "View and manage the contents of your Spanner databases", false),
        SPANNER_ADMIN("https://www.googleapis.com/auth/spanner.admin", "Administer your Spanner databases", false),
        SOURCE_READ_WRITE("https://www.googleapis.com/auth/source.read_write", "Manage the contents of your source code repositories", false),
        SOURCE_READ_ONLY("https://www.googleapis.com/auth/source.read_only", "View the contents of your source code repositories", false),
        SOURCE_FULL_CONTROL("https://www.googleapis.com/auth/source.full_control", "Manage your source code repositories", false),
        SITEVERIFICATION_VERIFY_ONLY("https://www.googleapis.com/auth/siteverification.verify_only", "Manage your new site verifications with Google", false),
        SITEVERIFICATION("https://www.googleapis.com/auth/siteverification", "Manage the list of sites and domains you control", false),
        SERVICECONTROL("https://www.googleapis.com/auth/servicecontrol", "Manage your Google Service Control data", false),
        SERVICE_MANAGEMENT_READONLY("https://www.googleapis.com/auth/service.management.readonly", "View your Google API service configuration", false),
        SERVICE_MANAGEMENT("https://www.googleapis.com/auth/service.management", "Manage your Google API service configuration", false),
        SCRIPT_PROJECTS_READONLY("https://www.googleapis.com/auth/script.projects.readonly", "View Google Apps Script projects", false),
        SCRIPT_PROJECTS("https://www.googleapis.com/auth/script.projects", "Create and update Google Apps Script projects", false),
        SCRIPT_PROCESSES("https://www.googleapis.com/auth/script.processes", "View Google Apps Script processes", false),
        SCRIPT_METRICS("https://www.googleapis.com/auth/script.metrics", "View Google Apps Script project's metrics", false),
        SCRIPT_DEPLOYMENTS_READONLY("https://www.googleapis.com/auth/script.deployments.readonly", "View Google Apps Script deployments", false),
        SCRIPT_DEPLOYMENTS("https://www.googleapis.com/auth/script.deployments", "Create and update Google Apps Script deployments", false),
        PUBSUB("https://www.googleapis.com/auth/pubsub", "View and manage Pub/Sub topics and subscriptions", false),
        PRESENTATIONS_READONLY("https://www.googleapis.com/auth/presentations.readonly", "View your Google Slides presentations", false),
        PRESENTATIONS("https://www.googleapis.com/auth/presentations", "View and manage your Google Slides presentations", false),
        PHOTOSLIBRARY_SHARING("https://www.googleapis.com/auth/photoslibrary.sharing", "Manage and add to shared albums on your behalf", false),
        PHOTOSLIBRARY_READONLY_APPCREATEDDATA("https://www.googleapis.com/auth/photoslibrary.readonly.appcreateddata", "Manage photos added by this app", false),
        PHOTOSLIBRARY_READONLY("https://www.googleapis.com/auth/photoslibrary.readonly", "View your Google Photos library", false),
        PHOTOSLIBRARY_APPENDONLY("https://www.googleapis.com/auth/photoslibrary.appendonly", "Add to your Google Photos library", false),
        PHOTOSLIBRARY("https://www.googleapis.com/auth/photoslibrary", "View and manage your Google Photos library", false),
        NDEV_CLOUDMAN_READONLY("https://www.googleapis.com/auth/ndev.cloudman.readonly", "View your Google Cloud Platform management resources and deployment status information", false),
        NDEV_CLOUDMAN("https://www.googleapis.com/auth/ndev.cloudman", "View and manage your Google Cloud Platform management resources and deployment status information", false),
        NDEV_CLOUDDNS_READWRITE("https://www.googleapis.com/auth/ndev.clouddns.readwrite", "View and manage your DNS records hosted by Google Cloud DNS", false),
        NDEV_CLOUDDNS_READONLY("https://www.googleapis.com/auth/ndev.clouddns.readonly", "View your DNS records hosted by Google Cloud DNS", false),
        MONITORING_WRITE("https://www.googleapis.com/auth/monitoring.write", "Publish metric data to your Google Cloud projects", false),
        MONITORING_READ("https://www.googleapis.com/auth/monitoring.read", "View monitoring data for all of your Google Cloud and third-party projects", false),
        MONITORING("https://www.googleapis.com/auth/monitoring", "View and write monitoring data for all of your Google and third-party Cloud and API projects", false),
        MANUFACTURERCENTER("https://www.googleapis.com/auth/manufacturercenter", "Manage your product listings for Google Manufacturer Center", false),
        LOGGING_WRITE("https://www.googleapis.com/auth/logging.write", "Submit log data for your projects", false),
        LOGGING_READ("https://www.googleapis.com/auth/logging.read", "View log data for your projects", false),
        LOGGING_ADMIN("https://www.googleapis.com/auth/logging.admin", "Administrate log data for your projects", false),
        JOBS("https://www.googleapis.com/auth/jobs", "Manage job postings", false),
        INDEXING("https://www.googleapis.com/auth/indexing", "Submit data to Google for indexing", false),
        GROUPS("https://www.googleapis.com/auth/groups", "View and manage your Google Groups", false),
        GMAIL("https://mail.google.com/", "Read, compose, send, and permanently delete all your email from Gmail", false),
        GMAIL_SETTINGS_SHARING("https://www.googleapis.com/auth/gmail.settings.sharing", "Manage your sensitive mail settings, including who can manage your mail", false),
        GMAIL_SETTINGS_BASIC("https://www.googleapis.com/auth/gmail.settings.basic", "Manage your basic mail settings", false),
        GMAIL_SEND("https://www.googleapis.com/auth/gmail.send", "Send email on your behalf", false),
        GMAIL_READONLY("https://www.googleapis.com/auth/gmail.readonly", "View your email messages and settings", false),
        GMAIL_MODIFY("https://www.googleapis.com/auth/gmail.modify", "View and modify but not delete your email", false),
        GMAIL_METADATA("https://www.googleapis.com/auth/gmail.metadata", "View your email message metadata such as labels and headers, but not the email body", false),
        GMAIL_LABELS("https://www.googleapis.com/auth/gmail.labels", "Manage mailbox labels", false),
        GMAIL_INSERT("https://www.googleapis.com/auth/gmail.insert", "Insert mail into your mailbox", false),
        GMAIL_COMPOSE("https://www.googleapis.com/auth/gmail.compose", "Manage drafts and send emails", false),
        GMAIL_ADDONS_CURRENT_MESSAGE_READONLY("https://www.googleapis.com/auth/gmail.addons.current.message.readonly", "View your email messages when the add-on is running", false),
        GMAIL_ADDONS_CURRENT_MESSAGE_METADATA("https://www.googleapis.com/auth/gmail.addons.current.message.metadata", "View your email message metadata when the add-on is running", false),
        GMAIL_ADDONS_CURRENT_MESSAGE_ACTION("https://www.googleapis.com/auth/gmail.addons.current.message.action", "View your email messages when you interact with the add-on", false),
        GMAIL_ADDONS_CURRENT_ACTION_COMPOSE("https://www.googleapis.com/auth/gmail.addons.current.action.compose", "Manage drafts and send emails when you interact with the add-on", false),
        GENOMICS("https://www.googleapis.com/auth/genomics", "View and manage Genomics data", false),
        GAMES("https://www.googleapis.com/auth/games", "Create, edit, and delete your Google Play Games activity", false),
        FORMS_CURRENTONLY("https://www.googleapis.com/auth/forms.currentonly", "View and manage forms that this application has been installed in", false),
        FORMS("https://www.googleapis.com/auth/forms", "View and manage your forms in Google Drive", false),
        FITNESS_REPRODUCTIVE_HEALTH_WRITE("https://www.googleapis.com/auth/fitness.reproductive_health.write", "See and add info about your reproductive health in Google Fit. I consent to Google sharing my reporductive health information with this app.", false),
        FITNESS_REPRODUCTIVE_HEALTH_READ("https://www.googleapis.com/auth/fitness.reproductive_health.read", "See info about your reproductive health in Google Fit. I consent to Google sharing my reporductive health information with this app.", false),
        FITNESS_OXYGEN_SATURATION_WRITE("https://www.googleapis.com/auth/fitness.oxygen_saturation.write", "See and add info about your oxygen saturation in Google Fit. I consent to Google sharing my oxygen saturation information with this app.", false),
        FITNESS_OXYGEN_SATURATION_READ("https://www.googleapis.com/auth/fitness.oxygen_saturation.read", "See info about your oxygen saturation in Google Fit. I consent to Google sharing my oxygen saturation information with this app.", false),
        FITNESS_NUTRITION_WRITE("https://www.googleapis.com/auth/fitness.nutrition.write", "See and add to info about your nutrition in Google Fit", false),
        FITNESS_NUTRITION_READ("https://www.googleapis.com/auth/fitness.nutrition.read", "See info about your nutrition in Google Fit", false),
        FITNESS_LOCATION_WRITE("https://www.googleapis.com/auth/fitness.location.write", "See and add to your Google Fit location data", false),
        FITNESS_LOCATION_READ("https://www.googleapis.com/auth/fitness.location.read", "See your Google Fit speed and distance data", false),
        FITNESS_BODY_TEMPERATURE_WRITE("https://www.googleapis.com/auth/fitness.body_temperature.write", "See and add to info about your body temperature in Google Fit. I consent to Google sharing my body temperature information with this app.", false),
        FITNESS_BODY_TEMPERATURE_READ("https://www.googleapis.com/auth/fitness.body_temperature.read", "See info about your body temperature in Google Fit. I consent to Google sharing my body temperature information with this app.", false),
        FITNESS_BODY_WRITE("https://www.googleapis.com/auth/fitness.body.write", "See and add info about your body measurements and heart rate to Google Fit", false),
        FITNESS_BODY_READ("https://www.googleapis.com/auth/fitness.body.read", "See info about your body measurements and heart rate in Google Fit", false),
        FITNESS_BLOOD_PRESSURE_WRITE("https://www.googleapis.com/auth/fitness.blood_pressure.write", "See and add info about your blood pressure in Google Fit. I consent to Google sharing my blood pressure information with this app.", false),
        FITNESS_BLOOD_PRESSURE_READ("https://www.googleapis.com/auth/fitness.blood_pressure.read", "See info about your blood pressure in Google Fit. I consent to Google sharing my blood pressure information with this app.", false),
        FITNESS_BLOOD_GLUCOSE_WRITE("https://www.googleapis.com/auth/fitness.blood_glucose.write", "See and add info about your blood glucose to Google Fit. I consent to Google sharing my blood glucose information with this app.", false),
        FITNESS_BLOOD_GLUCOSE_READ("https://www.googleapis.com/auth/fitness.blood_glucose.read", "See info about your blood glucose in Google Fit. I consent to Google sharing my blood glucose information with this app.", false),
        FITNESS_ACTIVITY_WRITE("https://www.googleapis.com/auth/fitness.activity.write", "See and add to your Google Fit physical activity data", false),
        FITNESS_ACTIVITY_READ("https://www.googleapis.com/auth/fitness.activity.read", "Use Google Fit to see and store your physical activity data", false),
        FIREBASE_READONLY("https://www.googleapis.com/auth/firebase.readonly", "View all your Firebase data and settings", false),
        FIREBASE("https://www.googleapis.com/auth/firebase", "View and administer all your Firebase data and settings", false),
        EDISCOVERY_READONLY("https://www.googleapis.com/auth/ediscovery.readonly", "View your eDiscovery data", false),
        EDISCOVERY("https://www.googleapis.com/auth/ediscovery", "Manage your eDiscovery data", false),
        DRIVE_SCRIPTS("https://www.googleapis.com/auth/drive.scripts", "Modify your Google Apps Script scripts' behavior", false),
        DRIVE_READONLY("https://www.googleapis.com/auth/drive.readonly", "See and download all your Google Drive files", false),
        DRIVE_PHOTOS_READONLY("https://www.googleapis.com/auth/drive.photos.readonly", "View the photos, videos and albums in your Google Photos", false),
        DRIVE_METADATA_READONLY("https://www.googleapis.com/auth/drive.metadata.readonly", "View metadata for files in your Google Drive", false),
        DRIVE_METADATA("https://www.googleapis.com/auth/drive.metadata", "View and manage metadata of files in your Google Drive", false),
        DRIVE_FILE("https://www.googleapis.com/auth/drive.file", "View and manage Google Drive files and folders that you have opened or created with this app", false),
        DRIVE_APPDATA("https://www.googleapis.com/auth/drive.appdata", "View and manage its own configuration data in your Google Drive", false),
        DRIVE_ACTIVITY_READONLY("https://www.googleapis.com/auth/drive.activity.readonly", "View the activity record of files in your Google Drive", false),
        DRIVE_ACTIVITY("https://www.googleapis.com/auth/drive.activity", "View and add to the activity record of files in your Google Drive", false),
        DRIVE("https://www.googleapis.com/auth/drive", "See, edit, create, and delete all of your Google Drive files", false),
        ACTIVITY("https://www.googleapis.com/auth/activity", "View the activity history of your Google apps", false),
        DOUBLECLICKSEARCH("https://www.googleapis.com/auth/doubleclicksearch", "View and manage your advertising data in DoubleClick Search", false),
        DOUBLECLICKBIDMANAGER("https://www.googleapis.com/auth/doubleclickbidmanager", "View and manage your reports in DoubleClick Bid Manager", false),
        DOCUMENTS_READONLY("https://www.googleapis.com/auth/documents.readonly", "View your Google Docs documents", false),
        DOCUMENTS("https://www.googleapis.com/auth/documents", "View and manage your Google Docs documents", false),
        DISPLAY_VIDEO("https://www.googleapis.com/auth/display-video", "Create, see, edit, and permanently delete your Display & Video 360 entities and reports", false),
        DIRECTORY_READONLY("https://www.googleapis.com/auth/directory.readonly", "See and download your organization's GSuite directory", false),
        DIALOGFLOW("https://www.googleapis.com/auth/dialogflow", "View, manage and query your Dialogflow agents", false),
        DFATRAFFICKING("https://www.googleapis.com/auth/dfatrafficking", "View and manage your DoubleClick Campaign Manager's (DCM) display ad campaigns", false),
        DFAREPORTING("https://www.googleapis.com/auth/dfareporting", "View and manage DoubleClick for Advertisers reports", false),
        DEVSTORAGE_READ_WRITE("https://www.googleapis.com/auth/devstorage.read_write", "Manage your data in Google Cloud Storage", false),
        DEVSTORAGE_READ_ONLY("https://www.googleapis.com/auth/devstorage.read_only", "View your data in Google Cloud Storage", false),
        DEVSTORAGE_FULL_CONTROL("https://www.googleapis.com/auth/devstorage.full_control", "Manage your data and permissions in Google Cloud Storage", false),
        DDMCONVERSIONS("https://www.googleapis.com/auth/ddmconversions", "Manage DoubleClick Digital Marketing conversions", false),
        DATASTORE("https://www.googleapis.com/auth/datastore", "View and manage your Google Cloud Datastore data", false),
        CONTENT("https://www.googleapis.com/auth/content", "Manage your product listings and accounts for Google Shopping", false),
        CONTACTS_READONLY("https://www.googleapis.com/auth/contacts.readonly", "See and download your contacts", false),
        CONTACTS_OTHER_READONLY("https://www.googleapis.com/auth/contacts.other.readonly", "See and download contact info automatically saved in your \"Other contacts\"", false),
        CONTACTS("https://www.googleapis.com/auth/contacts", "See, edit, download, and permanently delete your contacts", false),
        CONTACTS_FEEDS("https://www.google.com/m8/feeds", "See, edit, download, and permanently delete your contacts", false),
        COMPUTE_READONLY("https://www.googleapis.com/auth/compute.readonly", "View your Google Compute Engine resources", false),
        COMPUTE("https://www.googleapis.com/auth/compute", "View and manage your Google Compute Engine resources", false),
        CLOUDRUNTIMECONFIG("https://www.googleapis.com/auth/cloudruntimeconfig", "Manage your Google Cloud Platform services' runtime configuration", false),
        CLOUDKMS("https://www.googleapis.com/auth/cloudkms", "View and manage your keys and secrets stored in Cloud Key Management Service", false),
        CLOUDIOT("https://www.googleapis.com/auth/cloudiot", "Register and manage devices in the Google Cloud IoT service", false),
        CLOUD_SEARCH_STATS_INDEXING("https://www.googleapis.com/auth/cloud_search.stats.indexing", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH_STATS("https://www.googleapis.com/auth/cloud_search.stats", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH_SETTINGS_QUERY("https://www.googleapis.com/auth/cloud_search.settings.query", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH_SETTINGS_INDEXING("https://www.googleapis.com/auth/cloud_search.settings.indexing", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH_SETTINGS("https://www.googleapis.com/auth/cloud_search.settings", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH_QUERY("https://www.googleapis.com/auth/cloud_search.query", "Search your organization's data in the Cloud Search index", false),
        CLOUD_SEARCH_INDEXING("https://www.googleapis.com/auth/cloud_search.indexing", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH_DEBUG("https://www.googleapis.com/auth/cloud_search.debug", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_SEARCH("https://www.googleapis.com/auth/cloud_search", "Index and serve your organization's data with Cloud Search", false),
        CLOUD_DEBUGGER("https://www.googleapis.com/auth/cloud_debugger", "Use Stackdriver Debugger", false),
        CLOUD_VISION("https://www.googleapis.com/auth/cloud-vision", "Apply machine learning models to understand and label images", false),
        CLOUD_TRANSLATION("https://www.googleapis.com/auth/cloud-translation", "Translate text from one language to another using Google Translate", false),
        CLOUD_PLATFORM_READ_ONLY("https://www.googleapis.com/auth/cloud-platform.read-only", "View your data across Google Cloud Platform services", false),
        CLOUD_PLATFORM("https://www.googleapis.com/auth/cloud-platform", "View and manage your data across Google Cloud Platform services", false),
        CLOUD_LANGUAGE("https://www.googleapis.com/auth/cloud-language", "Apply machine learning models to reveal the structure and meaning of text", false),
        CLOUD_IDENTITY_GROUPS_READONLY("https://www.googleapis.com/auth/cloud-identity.groups.readonly", "See any Cloud Identity Groups that you can access, including group members and their emails", false),
        CLOUD_IDENTITY_GROUPS("https://www.googleapis.com/auth/cloud-identity.groups", "See, change, create, and delete any of the Cloud Identity Groups that you can access, including the members of each group", false),
        CLOUD_BIGTABLE_ADMIN_TABLE("https://www.googleapis.com/auth/cloud-bigtable.admin.table", "Administer your Cloud Bigtable tables", false),
        CLOUD_BIGTABLE_ADMIN_CLUSTER("https://www.googleapis.com/auth/cloud-bigtable.admin.cluster", "Administer your Cloud Bigtable clusters", false),
        CLOUD_BIGTABLE_ADMIN("https://www.googleapis.com/auth/cloud-bigtable.admin", "Administer your Cloud Bigtable tables and clusters", false),
        CLASSROOM_TOPICS_READONLY("https://www.googleapis.com/auth/classroom.topics.readonly", "View topics in Google Classroom", false),
        CLASSROOM_TOPICS("https://www.googleapis.com/auth/classroom.topics", "See, create, and edit topics in Google Classroom", false),
        CLASSROOM_STUDENT_SUBMISSIONS_STUDENTS_READONLY("https://www.googleapis.com/auth/classroom.student-submissions.students.readonly", "View course work and grades for students in the Google Classroom classes you teach or administer", false),
        CLASSROOM_STUDENT_SUBMISSIONS_ME_READONLY("https://www.googleapis.com/auth/classroom.student-submissions.me.readonly", "View your course work and grades in Google Classroom", false),
        CLASSROOM_ROSTERS_READONLY("https://www.googleapis.com/auth/classroom.rosters.readonly", "View your Google Classroom class rosters", false),
        CLASSROOM_ROSTERS("https://www.googleapis.com/auth/classroom.rosters", "Manage your Google Classroom class rosters", false),
        CLASSROOM_PUSH_NOTIFICATIONS("https://www.googleapis.com/auth/classroom.push-notifications", "Receive notifications about your Google Classroom data", false),
        CLASSROOM_PROFILE_PHOTOS("https://www.googleapis.com/auth/classroom.profile.photos", "View the profile photos of people in your classes", false),
        CLASSROOM_PROFILE_EMAILS("https://www.googleapis.com/auth/classroom.profile.emails", "View the email addresses of people in your classes", false),
        CLASSROOM_GUARDIANLINKS_STUDENTS_READONLY("https://www.googleapis.com/auth/classroom.guardianlinks.students.readonly", "View guardians for students in your Google Classroom classes", false),
        CLASSROOM_GUARDIANLINKS_STUDENTS("https://www.googleapis.com/auth/classroom.guardianlinks.students", "View and manage guardians for students in your Google Classroom classes", false),
        CLASSROOM_GUARDIANLINKS_ME_READONLY("https://www.googleapis.com/auth/classroom.guardianlinks.me.readonly", "View your Google Classroom guardians", false),
        CLASSROOM_COURSEWORK_STUDENTS_READONLY("https://www.googleapis.com/auth/classroom.coursework.students.readonly", "View course work and grades for students in the Google Classroom classes you teach or administer", false),
        CLASSROOM_COURSEWORK_STUDENTS("https://www.googleapis.com/auth/classroom.coursework.students", "Manage course work and grades for students in the Google Classroom classes you teach and view the course work and grades for classes you administer", false),
        CLASSROOM_COURSEWORK_ME_READONLY("https://www.googleapis.com/auth/classroom.coursework.me.readonly", "View your course work and grades in Google Classroom", false),
        CLASSROOM_COURSEWORK_ME("https://www.googleapis.com/auth/classroom.coursework.me", "Manage your course work and view your grades in Google Classroom", false),
        CLASSROOM_COURSES_READONLY("https://www.googleapis.com/auth/classroom.courses.readonly", "View your Google Classroom classes", false),
        CLASSROOM_COURSES("https://www.googleapis.com/auth/classroom.courses", "Manage your Google Classroom classes", false),
        CLASSROOM_ANNOUNCEMENTS_READONLY("https://www.googleapis.com/auth/classroom.announcements.readonly", "View announcements in Google Classroom", false),
        CLASSROOM_ANNOUNCEMENTS("https://www.googleapis.com/auth/classroom.announcements", "View and manage announcements in Google Classroom", false),
        CALENDAR_SETTINGS_READONLY("https://www.googleapis.com/auth/calendar.settings.readonly", "View your Calendar settings", false),
        CALENDAR_READONLY("https://www.googleapis.com/auth/calendar.readonly", "View your calendars", false),
        CALENDAR_EVENTS_READONLY("https://www.googleapis.com/auth/calendar.events.readonly", "View events on all your calendars", false),
        CALENDAR_EVENTS("https://www.googleapis.com/auth/calendar.events", "View and edit events on all your calendars", false),
        CALENDAR("https://www.googleapis.com/auth/calendar", "See, edit, share, and permanently delete all the calendars you can access using Google Calendar", false),
        CALENDAR_FEEDS("https://www.google.com/calendar/feeds", "See, edit, share, and permanently delete all the calendars you can access using Google Calendar", false),
        BOOKS("https://www.googleapis.com/auth/books", "Manage your books", false),
        BLOGGER_READONLY("https://www.googleapis.com/auth/blogger.readonly", "View your Blogger account", false),
        BLOGGER("https://www.googleapis.com/auth/blogger", "Manage your Blogger account", false),
        BIGTABLE_ADMIN_TABLE("https://www.googleapis.com/auth/bigtable.admin.table", "Administer your Cloud Bigtable tables", false),
        BIGTABLE_ADMIN_INSTANCE("https://www.googleapis.com/auth/bigtable.admin.instance", "Administer your Cloud Bigtable clusters", false),
        BIGTABLE_ADMIN_CLUSTER("https://www.googleapis.com/auth/bigtable.admin.cluster", "Administer your Cloud Bigtable clusters", false),
        BIGTABLE_ADMIN("https://www.googleapis.com/auth/bigtable.admin", "Administer your Cloud Bigtable tables and clusters", false),
        BIGQUERY_READONLY("https://www.googleapis.com/auth/bigquery.readonly", "View your data in Google BigQuery", false),
        BIGQUERY_INSERTDATA("https://www.googleapis.com/auth/bigquery.insertdata", "Insert data into Google BigQuery", false),
        BIGQUERY("https://www.googleapis.com/auth/bigquery", "View and manage your data in Google BigQuery", false),
        APPS_ORDER_READONLY("https://www.googleapis.com/auth/apps.order.readonly", "Manage users on your domain", false),
        APPS_ORDER("https://www.googleapis.com/auth/apps.order", "Manage users on your domain", false),
        APPS_LICENSING("https://www.googleapis.com/auth/apps.licensing", "View and manage G Suite licenses for your domain", false),
        APPS_GROUPS_SETTINGS("https://www.googleapis.com/auth/apps.groups.settings", "View and manage the settings of a G Suite group", false),
        APPS_GROUPS_MIGRATION("https://www.googleapis.com/auth/apps.groups.migration", "Manage messages in groups on your domain", false),
        APPS_ALERTS("https://www.googleapis.com/auth/apps.alerts", "See and delete your domain's G Suite alerts, and send alert feedback", false),
        APPENGINE_ADMIN("https://www.googleapis.com/auth/appengine.admin", "View and manage your applications deployed on Google App Engine", false),
        ANDROIDPUBLISHER("https://www.googleapis.com/auth/androidpublisher", "View and manage your Google Play Developer account", false),
        ANDROIDMANAGEMENT("https://www.googleapis.com/auth/androidmanagement", "Manage Android devices and apps for your customers", false),
        ANDROIDENTERPRISE("https://www.googleapis.com/auth/androidenterprise", "Manage corporate Android devices", false),
        ANALYTICS_USER_DELETION("https://www.googleapis.com/auth/analytics.user.deletion", "Manage Google Analytics user deletion requests", false),
        ANALYTICS_READONLY("https://www.googleapis.com/auth/analytics.readonly", "View your Google Analytics data", false),
        ANALYTICS_PROVISION("https://www.googleapis.com/auth/analytics.provision", "Create a new Google Analytics account along with its default property and view", false),
        ANALYTICS_MANAGE_USERS_READONLY("https://www.googleapis.com/auth/analytics.manage.users.readonly", "View Google Analytics user permissions", false),
        ANALYTICS_MANAGE_USERS("https://www.googleapis.com/auth/analytics.manage.users", "Manage Google Analytics Account users by email address", false),
        ANALYTICS_EDIT("https://www.googleapis.com/auth/analytics.edit", "Edit Google Analytics management entities", false),
        ANALYTICS("https://www.googleapis.com/auth/analytics", "View and manage your Google Analytics data", false),
        ADSENSEHOST("https://www.googleapis.com/auth/adsensehost", "View and manage your AdSense host data and associated accounts", false),
        ADSENSE_READONLY("https://www.googleapis.com/auth/adsense.readonly", "View your AdSense data", false),
        ADSENSE("https://www.googleapis.com/auth/adsense", "View and manage your AdSense data", false),
        ADMIN_REPORTS_USAGE_READONLY("https://www.googleapis.com/auth/admin.reports.usage.readonly", "View usage reports for your G Suite domain", false),
        ADMIN_REPORTS_AUDIT_READONLY("https://www.googleapis.com/auth/admin.reports.audit.readonly", "View audit reports for your G Suite domain", false),
        ADMIN_DIRECTORY_USERSCHEMA_READONLY("https://www.googleapis.com/auth/admin.directory.userschema.readonly", "View user schemas on your domain", false),
        ADMIN_DIRECTORY_USERSCHEMA("https://www.googleapis.com/auth/admin.directory.userschema", "View and manage the provisioning of user schemas on your domain", false),
        ADMIN_DIRECTORY_USER_SECURITY("https://www.googleapis.com/auth/admin.directory.user.security", "Manage data access permissions for users on your domain", false),
        ADMIN_DIRECTORY_USER_READONLY("https://www.googleapis.com/auth/admin.directory.user.readonly", "View users on your domain", false),
        ADMIN_DIRECTORY_USER_ALIAS_READONLY("https://www.googleapis.com/auth/admin.directory.user.alias.readonly", "View user aliases on your domain", false),
        ADMIN_DIRECTORY_USER_ALIAS("https://www.googleapis.com/auth/admin.directory.user.alias", "View and manage user aliases on your domain", false),
        ADMIN_DIRECTORY_USER("https://www.googleapis.com/auth/admin.directory.user", "View and manage the provisioning of users on your domain", false),
        ADMIN_DIRECTORY_ROLEMANAGEMENT_READONLY("https://www.googleapis.com/auth/admin.directory.rolemanagement.readonly", "View delegated admin roles for your domain", false),
        ADMIN_DIRECTORY_ROLEMANAGEMENT("https://www.googleapis.com/auth/admin.directory.rolemanagement", "Manage delegated admin roles for your domain", false),
        ADMIN_DIRECTORY_RESOURCE_CALENDAR_READONLY("https://www.googleapis.com/auth/admin.directory.resource.calendar.readonly", "View calendar resources on your domain", false),
        ADMIN_DIRECTORY_RESOURCE_CALENDAR("https://www.googleapis.com/auth/admin.directory.resource.calendar", "View and manage the provisioning of calendar resources on your domain", false),
        ADMIN_DIRECTORY_ORGUNIT_READONLY("https://www.googleapis.com/auth/admin.directory.orgunit.readonly", "View organization units on your domain", false),
        ADMIN_DIRECTORY_ORGUNIT("https://www.googleapis.com/auth/admin.directory.orgunit", "View and manage organization units on your domain", false),
        ADMIN_DIRECTORY_NOTIFICATIONS("https://www.googleapis.com/auth/admin.directory.notifications", "View and manage notifications received on your domain", false),
        ADMIN_DIRECTORY_GROUP_READONLY("https://www.googleapis.com/auth/admin.directory.group.readonly", "View groups on your domain", false),
        ADMIN_DIRECTORY_GROUP_MEMBER_READONLY("https://www.googleapis.com/auth/admin.directory.group.member.readonly", "View group subscriptions on your domain", false),
        ADMIN_DIRECTORY_GROUP_MEMBER("https://www.googleapis.com/auth/admin.directory.group.member", "View and manage group subscriptions on your domain", false),
        ADMIN_DIRECTORY_GROUP("https://www.googleapis.com/auth/admin.directory.group", "View and manage the provisioning of groups on your domain", false),
        ADMIN_DIRECTORY_DOMAIN_READONLY("https://www.googleapis.com/auth/admin.directory.domain.readonly", "View domains related to your customers", false),
        ADMIN_DIRECTORY_DOMAIN("https://www.googleapis.com/auth/admin.directory.domain", "View and manage the provisioning of domains for your customers", false),
        ADMIN_DIRECTORY_DEVICE_MOBILE_READONLY("https://www.googleapis.com/auth/admin.directory.device.mobile.readonly", "View your mobile devices' metadata", false),
        ADMIN_DIRECTORY_DEVICE_MOBILE_ACTION("https://www.googleapis.com/auth/admin.directory.device.mobile.action", "Manage your mobile devices by performing administrative tasks", false),
        ADMIN_DIRECTORY_DEVICE_MOBILE("https://www.googleapis.com/auth/admin.directory.device.mobile", "View and manage your mobile devices' metadata", false),
        ADMIN_DIRECTORY_DEVICE_CHROMEOS_READONLY("https://www.googleapis.com/auth/admin.directory.device.chromeos.readonly", "View your Chrome OS devices' metadata", false),
        ADMIN_DIRECTORY_DEVICE_CHROMEOS("https://www.googleapis.com/auth/admin.directory.device.chromeos", "View and manage your Chrome OS devices' metadata", false),
        ADMIN_DIRECTORY_CUSTOMER_READONLY("https://www.googleapis.com/auth/admin.directory.customer.readonly", "View customer related information", false),
        ADMIN_DIRECTORY_CUSTOMER("https://www.googleapis.com/auth/admin.directory.customer", "View and manage customer related information", false),
        ADMIN_DATATRANSFER_READONLY("https://www.googleapis.com/auth/admin.datatransfer.readonly", "View data transfers between users in your organization", false),
        ADMIN_DATATRANSFER("https://www.googleapis.com/auth/admin.datatransfer", "View and manage data transfers between users in your organization", false),
        ADEXCHANGE_BUYER("https://www.googleapis.com/auth/adexchange.buyer", "Manage your Ad Exchange buyer account configuration", false);

        private String scope;
        private String description;
        private boolean isDefault;

        public static List<String> getAdminDirectoryScopes() {
            return Arrays.stream(new Google[]{ADMIN_DIRECTORY_USERSCHEMA_READONLY, ADMIN_DIRECTORY_USERSCHEMA, ADMIN_DIRECTORY_USER_SECURITY, ADMIN_DIRECTORY_USER_READONLY, ADMIN_DIRECTORY_USER_ALIAS_READONLY, ADMIN_DIRECTORY_USER_ALIAS, ADMIN_DIRECTORY_USER, ADMIN_DIRECTORY_ROLEMANAGEMENT_READONLY, ADMIN_DIRECTORY_ROLEMANAGEMENT, ADMIN_DIRECTORY_RESOURCE_CALENDAR_READONLY, ADMIN_DIRECTORY_RESOURCE_CALENDAR, ADMIN_DIRECTORY_ORGUNIT_READONLY, ADMIN_DIRECTORY_ORGUNIT, ADMIN_DIRECTORY_NOTIFICATIONS, ADMIN_DIRECTORY_GROUP_READONLY, ADMIN_DIRECTORY_GROUP_MEMBER_READONLY, ADMIN_DIRECTORY_GROUP_MEMBER, ADMIN_DIRECTORY_GROUP, ADMIN_DIRECTORY_DOMAIN_READONLY, ADMIN_DIRECTORY_DOMAIN, ADMIN_DIRECTORY_DEVICE_MOBILE_READONLY, ADMIN_DIRECTORY_DEVICE_MOBILE_ACTION, ADMIN_DIRECTORY_DEVICE_MOBILE, ADMIN_DIRECTORY_DEVICE_CHROMEOS_READONLY, ADMIN_DIRECTORY_DEVICE_CHROMEOS, ADMIN_DIRECTORY_CUSTOMER_READONLY, ADMIN_DIRECTORY_CUSTOMER}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getGmailScopes() {
            return Arrays.stream(new Google[]{GMAIL, GMAIL_SETTINGS_SHARING, GMAIL_SETTINGS_BASIC, GMAIL_SEND, GMAIL_READONLY, GMAIL_MODIFY, GMAIL_METADATA, GMAIL_LABELS, GMAIL_INSERT, GMAIL_COMPOSE, GMAIL_ADDONS_CURRENT_MESSAGE_READONLY, GMAIL_ADDONS_CURRENT_MESSAGE_METADATA, GMAIL_ADDONS_CURRENT_MESSAGE_ACTION, GMAIL_ADDONS_CURRENT_ACTION_COMPOSE}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getOidcScopes() {
            return Arrays.stream(new Google[]{USER_OPENID, USER_EMAIL, USER_PROFILE}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getPeopleScopes() {
            return Arrays.stream(new Google[]{CONTACTS_READONLY, CONTACTS_OTHER_READONLY, CONTACTS, CONTACTS_FEEDS, DIRECTORY_READONLY, USER_PHONENUMBERS_READ, USER_ORGANIZATION_READ, USER_GENDER_READ, USER_EMAILS_READ, USER_BIRTHDAY_READ, USER_ADDRESSES_READ, USERINFO_PROFILE, USERINFO_EMAIL}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getPhotosLibraryScopes() {
            return Arrays.stream(new Google[]{PHOTOSLIBRARY_SHARING, PHOTOSLIBRARY_READONLY_APPCREATEDDATA, PHOTOSLIBRARY_READONLY, PHOTOSLIBRARY_APPENDONLY, PHOTOSLIBRARY}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getYouTubeScopes() {
            return Arrays.stream(new Google[]{YT_ANALYTICS_READONLY, YT_ANALYTICS_MONETARY_READONLY, YOUTUBEPARTNER_CHANNEL_AUDIT, YOUTUBEPARTNER, YOUTUBE_UPLOAD, YOUTUBE_READONLY, YOUTUBE_FORCE_SSL, YOUTUBE_CHANNEL_MEMBERSHIPS_CREATOR, YOUTUBE}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getGoogleAnalyticsScopes() {
            return Arrays.stream(new Google[]{ANALYTICS_USER_DELETION, ANALYTICS_READONLY, ANALYTICS_PROVISION, ANALYTICS_MANAGE_USERS_READONLY, ANALYTICS_MANAGE_USERS, ANALYTICS_EDIT, ANALYTICS}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getCalendarScopes() {
            return Arrays.stream(new Google[]{CALENDAR_SETTINGS_READONLY, CALENDAR_READONLY, CALENDAR_EVENTS_READONLY, CALENDAR_EVENTS, CALENDAR, CALENDAR_FEEDS}).map(Google::getScope).collect(Collectors.toList());
        }

        public static List<String> getDriveScopes() {
            return Arrays.stream(new Google[]{DRIVE_SCRIPTS, DRIVE_READONLY, DRIVE_PHOTOS_READONLY, DRIVE_METADATA_READONLY, DRIVE_METADATA, DRIVE_FILE, DRIVE_APPDATA, DRIVE_ACTIVITY_READONLY, DRIVE_ACTIVITY, DRIVE, ACTIVITY}).map(Google::getScope).collect(Collectors.toList());
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Google(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Gitlab implements Scope
    {
        READ_USER("read_user", "Grants read-only access to the authenticated user's profile through the /user API endpoint, which includes username, public email, and full name. Also grants access to read-only API endpoints under /users.", true),
        OPENID("openid", "Grants permission to authenticate with GitLab using OpenID Connect. Also gives read-only access to the user's profile and group memberships.", true),
        PROFILE("profile", "Grants read-only access to the user's profile data using OpenID Connect.", true),
        EMAIL("email", "Grants read-only access to the user's primary email address using OpenID Connect.", true),
        READ_API("read_api", "Grants read access to the API, including all groups and projects, the container registry, and the package registry.", false),
        READ_REPOSITORY("read_repository", "Grants read-only access to repositories on private projects using Git-over-HTTP or the Repository Files API.", false),
        WRITE_REPOSITORY("write_repository", "Grants read-write access to repositories on private projects using Git-over-HTTP (not using the API).", false),
        READ_REGISTRY("read_registry", "Grants read-only access to container registry images on private projects.", false),
        WRITE_REGISTRY("write_registry", "<span title=\"translation missing: en.doorkeeper.scope_desc.write_registry\">Write Registry</span>", false),
        SUDO("sudo", "Grants permission to perform API actions as any user in the system, when authenticated as an admin user.", false),
        API("api", "Grants complete read/write access to the API, including all groups and projects, the container registry, and the package registry.", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Gitlab(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Github implements Scope
    {
        REPO_STATUS("repo:status", "Grants read/write access to public and private repository commit statuses. This scope is only necessary to grant other users or services access to private repository commit statuses <em>without</em> granting access to the code.", false),
        REPO_DEPLOYMENT("repo_deployment", "Grants access to deployment statuses for public and private repositories. This scope is only necessary to grant other users or services access to deployment statuses, <em>without</em> granting access to the code.", false),
        PUBLIC_REPO("public_repo", "Limits access to public repositories. That includes read/write access to code, commit statuses, repository projects, collaborators, and deployment statuses for public repositories and organizations. Also required for starring public repositories.", false),
        REPO_INVITE("repo:invite", "Grants accept/decline abilities for invitations to collaborate on a repository. This scope is only necessary to grant other users or services access to invites <em>without</em> granting access to the code.", false),
        SECURITY_EVENTS("security_events", "Grants read and write access to security events in the code scanning API.", false),
        WRITE_REPO_HOOK("write:repo_hook", "Grants read, write, and ping access to hooks in public or private repositories.", false),
        READ_REPO_HOOK("read:repo_hook", "Grants read and ping access to hooks in public or private repositories.", false),
        ADMIN_ORG("admin:org", "Fully manage the organization and its teams, projects, and memberships.", false),
        WRITE_ORG("write:org", "Read and write access to organization membership, organization projects, and team membership.", false),
        READ_ORG("read:org", "Read-only access to organization membership, organization projects, and team membership.", false),
        ADMIN_PUBLIC_KEY("admin:public_key", "Fully manage public keys.", false),
        WRITE_PUBLIC_KEY("write:public_key", "Create, list, and view details for public keys.", false),
        READ_PUBLIC_KEY("read:public_key", "List and view details for public keys.", false),
        GIST("gist", "Grants write access to gists.", false),
        NOTIFICATIONS("notifications", "Grants: <br>* read access to a user's notifications <br>* mark as read access to threads <br>* watch and unwatch access to a repository, and <br>* read, write, and delete access to thread subscriptions.", false),
        USER("user", "Grants read/write access to profile info only.  Note that this scope includes <code>user:email</code> and <code>user:follow</code>.", false),
        READ_USER("read:user", "Grants access to read a user's profile data.", false),
        USER_EMAIL("user:email", "Grants read access to a user's email addresses.", false),
        USER_FOLLOW("user:follow", "Grants access to follow or unfollow other users.", false),
        DELETE_REPO("delete_repo", "Grants access to delete adminable repositories.", false),
        WRITE_DISCUSSION("write:discussion", "Allows read and write access for team discussions.", false),
        READ_DISCUSSION("read:discussion", "Allows read access for team discussions.", false),
        WRITE_PACKAGES("write:packages", "Grants access to upload or publish a package in GitHub Packages. For more information, see \"<a href=\"https://help.github.com/github/managing-packages-with-github-packages/publishing-a-package\">Publishing a package</a>\" in the GitHub Help documentation.", false),
        READ_PACKAGES("read:packages", "Grants access to download or install packages from GitHub Packages. For more information, see \"<a href=\"https://help.github.com/github/managing-packages-with-github-packages/installing-a-package\">Installing a package</a>\" in the GitHub Help documentation.", false),
        DELETE_PACKAGES("delete:packages", "Grants access to delete packages from GitHub Packages. For more information, see \"<a href=\"https://help.github.com/github/managing-packages-with-github-packages/deleting-a-package\">Deleting packages</a>\" in the GitHub Help documentation.", false),
        ADMIN_GPG_KEY("admin:gpg_key", "Fully manage GPG keys.", false),
        WRITE_GPG_KEY("write:gpg_key", "Create, list, and view details for GPG keys.", false),
        READ_GPG_KEY("read:gpg_key", "List and view details for GPG keys.", false),
        WORKFLOW("workflow", "Grants the ability to add and update GitHub Actions workflow files. Workflow files can be committed without this scope if the same file (with both the same path and contents) exists on another branch in the same repository.", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Github(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Gitee implements Scope
    {
        USER_INFO("user_info", "\u8bbf\u95ee\u7528\u6237\u7684\u4e2a\u4eba\u4fe1\u606f\u3001\u6700\u65b0\u52a8\u6001\u7b49", true),
        PROJECTS("projects", "\u67e5\u770b\u3001\u521b\u5efa\u3001\u66f4\u65b0\u7528\u6237\u7684\u9879\u76ee", false),
        PULL_REQUESTS("pull_requests", "\u67e5\u770b\u3001\u53d1\u5e03\u3001\u66f4\u65b0\u7528\u6237\u7684 Pull Request", false),
        ISSUES("issues", "\u67e5\u770b\u3001\u53d1\u5e03\u3001\u66f4\u65b0\u7528\u6237\u7684 Issue", false),
        NOTES("notes", "\u67e5\u770b\u3001\u53d1\u5e03\u3001\u7ba1\u7406\u7528\u6237\u5728\u9879\u76ee\u3001\u4ee3\u7801\u7247\u6bb5\u4e2d\u7684\u8bc4\u8bba", false),
        KEYS("keys", "\u67e5\u770b\u3001\u90e8\u7f72\u3001\u5220\u9664\u7528\u6237\u7684\u516c\u94a5", false),
        HOOK("hook", "\u67e5\u770b\u3001\u90e8\u7f72\u3001\u66f4\u65b0\u7528\u6237\u7684 Webhook", false),
        GROUPS("groups", "\u67e5\u770b\u3001\u7ba1\u7406\u7528\u6237\u7684\u7ec4\u7ec7\u4ee5\u53ca\u6210\u5458", false),
        GISTS("gists", "\u67e5\u770b\u3001\u5220\u9664\u3001\u66f4\u65b0\u7528\u6237\u7684\u4ee3\u7801\u7247\u6bb5", false),
        ENTERPRISES("enterprises", "\u67e5\u770b\u3001\u7ba1\u7406\u7528\u6237\u7684\u4f01\u4e1a\u4ee5\u53ca\u6210\u5458", false),
        EMAILS("emails", "\u67e5\u770b\u7528\u6237\u7684\u4e2a\u4eba\u90ae\u7bb1\u4fe1\u606f", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Gitee(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Facebook implements Scope
    {
        EMAIL("email", "\u83b7\u53d6\u7528\u6237\u7684\u90ae\u7bb1", true),
        USER_AGE_RANGE("user_age_range", "\u5141\u8bb8\u5e94\u7528\u7a0b\u5e8f\u8bbf\u95ee\u7528\u6237\u7684\u5e74\u9f84\u8303\u56f4", true),
        USER_BIRTHDAY("user_birthday", "\u83b7\u53d6\u7528\u6237\u7684\u751f\u65e5", true),
        USER_FRIENDS("user_friends", "\u83b7\u53d6\u7528\u6237\u7684\u597d\u53cb\u5217\u8868", true),
        USER_GENDER("user_gender", "\u83b7\u53d6\u7528\u6237\u7684\u6027\u522b", true),
        USER_HOMETOWN("user_hometown", "\u83b7\u53d6\u7528\u6237\u7684\u5bb6\u4e61\u4fe1\u606f", true),
        USER_LIKES("user_likes", "\u83b7\u53d6\u7528\u6237\u7684\u559c\u6b22\u5217\u8868", true),
        USER_LINK("user_link", "\u83b7\u53d6\u7528\u6237\u7684\u4e2a\u4eba\u94fe\u63a5", true),
        USER_LOCATION("user_location", "\u83b7\u53d6\u7528\u6237\u7684\u4f4d\u7f6e\u4fe1\u606f", true),
        USER_PHOTOS("user_photos", "\u83b7\u53d6\u7528\u6237\u7684\u76f8\u518c\u4fe1\u606f", true),
        USER_POSTS("user_posts", "\u83b7\u53d6\u7528\u6237\u53d1\u5e03\u7684\u5185\u5bb9", true),
        USER_VIDEOS("user_videos", "\u83b7\u53d6\u7528\u6237\u4e0a\u4f20\u7684\u89c6\u9891\u4fe1\u606f", true),
        GROUPS_ACCESS_MEMBER_INFO("groups_access_member_info", "\u83b7\u53d6\u516c\u5f00\u7684\u7fa4\u7ec4\u6210\u5458\u4fe1\u606f", false),
        PUBLISH_TO_GROUPS("publish_to_groups", "\u6388\u6743\u60a8\u7684\u5e94\u7528\u7a0b\u5e8f\u4ee3\u8868\u67d0\u4eba\u5c06\u5185\u5bb9\u53d1\u5e03\u5230\u7ec4\u4e2d\uff0c\u524d\u63d0\u662f\u4ed6\u4eec\u5df2\u7ecf\u6388\u4e88\u60a8\u7684\u5e94\u7528\u7a0b\u5e8f\u8bbf\u95ee\u6743\u9650", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Facebook(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Douyin implements Scope
    {
        USER_INFO("user_info", "\u8fd4\u56de\u6296\u97f3\u7528\u6237\u516c\u5f00\u4fe1\u606f", true),
        AWEME_SHARE("aweme.share", "\u6296\u97f3\u5206\u4eab", false),
        IM_SHARE("im.share", "\u5206\u4eab\u7ed9\u6296\u97f3\u597d\u53cb", false),
        RENEW_REFRESH_TOKEN("renew_refresh_token", "\u6388\u6743\u6709\u6548\u671f\u52a8\u6001\u7eed\u671f", false),
        FOLLOWING_LIST("following.list", "\u83b7\u53d6\u8be5\u7528\u6237\u7684\u5173\u6ce8\u5217\u8868", false),
        FANS_LIST("fans.list", "\u83b7\u53d6\u8be5\u7528\u6237\u7684\u7c89\u4e1d\u5217\u8868", false),
        VIDEO_CREATE("video.create", "\u89c6\u9891\u53d1\u5e03\u53ca\u7ba1\u7406", false),
        VIDEO_DELETE("video.delete", "\u5220\u9664\u5185\u5bb9", false),
        VIDEO_DATA("video.data", "\u67e5\u8be2\u6388\u6743\u7528\u6237\u7684\u6296\u97f3\u89c6\u9891\u6570\u636e", false),
        VIDEO_LIST("video.list", "\u67e5\u8be2\u7279\u5b9a\u6296\u97f3\u89c6\u9891\u7684\u89c6\u9891\u6570\u636e", false),
        SHARE_WITH_SOURCE("share_with_source", "\u5206\u4eab\u643a\u5e26\u6765\u6e90\u6807\u7b7e\uff0c\u7528\u6237\u53ef\u70b9\u51fb\u6807\u7b7e\u8fdb\u5165\u8f6c\u5316\u9875", false),
        MOBILE("mobile", "\u7528\u6296\u97f3\u5e10\u53f7\u767b\u5f55\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0c\u83b7\u5f97\u7528\u6237\u5728\u6296\u97f3\u4e0a\u7684\u624b\u673a\u53f7\u7801", false),
        MOBILE_ALERT("mobile_alert", "\u7528\u6296\u97f3\u5e10\u53f7\u767b\u5f55\u7b2c\u4e09\u65b9\u5e73\u53f0\uff0c\u83b7\u5f97\u7528\u6237\u5728\u6296\u97f3\u4e0a\u7684\u624b\u673a\u53f7\u7801", false),
        VIDEO_SEARCH("video.search", "\u5173\u952e\u8bcd\u89c6\u9891\u7ba1\u7406", false),
        POI_SEARCH("poi.search", "\u67e5\u8be2POI\u4fe1\u606f", false),
        LOGIN_ID("login_id", "\u9759\u9ed8\u6388\u6743\u76f4\u63a5\u83b7\u53d6\u8be5\u7528\u6237\u7684open id", false),
        DATA_EXTERNAL_USER("data.external.user", "\u67e5\u8be2\u7528\u6237\u7684\u83b7\u8d5e\u3001\u8bc4\u8bba\u3001\u5206\u4eab\uff0c\u4e3b\u9875\u8bbf\u95ee\u7b49\u76f8\u5173\u6570\u636e", false),
        DATA_EXTERNAL_ITEM("data.external.item", "\u67e5\u8be2\u4f5c\u54c1\u7684\u83b7\u8d5e\uff0c\u8bc4\u8bba\uff0c\u5206\u4eab\u7b49\u76f8\u5173\u6570\u636e", false),
        FANS_DATA("fans.data", "\u83b7\u53d6\u7528\u6237\u7c89\u4e1d\u753b\u50cf\u6570\u636e", false),
        HOTSEARCH("hotsearch", "\u83b7\u53d6\u6296\u97f3\u70ed\u95e8\u5185\u5bb9", false),
        STAR_TOP_SCORE_DISPLAY("star_top_score_display", "\u661f\u56fe\u8fbe\u4eba\u4e0e\u8fbe\u4eba\u5bf9\u5e94\u5404\u6307\u6570\u8bc4\u4f30\u5206\uff0c\u4ee5\u53ca\u661f\u56fe6\u5927\u70ed\u95e8\u7ef4\u5ea6\u4e0b\u7684\u8fbe\u4eba\u699c\u5355", false),
        STAR_TOPS("star_tops", "\u661f\u56fe\u8fbe\u4eba\u4e0e\u8fbe\u4eba\u5bf9\u5e94\u5404\u6307\u6570\u8bc4\u4f30\u5206\uff0c\u4ee5\u53ca\u661f\u56fe6\u5927\u70ed\u95e8\u7ef4\u5ea6\u4e0b\u7684\u8fbe\u4eba\u699c\u5355", false),
        STAR_AUTHOR_SCORE_DISPLAY("star_author_score_display", "\u661f\u56fe\u8fbe\u4eba\u4e0e\u8fbe\u4eba\u5bf9\u5e94\u5404\u6307\u6570\u8bc4\u4f30\u5206\uff0c\u4ee5\u53ca\u661f\u56fe6\u5927\u70ed\u95e8\u7ef4\u5ea6\u4e0b\u7684\u8fbe\u4eba\u699c\u5355", false),
        notes("data.external.sdk_share", "\u83b7\u53d6\u7528\u6237\u901a\u8fc7\u5206\u4eabSDK\u5206\u4eab\u89c6\u9891\u6570\u636e", false),
        DISCOVERY_ENT("discovery.ent", "\u67e5\u8be2\u6296\u97f3\u7535\u5f71\u699c\u3001\u6296\u97f3\u5267\u96c6\u699c\u3001\u6296\u97f3\u7efc\u827a\u699c\u6570\u636e", false);

        private final String scope;
        private final String description;
        private final boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Douyin(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Coding implements Scope
    {
        USER("user", "\u8bfb\u53d6\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f", false),
        USER_EMAIL("user:email", "\u8bfb\u53d6\u7528\u6237\u7684\u90ae\u4ef6", false),
        USER_PHONE("user:phone", "\u8bfb\u53d6\u7528\u6237\u7684\u624b\u673a\u53f7", false),
        PROJECT("project", "\u6388\u6743\u9879\u76ee\u4fe1\u606f\u3001\u9879\u76ee\u5217\u8868\uff0c\u4ed3\u5e93\u4fe1\u606f\uff0c\u516c\u94a5\u5217\u8868\u3001\u6210\u5458", false),
        PROJECT_DEPOT("project:depot", "\u5b8c\u6574\u7684\u4ed3\u5e93\u63a7\u5236\u6743\u9650", false),
        PROJECT_WIKI("project:wiki", "\u6388\u6743\u8bfb\u53d6\u4e0e\u64cd\u4f5c wiki", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Coding(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Amazon implements Scope
    {
        R_LITEPROFILE("profile", "The profile scope includes a user's name and email address", true),
        R_EMAILADDRESS("profile:user_id", "The profile:user_id scope only includes the user_id field of the profile", true),
        W_MEMBER_SOCIAL("postal_code", "This includes the user's zip/postal code number from their primary shipping address", true);

        private final String scope;
        private final String description;
        private final boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Amazon(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }

    public static enum Baidu implements Scope
    {
        BASIC("basic", "\u7528\u6237\u57fa\u672c\u6743\u9650\uff0c\u53ef\u4ee5\u83b7\u53d6\u7528\u6237\u7684\u57fa\u672c\u4fe1\u606f \u3002", true),
        SUPER_MSG("super_msg", "\u5f80\u7528\u6237\u7684\u767e\u5ea6\u9996\u9875\u4e0a\u53d1\u9001\u6d88\u606f\u63d0\u9192\uff0c\u76f8\u5173API\u4efb\u4f55\u5e94\u7528\u90fd\u80fd\u4f7f\u7528\uff0c\u4f46\u8981\u60f3\u5c06\u6d88\u606f\u63d0\u9192\u5728\u767e\u5ea6\u9996\u9875\u663e\u793a\uff0c\u9700\u8981\u7b2c\u4e09\u65b9\u5728\u6ce8\u518c\u5e94\u7528\u65f6\u989d\u5916\u586b\u5199\u76f8\u5173\u4fe1\u606f\u3002", false),
        NETDISK("netdisk", "\u83b7\u53d6\u7528\u6237\u5728\u4e2a\u4eba\u4e91\u5b58\u50a8\u4e2d\u5b58\u653e\u7684\u6570\u636e\u3002", false),
        PUBLIC("public", "\u53ef\u4ee5\u8bbf\u95ee\u516c\u5171\u7684\u5f00\u653eAPI\u3002", false),
        HAO123("hao123", "\u53ef\u4ee5\u8bbf\u95eeHao123 \u63d0\u4f9b\u7684\u5f00\u653eAPI\u63a5\u53e3\u3002\u8be5\u6743\u9650\u9700\u8981\u7533\u8bf7\u5f00\u901a\uff0c\u8bf7\u5c06\u5177\u4f53\u7684\u7406\u7531\u548c\u7528\u9014\u53d1\u90ae\u4ef6\u7ed9tuangou@baidu.com\u3002", false);

        private String scope;
        private String description;
        private boolean isDefault;

        @Override
        public String getScope() {
            return this.scope;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        private Baidu(String scope, String description, boolean isDefault) {
            this.scope = scope;
            this.description = description;
            this.isDefault = isDefault;
        }
    }
}

