/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.AuthorizedException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class LinkedinProvider
extends AbstractProvider {
    public LinkedinProvider(Context context) {
        super(context, Registry.LINKEDIN);
    }

    public LinkedinProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.LINKEDIN, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return this.getToken(this.accessTokenUrl(callback.getCode()));
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String accessToken = accToken.getAccessToken();
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Host", "api.linkedin.com");
        header.put("Connection", "Keep-Alive");
        header.put("Authorization", "Bearer " + accessToken);
        String response = Httpx.get((String)this.userInfoUrl(accToken), null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        String userName = this.getUserName(object);
        String avatar = this.getAvatar(object);
        String email = this.getUserEmail(accessToken);
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(userName).nickname(userName).avatar(avatar).email(email).token(accToken).gender(Normal.Gender.UNKNOWN).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(" ", false, LinkedinProvider.getScopes(true, OauthScope.Linkedin.values()))).build();
    }

    @Override
    public String userInfoUrl(AccToken token) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("projection", "(id,firstName,lastName,profilePicture(displayImage~:playableStreams))").build();
    }

    private String getUserName(JSONObject userInfoObject) {
        String firstName = userInfoObject.containsKey((Object)"localizedFirstName") ? userInfoObject.getString("localizedFirstName") : this.getUserName(userInfoObject, "firstName");
        String lastName = userInfoObject.containsKey((Object)"localizedLastName") ? userInfoObject.getString("localizedLastName") : this.getUserName(userInfoObject, "lastName");
        return firstName + " " + lastName;
    }

    private String getAvatar(JSONObject userInfoObject) {
        JSONObject profilePictureObject = userInfoObject.getJSONObject("profilePicture");
        if (null == profilePictureObject || !profilePictureObject.containsKey((Object)"displayImage~")) {
            return null;
        }
        JSONObject displayImageObject = profilePictureObject.getJSONObject("displayImage~");
        if (null == displayImageObject || !displayImageObject.containsKey((Object)"elements")) {
            return null;
        }
        JSONArray displayImageElements = displayImageObject.getJSONArray("elements");
        if (null == displayImageElements || displayImageElements.isEmpty()) {
            return null;
        }
        JSONObject largestImageObj = displayImageElements.getJSONObject(displayImageElements.size() - 1);
        if (null == largestImageObj || !largestImageObj.containsKey((Object)"identifiers")) {
            return null;
        }
        JSONArray identifiers = largestImageObj.getJSONArray("identifiers");
        if (null == identifiers || identifiers.isEmpty()) {
            return null;
        }
        return identifiers.getJSONObject(0).getString("identifier");
    }

    private String getUserEmail(String accessToken) {
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("Host", "api.linkedin.com");
        header.put("Connection", "Keep-Alive");
        header.put("Authorization", "Bearer " + accessToken);
        String url = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
        String response = Httpx.get((String)url, null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        Object value = JSONPath.eval((Object)object, (String)"$['elements'][0]['handle~']['emailAddress']");
        return null == value ? null : (String)value;
    }

    private String getUserName(JSONObject userInfoObject, String nameKey) {
        JSONObject firstNameObj = userInfoObject.getJSONObject(nameKey);
        JSONObject localizedObj = firstNameObj.getJSONObject("localized");
        JSONObject preferredLocaleObj = firstNameObj.getJSONObject("preferredLocale");
        String firstName = localizedObj.getString(preferredLocaleObj.getString("language") + "_" + preferredLocaleObj.getString("country"));
        return firstName;
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
    }

    private AccToken getToken(String accessTokenUrl) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Host", "www.linkedin.com");
        String response = Httpx.get((String)accessTokenUrl, null, header);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).build();
    }
}

