/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.AuthorizedException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class StackOverflowProvider
extends AbstractProvider {
    public StackOverflowProvider(Context context) {
        super(context, Registry.STACKOVERFLOW);
    }

    public StackOverflowProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.STACKOVERFLOW, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        String accessTokenUrl = this.accessTokenUrl(callback.getCode());
        HashMap paramMap = new HashMap();
        UriKit.decodeVal((String)accessTokenUrl, (String)"UTF-8").forEach(paramMap::put);
        String response = Httpx.post((String)this.source.accessToken(), paramMap);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String userInfoUrl = Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("site", "stackoverflow").queryParam("key", this.context.getOverflowKey()).build();
        JSONObject jsonObject = JSONObject.parseObject((String)Httpx.get((String)userInfoUrl));
        this.checkResponse(jsonObject);
        JSONObject object = jsonObject.getJSONArray("items").getJSONObject(0);
        return Property.builder().rawJson(object).uuid(object.getString("user_id")).avatar(object.getString("profile_image")).location(object.getString("location")).nickname(object.getString("display_name")).blog(object.getString("website_url")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, StackOverflowProvider.getScopes(true, OauthScope.StackOverflow.values()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
    }
}

