/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.AuthorizedException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class WeChatEEProvider
extends AbstractProvider {
    public WeChatEEProvider(Context context) {
        super(context, Registry.WECHAT_EE);
    }

    public WeChatEEProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.WECHAT_EE, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        String response = this.doGetAuthorizationCode(this.accessTokenUrl(null));
        JSONObject object = this.checkResponse(response);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).code(callback.getCode()).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String response = this.doGetUserInfo(accToken);
        JSONObject jsonObject = this.checkResponse(response);
        if (!jsonObject.containsKey((Object)"UserId")) {
            throw new AuthorizedException(Builder.ErrorCode.UNIDENTIFIED_PLATFORM.getCode());
        }
        String userId = jsonObject.getString("UserId");
        JSONObject object = this.checkResponse(this.getUserDetail(accToken.getAccessToken(), userId));
        return Property.builder().rawJson(object).username(object.getString("name")).nickname(object.getString("alias")).avatar(object.getString("avatar")).location(object.getString("address")).email(object.getString("email")).uuid(userId).gender(Normal.Gender.of((String)object.getString("gender"))).token(accToken).source(this.source.toString()).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode") && object.getIntValue("errcode") != 0) {
            throw new AuthorizedException(StringKit.toString((Object)object.getIntValue("errcode")), object.getString("errmsg"));
        }
        return object;
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("appid", this.context.getAppKey()).queryParam("agentid", this.context.getAgentId()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("corpid", this.context.getAppKey()).queryParam("corpsecret", this.context.getAppSecret()).build();
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("code", accToken.getCode()).build();
    }

    private String getUserDetail(String accessToken, String userId) {
        String userDetailUrl = Builder.fromUrl("https://qyapi.weixin.qq.com/cgi-bin/user/get").queryParam("access_token", accessToken).queryParam("userid", userId).build();
        return Httpx.get((String)userDetailUrl);
    }
}

