/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.csv;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.function.XConsumer;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.office.csv.CsvData;
import org.aoju.bus.office.csv.CsvParser;
import org.aoju.bus.office.csv.CsvReadConfig;
import org.aoju.bus.office.csv.CsvRow;

public class CsvReader
implements Iterable<CsvRow>,
Closeable {
    private final Reader reader;
    private final CsvReadConfig config;

    public CsvReader() {
        this(null);
    }

    public CsvReader(CsvReadConfig config) {
        this((Reader)null, config);
    }

    public CsvReader(Reader reader, CsvReadConfig config) {
        this.config = (CsvReadConfig)ObjectKit.defaultIfNull((Object)config, CsvReadConfig::defaultConfig);
        this.reader = reader;
    }

    public CsvReader(File file, CsvReadConfig config) {
        this(file, Charset.UTF_8, config);
    }

    public CsvReader(Path path, CsvReadConfig config) {
        this(path, Charset.UTF_8, config);
    }

    public CsvReader(File file, java.nio.charset.Charset charset, CsvReadConfig config) {
        this(FileKit.getReader((File)file, (java.nio.charset.Charset)charset), config);
    }

    public CsvReader(Path path, java.nio.charset.Charset charset, CsvReadConfig config) {
        this(FileKit.getReader((Path)path, (java.nio.charset.Charset)charset), config);
    }

    public void setFieldSeparator(char fieldSeparator) {
        this.config.setFieldSeparator(fieldSeparator);
    }

    public void setTextDelimiter(char textDelimiter) {
        this.config.setTextDelimiter(textDelimiter);
    }

    public void setContainsHeader(boolean containsHeader) {
        this.config.setContainsHeader(containsHeader);
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.config.setSkipEmptyRows(skipEmptyRows);
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.setErrorOnDifferentFieldCount(errorOnDifferentFieldCount);
    }

    public CsvData read(File file) throws InternalException {
        return this.read(file, Charset.UTF_8);
    }

    public CsvData read(String text) {
        return this.read(new StringReader(text));
    }

    public void read(String text, XConsumer<CsvRow> rowHandler) {
        this.read(this.parse(new StringReader(text)), rowHandler);
    }

    public CsvData read(File file, java.nio.charset.Charset charset) throws InternalException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), charset);
    }

    public CsvData read(Path path) throws InternalException {
        return this.read(path, Charset.UTF_8);
    }

    public CsvData read(Path path, java.nio.charset.Charset charset) throws InternalException {
        CsvData csvData;
        block8: {
            Assert.notNull((Object)path, (String)"path must not be null", (Object[])new Object[0]);
            BufferedReader reader = FileKit.getReader((Path)path, (java.nio.charset.Charset)charset);
            try {
                csvData = this.read(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            ((Reader)reader).close();
        }
        return csvData;
    }

    public CsvData read(Reader reader) throws InternalException {
        CsvParser csvParser = this.parse(reader);
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        this.read(csvParser, (XConsumer<CsvRow>)((XConsumer & Serializable)rows::add));
        List<String> header = this.config.headerLineNo > -1L ? csvParser.getHeader() : null;
        return new CsvData(header, rows);
    }

    public void read(Reader reader, XConsumer<CsvRow> rowHandler) {
        this.read(this.parse(reader), rowHandler);
    }

    private void read(CsvParser csvParser, XConsumer<CsvRow> rowHandler) {
        try {
            while (csvParser.hasNext()) {
                rowHandler.accept((Object)((CsvRow)csvParser.next()));
            }
        }
        finally {
            IoKit.close((Closeable)csvParser);
        }
    }

    public <T> List<T> read(String csvStr, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read((Reader)new StringReader(csvStr), (XConsumer<CsvRow>)(XConsumer & Serializable)row -> result.add(row.toBean(clazz)));
        return result;
    }

    public List<Map<String, String>> readMapList(Reader reader) throws InternalException {
        this.config.setContainsHeader(true);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        this.read(reader, (XConsumer<CsvRow>)(XConsumer & Serializable)row -> result.add(row.getFieldMap()));
        return result;
    }

    public <T> List<T> read(Reader reader, Class<T> clazz) {
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, (XConsumer<CsvRow>)(XConsumer & Serializable)row -> result.add(row.toBean(clazz)));
        return result;
    }

    private CsvParser parse(Reader reader) throws InternalException {
        return new CsvParser(reader, this.config);
    }

    public <T> List<T> read(Reader reader, int startLineIndex, Class<T> clazz) {
        if (startLineIndex < 1) {
            throw new IndexOutOfBoundsException(StringKit.format((CharSequence)"start line index {} is lower than first row index 1.", (Object[])new Object[]{startLineIndex}));
        }
        this.config.setContainsHeader(true);
        ArrayList result = new ArrayList();
        this.read(reader, (XConsumer<CsvRow>)(XConsumer & Serializable)row -> {
            if (row.getOriginalLineNumber() >= (long)startLineIndex) {
                result.add(row.toBean(clazz));
            }
        });
        return result;
    }

    public Stream<CsvRow> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new InternalException((Throwable)e);
            }
        });
    }

    @Override
    public Iterator<CsvRow> iterator() {
        return this.parse(this.reader);
    }

    @Override
    public void close() throws IOException {
        IoKit.close((Closeable)this.reader);
    }
}

