/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.csv;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.collection.ArrayIterator;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.office.csv.CsvData;
import org.aoju.bus.office.csv.CsvWriteConfig;

public final class CsvWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final CsvWriteConfig config;
    private boolean newline = true;
    private boolean isFirstLine = true;

    public CsvWriter(String filePath) {
        this(FileKit.file((String)filePath));
    }

    public CsvWriter(File file) {
        this(file, Charset.UTF_8);
    }

    public CsvWriter(String filePath, java.nio.charset.Charset charset) {
        this(FileKit.file((String)filePath), charset);
    }

    public CsvWriter(File file, java.nio.charset.Charset charset) {
        this(file, charset, false);
    }

    public CsvWriter(String filePath, java.nio.charset.Charset charset, boolean isAppend) {
        this(FileKit.file((String)filePath), charset, isAppend);
    }

    public CsvWriter(File file, java.nio.charset.Charset charset, boolean isAppend) {
        this(file, charset, isAppend, null);
    }

    public CsvWriter(String filePath, java.nio.charset.Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileKit.file((String)filePath), charset, isAppend, config);
    }

    public CsvWriter(File file, java.nio.charset.Charset charset, boolean isAppend, CsvWriteConfig config) {
        this(FileKit.getWriter((File)file, (java.nio.charset.Charset)charset, (boolean)isAppend), config);
    }

    public CsvWriter(Writer writer) {
        this(writer, null);
    }

    public CsvWriter(Writer writer, CsvWriteConfig config) {
        this.writer = writer instanceof BufferedWriter ? writer : new BufferedWriter(writer);
        this.config = (CsvWriteConfig)ObjectKit.defaultIfNull((Object)config, CsvWriteConfig::defaultConfig);
    }

    public void setAlwaysDelimitText(boolean alwaysDelimitText) {
        this.setAlwaysDelimitText(alwaysDelimitText);
    }

    public void setLineDelimiter(char[] lineDelimiter) {
        this.setLineDelimiter(lineDelimiter);
    }

    public CsvWriter write(String[] ... lines) throws InternalException {
        return this.write((Iterable<?>)new ArrayIterator((Object[])lines));
    }

    public CsvWriter write(Iterable<?> lines) {
        if (CollKit.isNotEmpty(lines)) {
            for (Object values : lines) {
                this.appendLine(Convert.toStrArray(values));
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter write(CsvData csvData) {
        if (csvData != null) {
            List<String> header = csvData.getHeader();
            if (CollKit.isNotEmpty(header)) {
                this.writeHeaderLine(header.toArray(new String[0]));
            }
            this.write(csvData.getRows());
            this.flush();
        }
        return this;
    }

    public CsvWriter writeBeans(Collection<?> beans) {
        if (CollKit.isNotEmpty(beans)) {
            boolean isFirst = true;
            for (Object bean : beans) {
                Map map = BeanKit.beanToMap(bean);
                if (isFirst) {
                    this.writeLine(map.keySet().toArray(new String[0]));
                    isFirst = false;
                }
                this.writeLine(Convert.toStrArray(map.values()));
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter writeLine(String ... fields) throws InternalException {
        if (ArrayKit.isEmpty((Object[])fields)) {
            return this.writeLine();
        }
        this.appendLine(fields);
        return this;
    }

    public CsvWriter writeLine() throws InternalException {
        try {
            this.writer.write(this.config.lineDelimiter);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        this.newline = true;
        return this;
    }

    public CsvWriter writeComment(String comment) {
        Assert.notNull((Object)this.config.commentCharacter, (String)"Comment is disable!", (Object[])new Object[0]);
        try {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            this.writer.write(this.config.commentCharacter.charValue());
            this.writer.write(comment);
            this.newline = true;
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        IoKit.close((Closeable)this.writer);
    }

    @Override
    public void flush() throws InternalException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public CsvWriter writeHeaderLine(String ... fields) throws InternalException {
        Map headerAlias = this.config.headerAlias;
        if (MapKit.isNotEmpty((Map)headerAlias)) {
            for (int i = 0; i < fields.length; ++i) {
                String alias = (String)headerAlias.get(fields[i]);
                if (null == alias) continue;
                fields[i] = alias;
            }
        }
        return this.writeLine(fields);
    }

    private void appendLine(String ... fields) throws InternalException {
        try {
            this.doAppendLine(fields);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void doAppendLine(String ... fields) throws IOException {
        if (null != fields) {
            if (this.isFirstLine) {
                this.isFirstLine = false;
            } else {
                this.writer.write(this.config.lineDelimiter);
            }
            for (String field : fields) {
                this.appendField(field);
            }
            this.newline = true;
        }
    }

    private void appendField(String value) throws IOException {
        boolean alwaysDelimitText = this.config.alwaysDelimitText;
        char textDelimiter = this.config.textDelimiter;
        char fieldSeparator = this.config.fieldSeparator;
        if (!this.newline) {
            this.writer.write(fieldSeparator);
        } else {
            this.newline = false;
        }
        if (null == value) {
            if (alwaysDelimitText) {
                this.writer.write(new char[]{textDelimiter, textDelimiter});
            }
            return;
        }
        char[] valueChars = value.toCharArray();
        boolean needsTextDelimiter = alwaysDelimitText;
        boolean containsTextDelimiter = false;
        for (char c : valueChars) {
            if (c == textDelimiter) {
                needsTextDelimiter = true;
                containsTextDelimiter = true;
                break;
            }
            if (c != fieldSeparator && c != '\n' && c != '\r') continue;
            needsTextDelimiter = true;
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
        if (containsTextDelimiter) {
            for (char c : valueChars) {
                if (c == textDelimiter) {
                    this.writer.write(textDelimiter);
                }
                this.writer.write(c);
            }
        } else {
            this.writer.write(valueChars);
        }
        if (needsTextDelimiter) {
            this.writer.write(textDelimiter);
        }
    }
}

