/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.word;

import java.awt.Font;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.office.word.PicType;
import org.aoju.bus.office.word.TableKit;
import org.aoju.bus.office.word.WordKit;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class Word07Writer
implements Closeable {
    protected File destFile;
    protected boolean isClosed;
    private XWPFDocument doc;

    public Word07Writer() {
        this(new XWPFDocument());
    }

    public Word07Writer(File destFile) {
        this(WordKit.create(destFile), destFile);
    }

    public Word07Writer(XWPFDocument doc) {
        this(doc, null);
    }

    public Word07Writer(XWPFDocument doc, File destFile) {
        this.doc = doc;
        this.destFile = destFile;
    }

    public XWPFDocument getDoc() {
        return this.doc;
    }

    public Word07Writer setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public Word07Writer addText(Font font, String ... texts) {
        return this.addText(null, font, texts);
    }

    public Word07Writer addText(ParagraphAlignment align, Font font, String ... texts) {
        XWPFParagraph p = this.doc.createParagraph();
        if (null != align) {
            p.setAlignment(align);
        }
        if (ArrayKit.isNotEmpty((Object[])texts)) {
            for (String text : texts) {
                XWPFRun run = p.createRun();
                run.setText(text);
                if (null == font) continue;
                run.setFontFamily(font.getFamily());
                run.setFontSize(font.getSize());
                run.setBold(font.isBold());
                run.setItalic(font.isItalic());
            }
        }
        return this;
    }

    public Word07Writer addPicture(File picFile, int width, int height) {
        PicType picType;
        String fileName = picFile.getName();
        String suffix = FileKit.getSuffix((String)fileName).toUpperCase();
        try {
            picType = PicType.valueOf(suffix);
        }
        catch (IllegalArgumentException e) {
            picType = PicType.JPEG;
        }
        return this.addPicture(FileKit.getInputStream((File)picFile), picType, fileName, width, height);
    }

    public Word07Writer addPicture(InputStream in, PicType picType, String fileName, int width, int height) {
        return this.addPicture(in, picType, fileName, width, height, ParagraphAlignment.CENTER);
    }

    public Word07Writer addPicture(InputStream in, PicType picType, String fileName, int width, int height, ParagraphAlignment align) {
        XWPFParagraph paragraph = this.doc.createParagraph();
        paragraph.setAlignment(align);
        XWPFRun run = paragraph.createRun();
        try {
            run.addPicture(in, picType.getValue(), fileName, Units.toEMU((double)width), Units.toEMU((double)height));
        }
        catch (IOException | InvalidFormatException e) {
            throw new InternalException(e);
        }
        finally {
            IoKit.close((Closeable)in);
        }
        return this;
    }

    public Word07Writer addTable(Iterable<?> data) {
        TableKit.createTable(this.doc, data);
        return this;
    }

    public Word07Writer flush() throws InternalException {
        return this.flush(this.destFile);
    }

    public Word07Writer flush(File destFile) throws InternalException {
        Assert.notNull((Object)destFile, (String)"[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", (Object[])new Object[0]);
        return this.flush(FileKit.getOutputStream((File)destFile), true);
    }

    public Word07Writer flush(OutputStream out) throws InternalException {
        return this.flush(out, false);
    }

    public Word07Writer flush(OutputStream out, boolean isCloseOut) throws InternalException {
        Assert.isFalse((boolean)this.isClosed, (String)"WordWriter has been closed!", (Object[])new Object[0]);
        try {
            this.doc.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
        finally {
            if (isCloseOut) {
                IoKit.close((Closeable)out);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        IoKit.close((Closeable)this.doc);
        this.isClosed = true;
    }
}

