/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.poi.excel;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.ArrayUtils;
import org.aoju.bus.core.utils.BeanUtils;
import org.aoju.bus.core.utils.CollUtils;
import org.aoju.bus.core.utils.FileUtils;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.MapUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.poi.excel.BookUtils;
import org.aoju.bus.poi.excel.CellUtils;
import org.aoju.bus.poi.excel.ExcelBase;
import org.aoju.bus.poi.excel.RowUtils;
import org.aoju.bus.poi.excel.StyleSet;
import org.aoju.bus.poi.excel.style.Align;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelWriter
extends ExcelBase<ExcelWriter> {
    protected File destFile;
    private AtomicInteger currentRow = new AtomicInteger(0);
    private Map<String, String> headerAlias;
    private boolean onlyAlias;
    private Comparator<String> aliasComparator;
    private StyleSet styleSet = new StyleSet(this.workbook);

    public ExcelWriter() {
        this(false);
    }

    public ExcelWriter(boolean isXlsx) {
        this(BookUtils.createBook(isXlsx), null);
    }

    public ExcelWriter(String destFilePath) {
        this(destFilePath, null);
    }

    public ExcelWriter(boolean isXlsx, String sheetName) {
        this(BookUtils.createBook(isXlsx), sheetName);
    }

    public ExcelWriter(String destFilePath, String sheetName) {
        this(FileUtils.file((String)destFilePath), sheetName);
    }

    public ExcelWriter(File destFile) {
        this(destFile, null);
    }

    public ExcelWriter(File destFile, String sheetName) {
        this(destFile.exists() ? BookUtils.createBook(FileUtils.getInputStream((File)destFile), true) : BookUtils.createBook(StringUtils.endWithIgnoreCase((CharSequence)destFile.getName(), (CharSequence)".xlsx")), sheetName);
        this.destFile = destFile;
    }

    public ExcelWriter(Workbook workbook, String sheetName) {
        this(BookUtils.getOrCreateSheet(workbook, sheetName));
    }

    public ExcelWriter(Sheet sheet) {
        super(sheet);
    }

    @Override
    public ExcelWriter setSheet(int sheetIndex) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetIndex);
    }

    @Override
    public ExcelWriter setSheet(String sheetName) {
        this.reset();
        return (ExcelWriter)super.setSheet(sheetName);
    }

    public ExcelWriter reset() {
        this.resetRow();
        this.aliasComparator = null;
        return this;
    }

    public ExcelWriter renameSheet(String sheetName) {
        return this.renameSheet(this.workbook.getSheetIndex(this.sheet), sheetName);
    }

    public ExcelWriter renameSheet(int sheet, String sheetName) {
        this.workbook.setSheetName(sheet, sheetName);
        return this;
    }

    public ExcelWriter autoSizeColumnAll() {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            this.autoSizeColumn(i);
        }
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex) {
        this.sheet.autoSizeColumn(columnIndex);
        return this;
    }

    public ExcelWriter autoSizeColumn(int columnIndex, boolean useMergedCells) {
        this.sheet.autoSizeColumn(columnIndex, useMergedCells);
        return this;
    }

    public StyleSet getStyleSet() {
        return this.styleSet;
    }

    public ExcelWriter setStyleSet(StyleSet styleSet) {
        this.styleSet = styleSet;
        return this;
    }

    public CellStyle getHeadCellStyle() {
        return this.styleSet.headCellStyle;
    }

    public CellStyle getCellStyle() {
        return this.styleSet.cellStyle;
    }

    public int getCurrentRow() {
        return this.currentRow.get();
    }

    public ExcelWriter setCurrentRow(int rowIndex) {
        this.currentRow.set(rowIndex);
        return this;
    }

    public ExcelWriter passCurrentRow() {
        this.currentRow.incrementAndGet();
        return this;
    }

    public ExcelWriter passRows(int rows) {
        this.currentRow.addAndGet(rows);
        return this;
    }

    public ExcelWriter resetRow() {
        this.currentRow.set(0);
        return this;
    }

    public ExcelWriter setDestFile(File destFile) {
        this.destFile = destFile;
        return this;
    }

    public ExcelWriter setHeaderAlias(Map<String, String> headerAlias) {
        this.headerAlias = headerAlias;
        return this;
    }

    public ExcelWriter clearHeaderAlias() {
        this.headerAlias = null;
        return this;
    }

    public ExcelWriter setOnlyAlias(boolean isOnlyAlias) {
        this.onlyAlias = isOnlyAlias;
        return this;
    }

    public ExcelWriter addHeaderAlias(String name, String alias) {
        Map<String, String> headerAlias = this.headerAlias;
        if (null == headerAlias) {
            headerAlias = new LinkedHashMap<String, String>();
        }
        this.headerAlias = headerAlias;
        headerAlias.put(name, alias);
        return this;
    }

    public ExcelWriter setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0) {
            this.sheet.setDefaultColumnWidth(width);
        } else {
            this.sheet.setColumnWidth(columnIndex, width * 256);
        }
        return this;
    }

    public ExcelWriter setRowHeight(int rownum, int height) {
        if (rownum < 0) {
            this.sheet.setDefaultRowHeightInPoints((float)height);
        } else {
            Row row = this.sheet.getRow(rownum);
            if (null != row) {
                row.setHeightInPoints((float)height);
            }
        }
        return this;
    }

    public ExcelWriter setHeaderOrFooter(String text, Align align, boolean isFooter) {
        Footer headerFooter = isFooter ? this.sheet.getFooter() : this.sheet.getHeader();
        switch (align) {
            case LEFT: {
                headerFooter.setLeft(text);
                break;
            }
            case RIGHT: {
                headerFooter.setRight(text);
                break;
            }
            case CENTER: {
                headerFooter.setCenter(text);
                break;
            }
        }
        return this;
    }

    public ExcelWriter merge(int lastColumn) {
        return this.merge(lastColumn, null);
    }

    public ExcelWriter merge(int lastColumn, Object content) {
        return this.merge(lastColumn, content, true);
    }

    public ExcelWriter merge(int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        int rowIndex = this.currentRow.get();
        this.merge(rowIndex, rowIndex, 0, lastColumn, content, isSetHeaderStyle);
        if (null != content) {
            this.currentRow.incrementAndGet();
        }
        return this;
    }

    public ExcelWriter merge(int firstRow, int lastRow, int firstColumn, int lastColumn, Object content, boolean isSetHeaderStyle) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        CellStyle style = isSetHeaderStyle && null != this.styleSet && null != this.styleSet.headCellStyle ? this.styleSet.headCellStyle : this.styleSet.cellStyle;
        CellUtils.mergingCells(this.sheet, firstRow, lastRow, firstColumn, lastColumn, style);
        if (null != content) {
            Cell cell = this.getOrCreateCell(firstColumn, firstRow);
            CellUtils.setCellValue(cell, content, this.styleSet, isSetHeaderStyle);
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data) {
        return this.write(data, 0 == this.getCurrentRow());
    }

    public ExcelWriter write(Iterable<?> data, boolean isWriteKeyAsHead) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        boolean isFirst = true;
        for (Object object : data) {
            this.writeRow(object, isFirst && isWriteKeyAsHead);
            if (!isFirst) continue;
            isFirst = false;
        }
        return this;
    }

    public ExcelWriter write(Iterable<?> data, Comparator<String> comparator) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        boolean isFirstRow = true;
        for (Object obj : data) {
            Map map;
            if (obj instanceof Map) {
                map = new TreeMap(comparator);
                map.putAll((Map)obj);
            } else {
                map = BeanUtils.beanToMap(obj, new TreeMap(comparator), (boolean)false, (boolean)false);
            }
            this.writeRow(map, isFirstRow);
            if (!isFirstRow) continue;
            isFirstRow = false;
        }
        return this;
    }

    public ExcelWriter writeHeadRow(Iterable<?> rowData) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        RowUtils.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, true);
        return this;
    }

    public ExcelWriter writeRow(Object rowBean, boolean isWriteKeyAsHead) {
        if (rowBean instanceof Iterable) {
            return this.writeRow((Iterable)rowBean);
        }
        Map rowMap = null;
        if (rowBean instanceof Map) {
            rowMap = MapUtils.isNotEmpty(this.headerAlias) ? MapUtils.newTreeMap((Map)((Map)rowBean), this.getInitedAliasComparator()) : (Map)rowBean;
        } else if (BeanUtils.isBean(rowBean.getClass())) {
            rowMap = MapUtils.isEmpty(this.headerAlias) ? BeanUtils.beanToMap((Object)rowBean, new LinkedHashMap(), (boolean)false, (boolean)false) : BeanUtils.beanToMap((Object)rowBean, new TreeMap(this.getInitedAliasComparator()), (boolean)false, (boolean)false);
        } else {
            return this.writeRow(CollUtils.newArrayList((Object[])new Object[]{rowBean}), isWriteKeyAsHead);
        }
        return this.writeRow(rowMap, isWriteKeyAsHead);
    }

    public ExcelWriter writeRow(Map<?, ?> rowMap, boolean isWriteKeyAsHead) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        if (MapUtils.isEmpty(rowMap)) {
            return this.passCurrentRow();
        }
        Map<?, ?> aliasMap = this.aliasMap(rowMap);
        if (isWriteKeyAsHead) {
            this.writeHeadRow(aliasMap.keySet());
        }
        this.writeRow(aliasMap.values());
        return this;
    }

    public ExcelWriter writeRow(Iterable<?> rowData) {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        RowUtils.writeRow(this.sheet.createRow(this.currentRow.getAndIncrement()), rowData, this.styleSet, false);
        return this;
    }

    public ExcelWriter writeCellValue(int x, int y, Object value) {
        Cell cell = this.getOrCreateCell(x, y);
        CellUtils.setCellValue(cell, value, this.styleSet, false);
        return this;
    }

    public Font createFont() {
        return this.getWorkbook().createFont();
    }

    public ExcelWriter flush() throws InstrumentException {
        return this.flush(this.destFile);
    }

    public ExcelWriter flush(File destFile) throws InstrumentException {
        Assert.notNull((Object)destFile, (String)"[destFile] is null, and you must call setDestFile(File) first or call flush(OutputStream).", (Object[])new Object[0]);
        return this.flush(FileUtils.getOutputStream((File)destFile), true);
    }

    public ExcelWriter flush(OutputStream out) throws InstrumentException {
        return this.flush(out, false);
    }

    public ExcelWriter flush(OutputStream out, boolean isCloseOut) throws InstrumentException {
        Assert.isFalse((boolean)this.isClosed, (String)"ExcelWriter has been closed!", (Object[])new Object[0]);
        try {
            this.workbook.write(out);
            out.flush();
        }
        catch (IOException e) {
            throw new InstrumentException((Throwable)e);
        }
        finally {
            if (isCloseOut) {
                IoUtils.close((Closeable)out);
            }
        }
        return this;
    }

    @Override
    public void close() {
        if (null != this.destFile) {
            this.flush();
        }
        this.closeWithoutFlush();
    }

    protected void closeWithoutFlush() {
        super.close();
        this.currentRow = null;
        this.styleSet = null;
    }

    private Map<?, ?> aliasMap(Map<?, ?> rowMap) {
        if (MapUtils.isEmpty(this.headerAlias)) {
            return rowMap;
        }
        LinkedHashMap filteredMap = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : rowMap.entrySet()) {
            String aliasName = this.headerAlias.get(entry.getKey());
            if (null != aliasName) {
                filteredMap.put(aliasName, entry.getValue());
                continue;
            }
            if (this.onlyAlias) continue;
            filteredMap.put((String)entry.getKey(), entry.getValue());
        }
        return filteredMap;
    }

    private Comparator<String> getInitedAliasComparator() {
        if (MapUtils.isEmpty(this.headerAlias)) {
            return null;
        }
        Comparator<String> aliasComparator = this.aliasComparator;
        if (null == aliasComparator) {
            Set<String> keySet = this.headerAlias.keySet();
            this.aliasComparator = aliasComparator = new IndexedComparator<String>(keySet.toArray(new String[keySet.size()]));
        }
        return aliasComparator;
    }

    class IndexedComparator<T>
    implements Comparator<T> {
        private T[] array;

        public IndexedComparator(T ... objs) {
            this.array = objs;
        }

        @Override
        public int compare(T o1, T o2) {
            int index2;
            int index1 = ArrayUtils.indexOf((Object[])this.array, o1);
            if (index1 == (index2 = ArrayUtils.indexOf((Object[])this.array, o2))) {
                return this.compare(o1, o2, true);
            }
            return index1 < index2 ? -1 : 1;
        }

        @Override
        public <T extends Comparable<? super T>> int compare(T c1, T c2) {
            return this.compare(c1, c2, false);
        }

        public <T extends Comparable<? super T>> int compare(T c1, T c2, boolean isNullGreater) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return isNullGreater ? 1 : -1;
            }
            if (c2 == null) {
                return isNullGreater ? -1 : 1;
            }
            return c1.compareTo(c2);
        }

        public <T> int compare(T o1, T o2, boolean isNullGreater) {
            if (o1 == o2) {
                return 0;
            }
            if (null == o1) {
                return isNullGreater ? 1 : -1;
            }
            if (null == o2) {
                return isNullGreater ? -1 : 1;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Integer.compare(o1.hashCode(), o2.hashCode());
            if (0 == result) {
                result = this.compare(o1.toString(), o2.toString());
            }
            return result;
        }
    }
}

