/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.socket.process;

import java.nio.channels.AsynchronousSocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.socket.AioSession;
import org.aoju.bus.socket.NetMonitor;
import org.aoju.bus.socket.SocketStatus;
import org.aoju.bus.socket.plugins.Plugin;
import org.aoju.bus.socket.process.MessageProcessor;

public abstract class AbstractMessageProcessor<T>
implements MessageProcessor<T>,
NetMonitor {
    private final List<Plugin<T>> plugins = new ArrayList<Plugin<T>>();

    @Override
    public final void afterRead(AioSession session, int readSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.afterRead(session, readSize);
        }
    }

    @Override
    public final void afterWrite(AioSession session, int writeSize) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.afterWrite(session, writeSize);
        }
    }

    @Override
    public final void beforeRead(AioSession session) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.beforeRead(session);
        }
    }

    @Override
    public final void beforeWrite(AioSession session) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.beforeWrite(session);
        }
    }

    @Override
    public final AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        AsynchronousSocketChannel acceptChannel = channel;
        for (Plugin<T> plugin : this.plugins) {
            acceptChannel = plugin.shouldAccept(acceptChannel);
            if (acceptChannel != null) continue;
            return null;
        }
        return acceptChannel;
    }

    @Override
    public final void process(AioSession session, T msg) {
        boolean flag = true;
        for (Plugin<T> plugin : this.plugins) {
            if (plugin.preProcess(session, msg)) continue;
            flag = false;
        }
        if (flag) {
            this.process0(session, msg);
        }
    }

    public abstract void process0(AioSession var1, T var2);

    @Override
    public final void stateEvent(AioSession session, SocketStatus socketStatus, Throwable throwable) {
        for (Plugin<T> plugin : this.plugins) {
            plugin.stateEvent(socketStatus, session, throwable);
        }
        this.stateEvent0(session, socketStatus, throwable);
    }

    public abstract void stateEvent0(AioSession var1, SocketStatus var2, Throwable var3);

    public final void addPlugin(Plugin<T> plugin) {
        this.plugins.add(plugin);
    }
}

