/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.apache.httpclient5;

import java.util.Map;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Tracer;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;

public class TraceHttpRequestInterceptor
implements HttpRequestInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;
    private final String profile;

    public TraceHttpRequestInterceptor() {
        this("default");
    }

    public TraceHttpRequestInterceptor(String profile) {
        this(Tracer.getBackend(), profile);
    }

    TraceHttpRequestInterceptor(Backend backend, String profile) {
        this.backend = backend;
        this.transportSerialization = new HttpHeaderTransport();
        this.profile = profile;
    }

    public final void process(HttpRequest httpRequest, EntityDetails entityDetails, HttpContext httpContext) {
        TraceFilterConfig filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceFilterConfig.Channel.OutgoingRequest)) {
            Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfig.Channel.OutgoingRequest);
            httpRequest.setHeader("TPIC", (Object)this.transportSerialization.render(filteredParams));
        }
    }
}

