/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.validate.strategy.AlwaysStrategy;
import org.aoju.bus.validate.strategy.BlankStrategy;
import org.aoju.bus.validate.strategy.ChineseStrategy;
import org.aoju.bus.validate.strategy.CitizenIdStrategy;
import org.aoju.bus.validate.strategy.DateStrategy;
import org.aoju.bus.validate.strategy.EachStrategy;
import org.aoju.bus.validate.strategy.EmailStrategy;
import org.aoju.bus.validate.strategy.EnglishStrategy;
import org.aoju.bus.validate.strategy.EqualsStrategy;
import org.aoju.bus.validate.strategy.FalseStrategy;
import org.aoju.bus.validate.strategy.IPAddressStrategy;
import org.aoju.bus.validate.strategy.InEnumStrategy;
import org.aoju.bus.validate.strategy.InStrategy;
import org.aoju.bus.validate.strategy.IntRangeStrategy;
import org.aoju.bus.validate.strategy.LengthStrategy;
import org.aoju.bus.validate.strategy.MobileStrategy;
import org.aoju.bus.validate.strategy.MultiStrategy;
import org.aoju.bus.validate.strategy.NotBlankStrategy;
import org.aoju.bus.validate.strategy.NotInStrategy;
import org.aoju.bus.validate.strategy.NotNullStrategy;
import org.aoju.bus.validate.strategy.NullStrategy;
import org.aoju.bus.validate.strategy.PhoneStrategy;
import org.aoju.bus.validate.strategy.ReflectStrategy;
import org.aoju.bus.validate.strategy.RegexStrategy;
import org.aoju.bus.validate.strategy.TrueStrategy;

public class Registry {
    private static Map<Object, Object> COMPLEX_CACHE = new ConcurrentHashMap<Object, Object>();
    private static Registry instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Registry getInstance() {
        Class<Registry> clazz = Registry.class;
        synchronized (Registry.class) {
            if (ObjectKit.isEmpty((Object)instance)) {
                instance = new Registry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void register(String name, Object object) {
        if (COMPLEX_CACHE.containsKey(name)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u6821\u9a8c\u5668\uff1a" + name);
        }
        Class<?> clazz = object.getClass();
        if (COMPLEX_CACHE.containsKey(clazz.getSimpleName())) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u7c7b\u578b\u7684\u6821\u9a8c\u5668\uff1a" + String.valueOf(clazz));
        }
        COMPLEX_CACHE.putIfAbsent(name, object);
        COMPLEX_CACHE.putIfAbsent(clazz.getSimpleName(), object);
    }

    public boolean contains(String name) {
        return COMPLEX_CACHE.containsKey(name);
    }

    public Object require(String name) {
        return COMPLEX_CACHE.get(name);
    }

    public Object require(String name, Class<?> clazz) {
        Object object = this.require(name);
        if (ObjectKit.isEmpty((Object)object)) {
            object = this.require(clazz.getSimpleName());
        }
        return object;
    }

    static {
        Registry.register("Always", new AlwaysStrategy());
        Registry.register("Blank", new BlankStrategy());
        Registry.register("Chinese", new ChineseStrategy());
        Registry.register("CitizenId", new CitizenIdStrategy());
        Registry.register("Date", new DateStrategy());
        Registry.register("Each", new EachStrategy());
        Registry.register("Email", new EmailStrategy());
        Registry.register("English", new EnglishStrategy());
        Registry.register("Equals", new EqualsStrategy());
        Registry.register("False", new FalseStrategy());
        Registry.register("InEnum", new InEnumStrategy());
        Registry.register("In", new InStrategy());
        Registry.register("IntRange", new IntRangeStrategy());
        Registry.register("IPAddress", new IPAddressStrategy());
        Registry.register("Length", new LengthStrategy());
        Registry.register("Mobile", new MobileStrategy());
        Registry.register("Multi", new MultiStrategy());
        Registry.register("NotBlank", new NotBlankStrategy());
        Registry.register("NotIn", new NotInStrategy());
        Registry.register("NotNull", new NotNullStrategy());
        Registry.register("Null", new NullStrategy());
        Registry.register("Phone", new PhoneStrategy());
        Registry.register("Reflect", new ReflectStrategy());
        Registry.register("Regex", new RegexStrategy());
        Registry.register("True", new TrueStrategy());
    }
}

