/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.strategy;

import java.math.BigDecimal;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.annotation.Compare;
import org.aoju.bus.validate.validators.Matcher;

public class CompareStrategy
implements Matcher<Object, Compare> {
    @Override
    public boolean on(Object object, Compare annotation, Context context) {
        if (ObjectKit.isEmpty((Object)object)) {
            return false;
        }
        boolean _matched = true;
        Object value = ReflectKit.getFieldValue((Object)object, (String)annotation.with());
        if (value instanceof String) {
            if (MathKit.isNumber((CharSequence)value.toString())) {
                int _compValue = new BigDecimal(value.toString()).compareTo(new BigDecimal(object.toString()));
                switch (annotation.cond()) {
                    case EQ: {
                        _matched = _compValue == 0;
                        break;
                    }
                    case NOT_EQ: {
                        _matched = _compValue != 0;
                        break;
                    }
                    case GT: {
                        _matched = _compValue > 0;
                        break;
                    }
                    case LT: {
                        _matched = _compValue < 0;
                        break;
                    }
                    case GT_EQ: {
                        _matched = _compValue >= 0;
                        break;
                    }
                    case LT_EQ: {
                        _matched = _compValue <= 0;
                        break;
                    }
                }
            } else {
                switch (annotation.cond()) {
                    case EQ: {
                        _matched = StringKit.equals((CharSequence)value.toString(), (CharSequence)object.toString());
                        break;
                    }
                    case NOT_EQ: {
                        _matched = !StringKit.equals((CharSequence)value.toString(), (CharSequence)object.toString());
                        break;
                    }
                }
            }
        }
        return _matched;
    }
}

