/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.validate.strategy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.validate.Context;
import org.aoju.bus.validate.annotation.IntRange;
import org.aoju.bus.validate.validators.Matcher;

public class IntRangeStrategy
implements Matcher<Object, IntRange> {
    private static Set<Class<?>> NumberTypes = new HashSet();

    @Override
    public boolean on(Object object, IntRange annotation, Context context) {
        BigDecimal num;
        if (ObjectKit.isEmpty((Object)object)) {
            return true;
        }
        if (object instanceof String) {
            num = MathKit.add((String[])new String[]{(String)object});
        } else if (NumberTypes.contains(object.getClass())) {
            String numString = String.valueOf(object);
            num = MathKit.add((String[])new String[]{numString});
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u5b57\u683c\u5f0f:" + object.toString());
        }
        BigDecimal max = new BigDecimal(annotation.max());
        BigDecimal min = new BigDecimal(annotation.min());
        return max.compareTo(num) >= 0 && min.compareTo(num) <= 0;
    }

    static {
        NumberTypes.add(Integer.class);
        NumberTypes.add(Long.class);
        NumberTypes.add(Double.class);
        NumberTypes.add(Float.class);
        NumberTypes.add(Integer.TYPE);
        NumberTypes.add(Long.TYPE);
        NumberTypes.add(Double.TYPE);
        NumberTypes.add(Float.TYPE);
        NumberTypes.add(BigDecimal.class);
        NumberTypes.add(BigInteger.class);
    }
}

