/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.spring;

import jakarta.annotation.Resource;
import org.aoju.bus.base.normal.ErrorCode;
import org.aoju.bus.base.service.BaseService;
import org.aoju.bus.base.spring.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

public class BaseController<Service extends BaseService<T>, T>
extends Controller {
    @Resource
    protected Service service;

    @ResponseBody
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Object add(T entity) {
        return BaseController.write(ErrorCode.EM_SUCCESS, this.service.insertSelective(entity));
    }

    @ResponseBody
    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    public Object remove(T entity) {
        this.service.deleteById(entity);
        return BaseController.write(ErrorCode.EM_SUCCESS);
    }

    @ResponseBody
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(T entity) {
        return BaseController.write(ErrorCode.EM_SUCCESS, this.service.updateSelectiveById(entity));
    }

    @ResponseBody
    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    public Object get(T entity) {
        return BaseController.write(this.service.selectById(entity));
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Object list(T entity) {
        return BaseController.write(this.service.selectList(entity));
    }

    @ResponseBody
    @RequestMapping(value={"/page"}, method={RequestMethod.GET})
    public Object page(T entity) {
        return BaseController.write(this.service.page(entity));
    }
}

