/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier.provider;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDesc;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.map.FuncKeyMap;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BeanValueProvider
implements ValueProvider<String> {
    final Map<String, PropertyDesc> sourcePdMap;
    private final Object source;
    private final boolean ignoreError;

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError) {
        this(bean, ignoreCase, ignoreError, null);
    }

    public BeanValueProvider(Object bean, boolean ignoreCase, boolean ignoreError, Editor<String> keyEditor) {
        this.source = bean;
        this.ignoreError = ignoreError;
        Map<String, PropertyDesc> sourcePdMap = BeanKit.getBeanDesc(this.source.getClass()).getPropMap(ignoreCase);
        this.sourcePdMap = new FuncKeyMap<String, PropertyDesc>(new HashMap(sourcePdMap.size(), 1.0f), key -> {
            if (ignoreCase && key instanceof CharSequence) {
                key = key.toString().toLowerCase();
            }
            if (null != keyEditor) {
                key = keyEditor.edit(key.toString());
            }
            return key.toString();
        });
        this.sourcePdMap.putAll(sourcePdMap);
    }

    @Override
    public Object value(String key, Type valueType) {
        PropertyDesc sourcePd = this.getPropertyDesc(key, valueType);
        Object result = null;
        if (null != sourcePd) {
            result = sourcePd.getValue(this.source, valueType, this.ignoreError);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        PropertyDesc sourcePd = this.getPropertyDesc(key, null);
        return null != sourcePd && sourcePd.isReadable(false);
    }

    private PropertyDesc getPropertyDesc(String key, Type valueType) {
        PropertyDesc sourcePd = this.sourcePdMap.get(key);
        if (null == sourcePd && (null == valueType || Boolean.class == valueType || Boolean.TYPE == valueType)) {
            sourcePd = this.sourcePdMap.get(StringKit.upperFirstAndAddPre(key, "is"));
        }
        return sourcePd;
    }
}

