/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.TypeKit;

public abstract class AbstractConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public Object convert(Type targetType, Object value) {
        if (null == value) {
            return null;
        }
        if (TypeKit.isUnknown(targetType)) {
            throw new ConvertException("Unsupported convert to unKnow type: {}", targetType);
        }
        Class<?> targetClass = TypeKit.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        if (targetClass.isInstance(value) && !Map.class.isAssignableFrom(targetClass)) {
            return Assert.notNull(targetClass).cast(value);
        }
        return this.convertInternal(targetClass, value);
    }

    protected abstract Object convertInternal(Class<?> var1, Object var2);

    protected String convertToString(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof CharSequence) {
            return value.toString();
        }
        if (ArrayKit.isArray(value)) {
            return ArrayKit.toString(value);
        }
        if (CharsKit.isChar(value)) {
            return CharsKit.toString(((Character)value).charValue());
        }
        return value.toString();
    }
}

