/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.aoju.bus.core.convert.CompositeConverter;
import org.aoju.bus.core.convert.Converter;
import org.aoju.bus.core.exception.ConvertException;
import org.aoju.bus.core.lang.Types;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class MapConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static MapConverter INSTANCE = new MapConverter();

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        if (targetType instanceof Types) {
            targetType = ((Types)targetType).getType();
        }
        Type keyType = TypeKit.getTypeArgument(targetType, 0);
        Type valueType = TypeKit.getTypeArgument(targetType, 1);
        return this.convert(targetType, keyType, valueType, value);
    }

    public Map<?, ?> convert(Type targetType, Type keyType, Type valueType, Object value) {
        Map<String, Object> map;
        if (value instanceof Map) {
            Type[] typeArguments;
            Class<?> valueClass = value.getClass();
            if (valueClass.equals(targetType) && null != (typeArguments = TypeKit.getTypeArguments(valueClass)) && 2 == typeArguments.length && Objects.equals(keyType, typeArguments[0]) && Objects.equals(valueType, typeArguments[1])) {
                return (Map)value;
            }
            map = MapKit.createMap(TypeKit.getClass(targetType));
            this.convertMapToMap(keyType, valueType, (Map)value, map);
        } else if (BeanKit.isBean(value.getClass())) {
            map = BeanKit.beanToMap(value);
            map = this.convert(targetType, keyType, valueType, map);
        } else {
            throw new UnsupportedOperationException(StringKit.format((CharSequence)"Unsupported toMap value type: {}", value.getClass().getName()));
        }
        return map;
    }

    private void convertMapToMap(Type keyType, Type valueType, Map<?, ?> srcMap, Map targetMap) {
        CompositeConverter convert = CompositeConverter.getInstance();
        srcMap.forEach((key, value) -> {
            key = TypeKit.isUnknown(keyType) ? key : convert.convert(keyType, key, null);
            value = TypeKit.isUnknown(valueType) ? value : convert.convert(valueType, value, null);
            targetMap.put(key, value);
        });
    }
}

