/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import org.aoju.bus.core.convert.AbstractConverter;
import org.aoju.bus.core.convert.CompositeConverter;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class ReferenceConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static ReferenceConverter INSTANCE = new ReferenceConverter();

    @Override
    protected Reference<?> convertInternal(Class<?> targetClass, Object value) {
        Object targetValue = null;
        Type paramType = TypeKit.getTypeArgument(targetClass);
        if (!TypeKit.isUnknown(paramType)) {
            targetValue = CompositeConverter.getInstance().convert(paramType, value);
        }
        if (null == targetValue) {
            targetValue = value;
        }
        if (targetClass == WeakReference.class) {
            return new WeakReference<Object>(targetValue);
        }
        if (targetClass == SoftReference.class) {
            return new SoftReference<Object>(targetValue);
        }
        throw new UnsupportedOperationException(StringKit.format((CharSequence)"Unsupport Reference type: {}", targetClass.getName()));
    }
}

