/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.formatter.parser;

import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.formatter.NormalMotd;
import org.aoju.bus.core.date.formatter.parser.DateParser;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.StringKit;

public class NormalDateParser
extends NormalMotd
implements DateParser {
    public static NormalDateParser INSTANCE = new NormalDateParser();

    @Override
    public DateTime parse(String source) {
        int colonCount = StringKit.count((CharSequence)source, ':');
        switch (colonCount) {
            case 0: {
                return new DateTime((CharSequence)source, Fields.NORM_DATE_FORMAT);
            }
            case 1: {
                return new DateTime((CharSequence)source, Fields.NORM_DATETIME_MINUTE_FORMAT);
            }
            case 2: {
                int indexOfDot = StringKit.indexOf(source, '.');
                if (indexOfDot > 0) {
                    int length1 = source.length();
                    if (length1 - indexOfDot > 4) {
                        source = StringKit.subPre(source, indexOfDot + 4);
                    }
                    return new DateTime((CharSequence)source, Fields.NORM_DATETIME_MS_FORMAT);
                }
                return new DateTime((CharSequence)source, Fields.NORM_DATETIME_FORMAT);
            }
        }
        throw new InternalException("No format fit for date String [{}] !", source);
    }
}

