/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.formatter.parser;

import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.formatter.NormalMotd;
import org.aoju.bus.core.date.formatter.parser.DateParser;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class UTCDateParser
extends NormalMotd
implements DateParser {
    private static final long serialVersionUID = 1L;
    public static UTCDateParser INSTANCE = new UTCDateParser();

    @Override
    public DateTime parse(String source) {
        int length = ((String)source).length();
        if (StringKit.contains((CharSequence)source, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return new DateTime((CharSequence)source, Fields.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength - 4 && length >= patternLength - 6) {
                return new DateTime((CharSequence)source, Fields.OUTPUT_MSEC_FORMAT);
            }
        } else {
            if (StringKit.contains((CharSequence)source, '+')) {
                String zoneOffset = StringKit.subAfter((CharSequence)(source = ((String)source).replace(" +", "+")), '+', true);
                if (StringKit.isBlank(zoneOffset)) {
                    throw new InternalException("Invalid format: [{}]", (String)source);
                }
                if (!StringKit.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StringKit.subBefore((CharSequence)source, '+', true);
                    source = pre + "+" + zoneOffset.substring(0, 2) + ":00";
                }
                if (StringKit.contains((CharSequence)source, ".")) {
                    return new DateTime((CharSequence)source, Fields.MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, Fields.WITH_XXX_OFFSET_FORMAT);
            }
            if (PatternKit.contains("-\\d{2}:?00", (CharSequence)source)) {
                if (':' != ((String)(source = ((String)source).replace(" -", "-"))).charAt(((String)source).length() - 3)) {
                    source = ((String)source).substring(0, ((String)source).length() - 2) + ":00";
                }
                if (StringKit.contains((CharSequence)source, ".")) {
                    return new DateTime((CharSequence)source, Fields.MS_WITH_XXX_OFFSET_FORMAT);
                }
                return new DateTime((CharSequence)source, Fields.WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return new DateTime((CharSequence)source, Fields.SIMPLE_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 5) {
                return new DateTime((CharSequence)((String)source + ":00"), Fields.SIMPLE_FORMAT);
            }
            if (StringKit.contains((CharSequence)source, ".")) {
                return new DateTime((CharSequence)source, Fields.SIMPLE_MS_FORMAT);
            }
        }
        throw new InternalException("No UTC format fit for date String [{}] !", (String)source);
    }
}

