/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.painter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.aoju.bus.core.image.Images;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.ImageElement;
import org.aoju.bus.core.image.painter.Painter;
import org.aoju.bus.core.lang.Scale;

public class ImagePainter
implements Painter {
    @Override
    public void draw(Graphics2D g, AbstractElement element, int canvasWidth) {
        ImageElement imageElement = (ImageElement)element;
        BufferedImage image = imageElement.getImage();
        int width = 0;
        int height = 0;
        switch (imageElement.getZoom()) {
            case ORIGIN: {
                width = image.getWidth();
                height = image.getHeight();
                break;
            }
            case WIDTH: {
                width = imageElement.getWidth();
                height = image.getHeight() * width / image.getWidth();
                break;
            }
            case HEIGHT: {
                height = imageElement.getHeight();
                width = image.getWidth() * height / image.getHeight();
                break;
            }
            case OPTIONAL: {
                height = imageElement.getHeight();
                width = imageElement.getWidth();
            }
        }
        if (null != imageElement.getRoundCorner()) {
            image = Images.makeRoundCorner(image, width, height, imageElement.getRoundCorner());
        }
        if (null != imageElement.getBlur()) {
            image = Images.makeBlur(image, imageElement.getBlur());
        }
        if (imageElement.isCenter()) {
            int centerX = (canvasWidth - width) / 2;
            imageElement.setX(centerX);
        } else if (imageElement.getDirection() == Scale.Direction.RIGHT_LEFT) {
            imageElement.setX(imageElement.getX() - width);
        } else if (imageElement.getDirection() == Scale.Direction.CENTER_LEFT_RIGHT) {
            imageElement.setX(imageElement.getX() - width / 2);
        }
        if (null != imageElement.getRotate()) {
            g.rotate(Math.toRadians(imageElement.getRotate().intValue()), imageElement.getX() + imageElement.getWidth() / 2, imageElement.getY() + imageElement.getHeight() / 2);
        }
        g.setComposite(AlphaComposite.getInstance(3, imageElement.getAlpha()));
        g.drawImage(image, imageElement.getX(), imageElement.getY(), width, height, null);
        if (null != imageElement.getRotate()) {
            g.rotate(-Math.toRadians(imageElement.getRotate().intValue()), imageElement.getX() + imageElement.getWidth() / 2, imageElement.getY() + imageElement.getHeight() / 2);
        }
    }

    @Override
    public void drawRepeat(Graphics2D g, AbstractElement element, int canvasWidth, int canvasHeight) throws Exception {
        ImageElement imageElement = (ImageElement)element;
        BufferedImage image = imageElement.getImage();
        int width = 0;
        int height = 0;
        switch (imageElement.getZoom()) {
            case ORIGIN: {
                width = image.getWidth();
                height = image.getHeight();
                break;
            }
            case WIDTH: {
                width = imageElement.getWidth();
                height = image.getHeight() * width / image.getWidth();
                break;
            }
            case HEIGHT: {
                height = imageElement.getHeight();
                width = image.getWidth() * height / image.getHeight();
                break;
            }
            case OPTIONAL: {
                height = imageElement.getHeight();
                width = imageElement.getWidth();
            }
        }
        int currentX = element.getX();
        int currentY = element.getY();
        while (currentX > 0) {
            currentX = currentX - imageElement.getHorizontal() - width;
        }
        while (currentY > 0) {
            currentY = currentY - imageElement.getVertical() - height;
        }
        int startY = currentY;
        while (currentX < canvasWidth) {
            imageElement.setX(currentX);
            currentX = currentX + imageElement.hashCode() + width;
            while (currentY < canvasHeight) {
                imageElement.setY(currentY);
                currentY = currentY + imageElement.getVertical() + height;
                this.draw(g, imageElement, canvasWidth);
            }
            currentY = startY;
        }
    }
}

