/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.watcher.IgnoreWatcher;
import org.aoju.bus.core.lang.function.XConsumer;
import org.aoju.bus.core.toolkit.FileKit;

public class LineReadWatcher
extends IgnoreWatcher
implements Runnable {
    private final RandomAccessFile randomAccessFile;
    private final Charset charset;
    private final XConsumer<String> lineHandler;

    public LineReadWatcher(RandomAccessFile randomAccessFile, Charset charset, XConsumer<String> lineHandler) {
        this.randomAccessFile = randomAccessFile;
        this.charset = charset;
        this.lineHandler = lineHandler;
    }

    @Override
    public void run() {
        this.onModify(null, null);
    }

    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        Charset charset = this.charset;
        XConsumer<String> lineHandler = this.lineHandler;
        try {
            long currentLength = randomAccessFile.length();
            long position = randomAccessFile.getFilePointer();
            if (position == currentLength) {
                return;
            }
            if (currentLength < position) {
                randomAccessFile.seek(currentLength);
                return;
            }
            FileKit.readLines(randomAccessFile, charset, lineHandler);
            randomAccessFile.seek(currentLength);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

