/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.UriKit;

public class FileResource
implements Resource,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;
    private final String name;
    private final long lastModified;

    public FileResource(Path path) {
        this(path.toFile());
    }

    public FileResource(File file) {
        this(file, file.getName());
    }

    public FileResource(File file, String fileName) {
        Assert.notNull(file, "File must be not null !", new Object[0]);
        this.file = file;
        this.name = ObjectKit.defaultIfNull(fileName, file::getName);
        this.lastModified = file.lastModified();
    }

    public FileResource(String path) {
        this(FileKit.file(path));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return UriKit.getURL(this.file);
    }

    @Override
    public InputStream getStream() {
        return FileKit.getInputStream(this.file);
    }

    @Override
    public boolean isModified() {
        return this.lastModified != this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }

    public File getFile() {
        return this.file;
    }
}

