/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.watcher;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.FileAttribute;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.watcher.WatchKind;
import org.aoju.bus.core.io.watcher.WatchServer;
import org.aoju.bus.core.io.watcher.Watcher;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class WatchMonitor
extends WatchServer {
    public static final WatchEvent.Kind<?> OVERFLOW = WatchKind.OVERFLOW.getValue();
    public static final WatchEvent.Kind<?> ENTRY_MODIFY = WatchKind.MODIFY.getValue();
    public static final WatchEvent.Kind<?> ENTRY_CREATE = WatchKind.CREATE.getValue();
    public static final WatchEvent.Kind<?> ENTRY_DELETE = WatchKind.DELETE.getValue();
    public static final WatchEvent.Kind<?>[] EVENTS_ALL = WatchKind.ALL;
    private static final long serialVersionUID = 1L;
    private Path path;
    private int maxDepth;
    private Path filePath;
    private Watcher watcher;

    public WatchMonitor(File file, WatchEvent.Kind<?> ... events) {
        this(file.toPath(), events);
    }

    public WatchMonitor(String path, WatchEvent.Kind<?> ... events) {
        this(Paths.get(path, new String[0]), events);
    }

    public WatchMonitor(Path path, WatchEvent.Kind<?> ... events) {
        this(path, 0, events);
    }

    public WatchMonitor(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        this.path = path;
        this.maxDepth = maxDepth;
        this.events = events;
        this.init();
    }

    public static WatchMonitor of(URL url, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(url, 0, events);
    }

    public static WatchMonitor of(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(UriKit.toURI(url), maxDepth, events);
    }

    public static WatchMonitor of(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(uri, 0, events);
    }

    public static WatchMonitor of(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor of(File file, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(file, 0, events);
    }

    public static WatchMonitor of(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor of(String path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(path, 0, events);
    }

    public static WatchMonitor of(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor of(Path path, WatchEvent.Kind<?> ... events) {
        return WatchMonitor.of(path, 0, events);
    }

    public static WatchMonitor of(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor ofAll(URI uri, Watcher watcher) {
        return WatchMonitor.ofAll(Paths.get(uri), watcher);
    }

    public static WatchMonitor ofAll(URL url, Watcher watcher) {
        try {
            return WatchMonitor.ofAll(Paths.get(url.toURI()), watcher);
        }
        catch (URISyntaxException e) {
            throw new InternalException(e);
        }
    }

    public static WatchMonitor ofAll(File file, Watcher watcher) {
        return WatchMonitor.ofAll(file.toPath(), watcher);
    }

    public static WatchMonitor ofAll(String path, Watcher watcher) {
        return WatchMonitor.ofAll(Paths.get(path, new String[0]), watcher);
    }

    public static WatchMonitor ofAll(Path path, Watcher watcher) {
        WatchMonitor watchMonitor = WatchMonitor.of(path, EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    @Override
    public void init() throws InternalException {
        if (!Files.exists(this.path, LinkOption.NOFOLLOW_LINKS)) {
            String lastPathEleStr;
            Path lastPathEle = FileKit.getLastPathEle(this.path);
            if (null != lastPathEle && StringKit.contains((CharSequence)(lastPathEleStr = lastPathEle.toString()), '.') && !StringKit.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.filePath = this.path;
                this.path = this.filePath.getParent();
            }
            try {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        } else if (Files.isRegularFile(this.path, LinkOption.NOFOLLOW_LINKS)) {
            this.filePath = this.path;
            this.path = this.filePath.getParent();
        }
        super.init();
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) throws InternalException {
        if (this.isClosed) {
            throw new InternalException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.isClosed) {
            this.doTakeAndWatch(watcher);
        }
    }

    public WatchMonitor setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    private void doTakeAndWatch(Watcher watcher) {
        super.watch(watcher, (WatchEvent<?> watchEvent) -> null == this.filePath || this.filePath.endsWith(watchEvent.context().toString()));
    }

    private void registerPath() {
        this.registerPath(this.path, null != this.filePath ? 0 : this.maxDepth);
    }
}

