/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.aoju.bus.core.exception.InternalException;

public class Fonts {
    public static Font createFont() {
        return new Font(null);
    }

    public static Font createSansSerifFont(int size) {
        return Fonts.createFont("SansSerif", size);
    }

    public static Font createFont(String name, int size) {
        return new Font(name, 0, size);
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException | IOException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new InternalException(e);
            }
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new InternalException(e1);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static Dimension getDimension(FontMetrics metrics, String text) {
        int width = metrics.stringWidth(text);
        int height = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        return new Dimension(width, height);
    }
}

