/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.function;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.aoju.bus.core.exception.InternalException;

@FunctionalInterface
public interface XBinaryOperator<T>
extends BinaryOperator<T>,
Serializable {
    public static <T> XBinaryOperator<T> minBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) <= 0 ? a : b;
    }

    public static <T> XBinaryOperator<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        return (a, b) -> comparator.compare(a, b) >= 0 ? a : b;
    }

    public static <T> XBinaryOperator<T> justBefore() {
        return (l, r) -> l;
    }

    public static <T> XBinaryOperator<T> justAfter() {
        return (l, r) -> r;
    }

    public T applying(T var1, T var2) throws Exception;

    @Override
    default public T apply(T t, T u) {
        try {
            return this.applying(t, u);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }
}

