/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.reflect.LookupFactory;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class MethodHandle {
    public static MethodHandles.Lookup lookup(Class<?> callerClass) {
        return LookupFactory.lookup(callerClass);
    }

    public static java.lang.invoke.MethodHandle findMethod(Class<?> callerClass, String name, MethodType type) {
        if (StringKit.isBlank(name)) {
            return MethodHandle.findConstructor(callerClass, type);
        }
        java.lang.invoke.MethodHandle handle = null;
        MethodHandles.Lookup lookup = MethodHandle.lookup(callerClass);
        try {
            handle = lookup.findVirtual(callerClass, name, type);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (null == handle) {
            try {
                handle = lookup.findStatic(callerClass, name, type);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        if (null == handle) {
            try {
                handle = lookup.findSpecial(callerClass, name, type, callerClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException e) {
                throw new InternalException(e);
            }
        }
        return handle;
    }

    public static java.lang.invoke.MethodHandle findConstructor(Class<?> callerClass, Class<?> ... args) {
        return MethodHandle.findConstructor(callerClass, MethodType.methodType(Void.TYPE, args));
    }

    public static java.lang.invoke.MethodHandle findConstructor(Class<?> callerClass, MethodType type) {
        MethodHandles.Lookup lookup = MethodHandle.lookup(callerClass);
        try {
            return lookup.findConstructor(callerClass, type);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e);
        }
    }

    public static <T> T invokeSpecial(Object object, String methodName, Object ... args) {
        Assert.notNull(object, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectKit.getMethodOfObject(object, methodName, args);
        if (null == method) {
            throw new InternalException("No such method: [{}] from [{}]", methodName, object.getClass());
        }
        return MethodHandle.invokeSpecial(object, method, args);
    }

    public static <T> T invoke(Object object, Method method, Object ... args) {
        return MethodHandle.invoke(false, object, method, args);
    }

    public static <T> T invokeSpecial(Object object, Method method, Object ... args) {
        return MethodHandle.invoke(true, object, method, args);
    }

    public static <T> T invoke(boolean isSpecial, Object object, Method method, Object ... args) {
        Assert.notNull(method, "Method must be not null!", new Object[0]);
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = MethodHandle.lookup(declaringClass);
        try {
            java.lang.invoke.MethodHandle handle;
            java.lang.invoke.MethodHandle methodHandle = handle = isSpecial ? lookup.unreflectSpecial(method, declaringClass) : lookup.unreflect(method);
            if (null != object) {
                handle = handle.bindTo(object);
            }
            return (T)handle.invokeWithArguments(args);
        }
        catch (Throwable e) {
            throw new InternalException(e);
        }
    }
}

