/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aoju.bus.core.scanner.AnnotationScanner;
import org.aoju.bus.core.toolkit.AnnoKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public class MetaScanner
implements AnnotationScanner {
    private final boolean includeSupperMetaAnnotation;

    public MetaScanner(boolean includeSupperMetaAnnotation) {
        this.includeSupperMetaAnnotation = includeSupperMetaAnnotation;
    }

    public MetaScanner() {
        this(true);
    }

    @Override
    public boolean support(AnnotatedElement annotatedEle) {
        return annotatedEle instanceof Class && ClassKit.isAssignable(Annotation.class, (Class)annotatedEle);
    }

    @Override
    public List<Annotation> getAnnotations(AnnotatedElement annotatedEle) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        this.scan((index, annotation) -> annotations.add((Annotation)annotation), annotatedEle, annotation -> ObjectKit.notEquals(annotation, annotatedEle));
        return annotations;
    }

    @Override
    public void scan(BiConsumer<Integer, Annotation> consumer, AnnotatedElement annotatedEle, Predicate<Annotation> filter) {
        filter = ObjectKit.defaultIfNull(filter, t -> true);
        LinkedList<List> deque = CollKit.newLinkedList(CollKit.newArrayList((Class)annotatedEle));
        int distance = 0;
        do {
            List annotationTypes = (List)deque.removeFirst();
            for (Class type : annotationTypes) {
                List metaAnnotations = Stream.of(type.getAnnotations()).filter(a -> !AnnoKit.isJdkMetaAnnotation(a.annotationType())).filter(filter).collect(Collectors.toList());
                for (Annotation metaAnnotation : metaAnnotations) {
                    consumer.accept(distance, metaAnnotation);
                }
                deque.addLast(CollKit.toList(metaAnnotations, Annotation::annotationType));
            }
            ++distance;
        } while (this.includeSupperMetaAnnotation && !deque.isEmpty());
    }
}

