/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.escape;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.text.escape.JavaUnicodeEscaper;
import org.aoju.bus.core.text.escape.NumericEscaper;
import org.aoju.bus.core.text.escape.NumericUnescaper;
import org.aoju.bus.core.text.escape.OctalUnescaper;
import org.aoju.bus.core.text.escape.UnicodeUnescaper;
import org.aoju.bus.core.text.escape.UnicodeUnpaired;
import org.aoju.bus.core.text.translate.AggregateTranslator;
import org.aoju.bus.core.text.translate.CharSequenceTranslator;
import org.aoju.bus.core.text.translate.LookupTranslator;

public class EscapeCodeValues {
    public static CharSequenceTranslator ESCAPE_XSI;
    public static CharSequenceTranslator UNESCAPE_XSI;
    public static CharSequenceTranslator ESCAPE_JAVA;
    public static CharSequenceTranslator UNESCAPE_JAVA;
    public static CharSequenceTranslator ESCAPE_ECMASCRIPT;
    public static CharSequenceTranslator UNESCAPE_ECMASCRIPT;
    public static CharSequenceTranslator ESCAPE_JSON;
    public static CharSequenceTranslator UNESCAPE_JSON;
    public static CharSequenceTranslator ESCAPE_XML10;
    public static CharSequenceTranslator ESCAPE_XML11;
    public static CharSequenceTranslator UNESCAPE_XML;
    public static CharSequenceTranslator ESCAPE_HTML3;
    public static CharSequenceTranslator UNESCAPE_HTML3;
    public static CharSequenceTranslator ESCAPE_HTML4;
    public static CharSequenceTranslator UNESCAPE_HTML4;

    public static Map<CharSequence, CharSequence> invert(Map<CharSequence, CharSequence> map) {
        HashMap<CharSequence, CharSequence> newMap = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<CharSequence, CharSequence> pair : map.entrySet()) {
            newMap.put(pair.getValue(), pair.getKey());
        }
        return newMap;
    }

    static {
        UNESCAPE_XSI = new XsiUnescaper();
        HashMap<String, String> ISO8859_1_ESCAPE_MAP = new HashMap<String, String>();
        HashMap<String, String> JAVA_ESCAPE = new HashMap<String, String>();
        HashMap<String, String> UNESCAPE_JAVA_MAP = new HashMap<String, String>();
        HashMap<String, String> HTML40_ESCAPE_MAP = new HashMap<String, String>();
        HashMap<String, String> BASIC_ESCAPE_MAP = new HashMap<String, String>();
        HashMap<String, String> APOS_ESCAPE_MAP = new HashMap<String, String>();
        HashMap<String, String> ESCAPE_JAVA_MAP = new HashMap<String, String>();
        HashMap<String, String> ESCAPE_ECMASCRIPT_MAP = new HashMap<String, String>();
        HashMap<String, String> escapeJsonMap = new HashMap<String, String>();
        HashMap<String, String> ESCAPE_XML10_MAP = new HashMap<String, String>();
        HashMap<String, String> ESCAPE_XML11_MAP = new HashMap<String, String>();
        HashMap<String, String> ESCAPE_XSI_MAP = new HashMap<String, String>();
        ISO8859_1_ESCAPE_MAP.put("\u00a0", "&nbsp;");
        ISO8859_1_ESCAPE_MAP.put("\u00a1", "&iexcl;");
        ISO8859_1_ESCAPE_MAP.put("\u00a2", "&cent;");
        ISO8859_1_ESCAPE_MAP.put("\u00a3", "&pound;");
        ISO8859_1_ESCAPE_MAP.put("\u00a4", "&curren;");
        ISO8859_1_ESCAPE_MAP.put("\u00a5", "&yen;");
        ISO8859_1_ESCAPE_MAP.put("\u00a6", "&brvbar;");
        ISO8859_1_ESCAPE_MAP.put("\u00a7", "&sect;");
        ISO8859_1_ESCAPE_MAP.put("\u00a8", "&uml;");
        ISO8859_1_ESCAPE_MAP.put("\u00a9", "&copy;");
        ISO8859_1_ESCAPE_MAP.put("\u00aa", "&ordf;");
        ISO8859_1_ESCAPE_MAP.put("\u00ab", "&laquo;");
        ISO8859_1_ESCAPE_MAP.put("\u00ac", "&not;");
        ISO8859_1_ESCAPE_MAP.put("\u00ad", "&shy;");
        ISO8859_1_ESCAPE_MAP.put("\u00ae", "&reg;");
        ISO8859_1_ESCAPE_MAP.put("\u00af", "&macr;");
        ISO8859_1_ESCAPE_MAP.put("\u00b0", "&deg;");
        ISO8859_1_ESCAPE_MAP.put("\u00b1", "&plusmn;");
        ISO8859_1_ESCAPE_MAP.put("\u00b2", "&sup2;");
        ISO8859_1_ESCAPE_MAP.put("\u00b3", "&sup3;");
        ISO8859_1_ESCAPE_MAP.put("\u00b4", "&acute;");
        ISO8859_1_ESCAPE_MAP.put("\u00b5", "&micro;");
        ISO8859_1_ESCAPE_MAP.put("\u00b6", "&para;");
        ISO8859_1_ESCAPE_MAP.put("\u00b7", "&middot;");
        ISO8859_1_ESCAPE_MAP.put("\u00b8", "&cedil;");
        ISO8859_1_ESCAPE_MAP.put("\u00b9", "&sup1;");
        ISO8859_1_ESCAPE_MAP.put("\u00ba", "&ordm;");
        ISO8859_1_ESCAPE_MAP.put("\u00bb", "&raquo;");
        ISO8859_1_ESCAPE_MAP.put("\u00bc", "&frac14;");
        ISO8859_1_ESCAPE_MAP.put("\u00bd", "&frac12;");
        ISO8859_1_ESCAPE_MAP.put("\u00be", "&frac34;");
        ISO8859_1_ESCAPE_MAP.put("\u00bf", "&iquest;");
        ISO8859_1_ESCAPE_MAP.put("\u00c0", "&Agrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00c1", "&Aacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00c2", "&Acirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00c3", "&Atilde;");
        ISO8859_1_ESCAPE_MAP.put("\u00c4", "&Auml;");
        ISO8859_1_ESCAPE_MAP.put("\u00c5", "&Aring;");
        ISO8859_1_ESCAPE_MAP.put("\u00c6", "&AElig;");
        ISO8859_1_ESCAPE_MAP.put("\u00c7", "&Ccedil;");
        ISO8859_1_ESCAPE_MAP.put("\u00c8", "&Egrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00c9", "&Eacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00ca", "&Ecirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00cb", "&Euml;");
        ISO8859_1_ESCAPE_MAP.put("\u00cc", "&Igrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00cd", "&Iacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00ce", "&Icirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00cf", "&Iuml;");
        ISO8859_1_ESCAPE_MAP.put("\u00d0", "&ETH;");
        ISO8859_1_ESCAPE_MAP.put("\u00d1", "&Ntilde;");
        ISO8859_1_ESCAPE_MAP.put("\u00d2", "&Ograve;");
        ISO8859_1_ESCAPE_MAP.put("\u00d3", "&Oacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00d4", "&Ocirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00d5", "&Otilde;");
        ISO8859_1_ESCAPE_MAP.put("\u00d6", "&Ouml;");
        ISO8859_1_ESCAPE_MAP.put("\u00d7", "&times;");
        ISO8859_1_ESCAPE_MAP.put("\u00d8", "&Oslash;");
        ISO8859_1_ESCAPE_MAP.put("\u00d9", "&Ugrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00da", "&Uacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00db", "&Ucirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00dc", "&Uuml;");
        ISO8859_1_ESCAPE_MAP.put("\u00dd", "&Yacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00de", "&THORN;");
        ISO8859_1_ESCAPE_MAP.put("\u00df", "&szlig;");
        ISO8859_1_ESCAPE_MAP.put("\u00e0", "&agrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00e1", "&aacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00e2", "&acirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00e3", "&atilde;");
        ISO8859_1_ESCAPE_MAP.put("\u00e4", "&auml;");
        ISO8859_1_ESCAPE_MAP.put("\u00e5", "&aring;");
        ISO8859_1_ESCAPE_MAP.put("\u00e6", "&aelig;");
        ISO8859_1_ESCAPE_MAP.put("\u00e7", "&ccedil;");
        ISO8859_1_ESCAPE_MAP.put("\u00e8", "&egrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00e9", "&eacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00ea", "&ecirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00eb", "&euml;");
        ISO8859_1_ESCAPE_MAP.put("\u00ec", "&igrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00ed", "&iacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00ee", "&icirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00ef", "&iuml;");
        ISO8859_1_ESCAPE_MAP.put("\u00f0", "&eth;");
        ISO8859_1_ESCAPE_MAP.put("\u00f1", "&ntilde;");
        ISO8859_1_ESCAPE_MAP.put("\u00f2", "&ograve;");
        ISO8859_1_ESCAPE_MAP.put("\u00f3", "&oacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00f4", "&ocirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00f5", "&otilde;");
        ISO8859_1_ESCAPE_MAP.put("\u00f6", "&ouml;");
        ISO8859_1_ESCAPE_MAP.put("\u00f7", "&divide;");
        ISO8859_1_ESCAPE_MAP.put("\u00f8", "&oslash;");
        ISO8859_1_ESCAPE_MAP.put("\u00f9", "&ugrave;");
        ISO8859_1_ESCAPE_MAP.put("\u00fa", "&uacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00fb", "&ucirc;");
        ISO8859_1_ESCAPE_MAP.put("\u00fc", "&uuml;");
        ISO8859_1_ESCAPE_MAP.put("\u00fd", "&yacute;");
        ISO8859_1_ESCAPE_MAP.put("\u00fe", "&thorn;");
        ISO8859_1_ESCAPE_MAP.put("\u00ff", "&yuml;");
        JAVA_ESCAPE.put("\b", "\\b");
        JAVA_ESCAPE.put("\n", "\\n");
        JAVA_ESCAPE.put("\t", "\\t");
        JAVA_ESCAPE.put("\f", "\\f");
        JAVA_ESCAPE.put("\r", "\\r");
        UNESCAPE_JAVA_MAP.put("\\\\", "\\");
        UNESCAPE_JAVA_MAP.put("\\\"", "\"");
        UNESCAPE_JAVA_MAP.put("\\'", "'");
        UNESCAPE_JAVA_MAP.put("\\", "");
        HTML40_ESCAPE_MAP.put("\u0192", "&fnof;");
        HTML40_ESCAPE_MAP.put("\u0391", "&Alpha;");
        HTML40_ESCAPE_MAP.put("\u0392", "&Beta;");
        HTML40_ESCAPE_MAP.put("\u0393", "&Gamma;");
        HTML40_ESCAPE_MAP.put("\u0394", "&Delta;");
        HTML40_ESCAPE_MAP.put("\u0395", "&Epsilon;");
        HTML40_ESCAPE_MAP.put("\u0396", "&Zeta;");
        HTML40_ESCAPE_MAP.put("\u0397", "&Eta;");
        HTML40_ESCAPE_MAP.put("\u0398", "&Theta;");
        HTML40_ESCAPE_MAP.put("\u0399", "&Iota;");
        HTML40_ESCAPE_MAP.put("\u039a", "&Kappa;");
        HTML40_ESCAPE_MAP.put("\u039b", "&Lambda;");
        HTML40_ESCAPE_MAP.put("\u039c", "&Mu;");
        HTML40_ESCAPE_MAP.put("\u039d", "&Nu;");
        HTML40_ESCAPE_MAP.put("\u039e", "&Xi;");
        HTML40_ESCAPE_MAP.put("\u039f", "&Omicron;");
        HTML40_ESCAPE_MAP.put("\u03a0", "&Pi;");
        HTML40_ESCAPE_MAP.put("\u03a1", "&Rho;");
        HTML40_ESCAPE_MAP.put("\u03a3", "&Sigma;");
        HTML40_ESCAPE_MAP.put("\u03a4", "&Tau;");
        HTML40_ESCAPE_MAP.put("\u03a5", "&Upsilon;");
        HTML40_ESCAPE_MAP.put("\u03a6", "&Phi;");
        HTML40_ESCAPE_MAP.put("\u03a7", "&Chi;");
        HTML40_ESCAPE_MAP.put("\u03a8", "&Psi;");
        HTML40_ESCAPE_MAP.put("\u03a9", "&Omega;");
        HTML40_ESCAPE_MAP.put("\u03b1", "&alpha;");
        HTML40_ESCAPE_MAP.put("\u03b2", "&beta;");
        HTML40_ESCAPE_MAP.put("\u03b3", "&gamma;");
        HTML40_ESCAPE_MAP.put("\u03b4", "&delta;");
        HTML40_ESCAPE_MAP.put("\u03b5", "&epsilon;");
        HTML40_ESCAPE_MAP.put("\u03b6", "&zeta;");
        HTML40_ESCAPE_MAP.put("\u03b7", "&eta;");
        HTML40_ESCAPE_MAP.put("\u03b8", "&theta;");
        HTML40_ESCAPE_MAP.put("\u03b9", "&iota;");
        HTML40_ESCAPE_MAP.put("\u03ba", "&kappa;");
        HTML40_ESCAPE_MAP.put("\u03bb", "&lambda;");
        HTML40_ESCAPE_MAP.put("\u03bc", "&mu;");
        HTML40_ESCAPE_MAP.put("\u03bd", "&nu;");
        HTML40_ESCAPE_MAP.put("\u03be", "&xi;");
        HTML40_ESCAPE_MAP.put("\u03bf", "&omicron;");
        HTML40_ESCAPE_MAP.put("\u03c0", "&pi;");
        HTML40_ESCAPE_MAP.put("\u03c1", "&rho;");
        HTML40_ESCAPE_MAP.put("\u03c2", "&sigmaf;");
        HTML40_ESCAPE_MAP.put("\u03c3", "&sigma;");
        HTML40_ESCAPE_MAP.put("\u03c4", "&tau;");
        HTML40_ESCAPE_MAP.put("\u03c5", "&upsilon;");
        HTML40_ESCAPE_MAP.put("\u03c6", "&phi;");
        HTML40_ESCAPE_MAP.put("\u03c7", "&chi;");
        HTML40_ESCAPE_MAP.put("\u03c8", "&psi;");
        HTML40_ESCAPE_MAP.put("\u03c9", "&omega;");
        HTML40_ESCAPE_MAP.put("\u03d1", "&thetasym;");
        HTML40_ESCAPE_MAP.put("\u03d2", "&upsih;");
        HTML40_ESCAPE_MAP.put("\u03d6", "&piv;");
        HTML40_ESCAPE_MAP.put("\u2022", "&bull;");
        HTML40_ESCAPE_MAP.put("\u2026", "&hellip;");
        HTML40_ESCAPE_MAP.put("\u2032", "&prime;");
        HTML40_ESCAPE_MAP.put("\u2033", "&Prime;");
        HTML40_ESCAPE_MAP.put("\u203e", "&oline;");
        HTML40_ESCAPE_MAP.put("\u2044", "&frasl;");
        HTML40_ESCAPE_MAP.put("\u2118", "&weierp;");
        HTML40_ESCAPE_MAP.put("\u2111", "&image;");
        HTML40_ESCAPE_MAP.put("\u211c", "&real;");
        HTML40_ESCAPE_MAP.put("\u2122", "&trade;");
        HTML40_ESCAPE_MAP.put("\u2135", "&alefsym;");
        HTML40_ESCAPE_MAP.put("\u2190", "&larr;");
        HTML40_ESCAPE_MAP.put("\u2191", "&uarr;");
        HTML40_ESCAPE_MAP.put("\u2192", "&rarr;");
        HTML40_ESCAPE_MAP.put("\u2193", "&darr;");
        HTML40_ESCAPE_MAP.put("\u2194", "&harr;");
        HTML40_ESCAPE_MAP.put("\u21b5", "&crarr;");
        HTML40_ESCAPE_MAP.put("\u21d0", "&lArr;");
        HTML40_ESCAPE_MAP.put("\u21d1", "&uArr;");
        HTML40_ESCAPE_MAP.put("\u21d2", "&rArr;");
        HTML40_ESCAPE_MAP.put("\u21d3", "&dArr;");
        HTML40_ESCAPE_MAP.put("\u21d4", "&hArr;");
        HTML40_ESCAPE_MAP.put("\u2200", "&forall;");
        HTML40_ESCAPE_MAP.put("\u2202", "&part;");
        HTML40_ESCAPE_MAP.put("\u2203", "&exist;");
        HTML40_ESCAPE_MAP.put("\u2205", "&empty;");
        HTML40_ESCAPE_MAP.put("\u2207", "&nabla;");
        HTML40_ESCAPE_MAP.put("\u2208", "&isin;");
        HTML40_ESCAPE_MAP.put("\u2209", "&notin;");
        HTML40_ESCAPE_MAP.put("\u220b", "&ni;");
        HTML40_ESCAPE_MAP.put("\u220f", "&prod;");
        HTML40_ESCAPE_MAP.put("\u2211", "&sum;");
        HTML40_ESCAPE_MAP.put("\u2212", "&minus;");
        HTML40_ESCAPE_MAP.put("\u2217", "&lowast;");
        HTML40_ESCAPE_MAP.put("\u221a", "&radic;");
        HTML40_ESCAPE_MAP.put("\u221d", "&prop;");
        HTML40_ESCAPE_MAP.put("\u221e", "&infin;");
        HTML40_ESCAPE_MAP.put("\u2220", "&ang;");
        HTML40_ESCAPE_MAP.put("\u2227", "&and;");
        HTML40_ESCAPE_MAP.put("\u2228", "&or;");
        HTML40_ESCAPE_MAP.put("\u2229", "&cap;");
        HTML40_ESCAPE_MAP.put("\u222a", "&cup;");
        HTML40_ESCAPE_MAP.put("\u222b", "&int;");
        HTML40_ESCAPE_MAP.put("\u2234", "&there4;");
        HTML40_ESCAPE_MAP.put("\u223c", "&sim;");
        HTML40_ESCAPE_MAP.put("\u2245", "&cong;");
        HTML40_ESCAPE_MAP.put("\u2248", "&asymp;");
        HTML40_ESCAPE_MAP.put("\u2260", "&ne;");
        HTML40_ESCAPE_MAP.put("\u2261", "&equiv;");
        HTML40_ESCAPE_MAP.put("\u2264", "&le;");
        HTML40_ESCAPE_MAP.put("\u2265", "&ge;");
        HTML40_ESCAPE_MAP.put("\u2282", "&sub;");
        HTML40_ESCAPE_MAP.put("\u2283", "&sup;");
        HTML40_ESCAPE_MAP.put("\u2284", "&nsub;");
        HTML40_ESCAPE_MAP.put("\u2286", "&sube;");
        HTML40_ESCAPE_MAP.put("\u2287", "&supe;");
        HTML40_ESCAPE_MAP.put("\u2295", "&oplus;");
        HTML40_ESCAPE_MAP.put("\u2297", "&otimes;");
        HTML40_ESCAPE_MAP.put("\u22a5", "&perp;");
        HTML40_ESCAPE_MAP.put("\u22c5", "&sdot;");
        HTML40_ESCAPE_MAP.put("\u2308", "&lceil;");
        HTML40_ESCAPE_MAP.put("\u2309", "&rceil;");
        HTML40_ESCAPE_MAP.put("\u230a", "&lfloor;");
        HTML40_ESCAPE_MAP.put("\u230b", "&rfloor;");
        HTML40_ESCAPE_MAP.put("\u2329", "&lang;");
        HTML40_ESCAPE_MAP.put("\u232a", "&rang;");
        HTML40_ESCAPE_MAP.put("\u25ca", "&loz;");
        HTML40_ESCAPE_MAP.put("\u2660", "&spades;");
        HTML40_ESCAPE_MAP.put("\u2663", "&clubs;");
        HTML40_ESCAPE_MAP.put("\u2665", "&hearts;");
        HTML40_ESCAPE_MAP.put("\u2666", "&diams;");
        HTML40_ESCAPE_MAP.put("\u0152", "&OElig;");
        HTML40_ESCAPE_MAP.put("\u0153", "&oelig;");
        HTML40_ESCAPE_MAP.put("\u0160", "&Scaron;");
        HTML40_ESCAPE_MAP.put("\u0161", "&scaron;");
        HTML40_ESCAPE_MAP.put("\u0178", "&Yuml;");
        HTML40_ESCAPE_MAP.put("\u02c6", "&circ;");
        HTML40_ESCAPE_MAP.put("\u02dc", "&tilde;");
        HTML40_ESCAPE_MAP.put("\u2002", "&ensp;");
        HTML40_ESCAPE_MAP.put("\u2003", "&emsp;");
        HTML40_ESCAPE_MAP.put("\u2009", "&thinsp;");
        HTML40_ESCAPE_MAP.put("\u200c", "&zwnj;");
        HTML40_ESCAPE_MAP.put("\u200d", "&zwj;");
        HTML40_ESCAPE_MAP.put("\u200e", "&lrm;");
        HTML40_ESCAPE_MAP.put("\u200f", "&rlm;");
        HTML40_ESCAPE_MAP.put("\u2013", "&ndash;");
        HTML40_ESCAPE_MAP.put("\u2014", "&mdash;");
        HTML40_ESCAPE_MAP.put("\u2018", "&lsquo;");
        HTML40_ESCAPE_MAP.put("\u2019", "&rsquo;");
        HTML40_ESCAPE_MAP.put("\u201a", "&sbquo;");
        HTML40_ESCAPE_MAP.put("\u201c", "&ldquo;");
        HTML40_ESCAPE_MAP.put("\u201d", "&rdquo;");
        HTML40_ESCAPE_MAP.put("\u201e", "&bdquo;");
        HTML40_ESCAPE_MAP.put("\u2020", "&dagger;");
        HTML40_ESCAPE_MAP.put("\u2021", "&Dagger;");
        HTML40_ESCAPE_MAP.put("\u2030", "&permil;");
        HTML40_ESCAPE_MAP.put("\u2039", "&lsaquo;");
        HTML40_ESCAPE_MAP.put("\u203a", "&rsaquo;");
        HTML40_ESCAPE_MAP.put("\u20ac", "&euro;");
        BASIC_ESCAPE_MAP.put("\"", "&quot;");
        BASIC_ESCAPE_MAP.put("&", "&amp;");
        BASIC_ESCAPE_MAP.put("<", "&lt;");
        BASIC_ESCAPE_MAP.put(">", "&gt;");
        APOS_ESCAPE_MAP.put("'", "&apos;");
        ESCAPE_JAVA_MAP.put("\"", "\\\"");
        ESCAPE_JAVA_MAP.put("\\", "\\\\");
        ESCAPE_ECMASCRIPT_MAP.put("'", "\\'");
        ESCAPE_ECMASCRIPT_MAP.put("\"", "\\\"");
        ESCAPE_ECMASCRIPT_MAP.put("\\", "\\\\");
        ESCAPE_ECMASCRIPT_MAP.put("/", "\\/");
        escapeJsonMap.put("\"", "\\\"");
        escapeJsonMap.put("\\", "\\\\");
        escapeJsonMap.put("/", "\\/");
        ESCAPE_XML10_MAP.put("\u0000", "");
        ESCAPE_XML10_MAP.put("\u0001", "");
        ESCAPE_XML10_MAP.put("\u0002", "");
        ESCAPE_XML10_MAP.put("\u0003", "");
        ESCAPE_XML10_MAP.put("\u0004", "");
        ESCAPE_XML10_MAP.put("\u0005", "");
        ESCAPE_XML10_MAP.put("\u0006", "");
        ESCAPE_XML10_MAP.put("\u0007", "");
        ESCAPE_XML10_MAP.put("\b", "");
        ESCAPE_XML10_MAP.put("\u000b", "");
        ESCAPE_XML10_MAP.put("\f", "");
        ESCAPE_XML10_MAP.put("\u000e", "");
        ESCAPE_XML10_MAP.put("\u000f", "");
        ESCAPE_XML10_MAP.put("\u0010", "");
        ESCAPE_XML10_MAP.put("\u0011", "");
        ESCAPE_XML10_MAP.put("\u0012", "");
        ESCAPE_XML10_MAP.put("\u0013", "");
        ESCAPE_XML10_MAP.put("\u0014", "");
        ESCAPE_XML10_MAP.put("\u0015", "");
        ESCAPE_XML10_MAP.put("\u0016", "");
        ESCAPE_XML10_MAP.put("\u0017", "");
        ESCAPE_XML10_MAP.put("\u0018", "");
        ESCAPE_XML10_MAP.put("\u0019", "");
        ESCAPE_XML10_MAP.put("\u001a", "");
        ESCAPE_XML10_MAP.put("\u001b", "");
        ESCAPE_XML10_MAP.put("\u001c", "");
        ESCAPE_XML10_MAP.put("\u001d", "");
        ESCAPE_XML10_MAP.put("\u001e", "");
        ESCAPE_XML10_MAP.put("\u001f", "");
        ESCAPE_XML10_MAP.put("\ufffe", "");
        ESCAPE_XML10_MAP.put("\uffff", "");
        ESCAPE_XML11_MAP.put("\u0000", "");
        ESCAPE_XML11_MAP.put("\u000b", "&#11;");
        ESCAPE_XML11_MAP.put("\f", "&#12;");
        ESCAPE_XML11_MAP.put("\ufffe", "");
        ESCAPE_XML11_MAP.put("\uffff", "");
        ESCAPE_XSI_MAP.put("|", "\\|");
        ESCAPE_XSI_MAP.put("&", "\\&");
        ESCAPE_XSI_MAP.put(";", "\\;");
        ESCAPE_XSI_MAP.put("<", "\\<");
        ESCAPE_XSI_MAP.put(">", "\\>");
        ESCAPE_XSI_MAP.put("(", "\\(");
        ESCAPE_XSI_MAP.put(")", "\\)");
        ESCAPE_XSI_MAP.put("$", "\\$");
        ESCAPE_XSI_MAP.put("`", "\\`");
        ESCAPE_XSI_MAP.put("\\", "\\\\");
        ESCAPE_XSI_MAP.put("\"", "\\\"");
        ESCAPE_XSI_MAP.put("'", "\\'");
        ESCAPE_XSI_MAP.put(" ", "\\ ");
        ESCAPE_XSI_MAP.put("\t", "\\\t");
        ESCAPE_XSI_MAP.put("\r\n", "");
        ESCAPE_XSI_MAP.put("\n", "");
        ESCAPE_XSI_MAP.put("*", "\\*");
        ESCAPE_XSI_MAP.put("?", "\\?");
        ESCAPE_XSI_MAP.put("[", "\\[");
        ESCAPE_XSI_MAP.put("#", "\\#");
        ESCAPE_XSI_MAP.put("~", "\\~");
        ESCAPE_XSI_MAP.put("=", "\\=");
        ESCAPE_XSI_MAP.put("%", "\\%");
        Map<CharSequence, CharSequence> ISO8859_1_ESCAPE = Collections.unmodifiableMap(ISO8859_1_ESCAPE_MAP);
        Map<CharSequence, CharSequence> ISO8859_1_UNESCAPE = Collections.unmodifiableMap(EscapeCodeValues.invert(ISO8859_1_ESCAPE));
        Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_ESCAPE = Collections.unmodifiableMap(JAVA_ESCAPE);
        Map<CharSequence, CharSequence> JAVA_CTRL_CHARS_UNESCAPE = Collections.unmodifiableMap(EscapeCodeValues.invert(JAVA_CTRL_CHARS_ESCAPE));
        Map<CharSequence, CharSequence> HTML40_EXTENDED_ESCAPE = Collections.unmodifiableMap(HTML40_ESCAPE_MAP);
        Map<CharSequence, CharSequence> HTML40_EXTENDED_UNESCAPE = Collections.unmodifiableMap(EscapeCodeValues.invert(HTML40_EXTENDED_ESCAPE));
        Map<CharSequence, CharSequence> BASIC_ESCAPE = Collections.unmodifiableMap(BASIC_ESCAPE_MAP);
        Map<CharSequence, CharSequence> BASIC_UNESCAPE = Collections.unmodifiableMap(EscapeCodeValues.invert(BASIC_ESCAPE));
        Map<CharSequence, CharSequence> APOS_ESCAPE = Collections.unmodifiableMap(APOS_ESCAPE_MAP);
        Map<CharSequence, CharSequence> APOS_UNESCAPE = Collections.unmodifiableMap(EscapeCodeValues.invert(APOS_ESCAPE));
        ESCAPE_JAVA = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(ESCAPE_JAVA_MAP)), new LookupTranslator(JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
        UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator(Collections.unmodifiableMap(UNESCAPE_JAVA_MAP)));
        ESCAPE_ECMASCRIPT = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(ESCAPE_ECMASCRIPT_MAP)), new LookupTranslator(JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
        ESCAPE_JSON = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(escapeJsonMap)), new LookupTranslator(JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 126));
        ESCAPE_XML10 = new AggregateTranslator(new LookupTranslator(BASIC_ESCAPE), new LookupTranslator(APOS_ESCAPE), new LookupTranslator(Collections.unmodifiableMap(ESCAPE_XML10_MAP)), NumericEscaper.between(127, 132), NumericEscaper.between(134, 159), new UnicodeUnpaired());
        ESCAPE_XML11 = new AggregateTranslator(new LookupTranslator(BASIC_ESCAPE), new LookupTranslator(APOS_ESCAPE), new LookupTranslator(Collections.unmodifiableMap(ESCAPE_XML11_MAP)), NumericEscaper.between(1, 8), NumericEscaper.between(14, 31), NumericEscaper.between(127, 132), NumericEscaper.between(134, 159), new UnicodeUnpaired());
        ESCAPE_XSI = new LookupTranslator(Collections.unmodifiableMap(ESCAPE_XSI_MAP));
        UNESCAPE_JSON = UNESCAPE_JAVA;
        ESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(BASIC_ESCAPE), new LookupTranslator(ISO8859_1_ESCAPE));
        UNESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(BASIC_UNESCAPE), new LookupTranslator(ISO8859_1_UNESCAPE), new NumericUnescaper(new NumericUnescaper.OPTION[0]));
        ESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(BASIC_ESCAPE), new LookupTranslator(ISO8859_1_ESCAPE), new LookupTranslator(HTML40_EXTENDED_ESCAPE));
        UNESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(BASIC_UNESCAPE), new LookupTranslator(ISO8859_1_UNESCAPE), new LookupTranslator(HTML40_EXTENDED_UNESCAPE), new NumericUnescaper(new NumericUnescaper.OPTION[0]));
        UNESCAPE_ECMASCRIPT = UNESCAPE_JAVA;
        UNESCAPE_XML = new AggregateTranslator(new LookupTranslator(BASIC_UNESCAPE), new LookupTranslator(APOS_UNESCAPE), new NumericUnescaper(new NumericUnescaper.OPTION[0]));
    }

    static class XsiUnescaper
    extends CharSequenceTranslator {
        XsiUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("XSI Unescaper should never reach the [1] index");
            }
            String s = input.toString();
            int segmentStart = 0;
            int searchOffset = 0;
            while (true) {
                int pos;
                if ((pos = s.indexOf(92, searchOffset)) == -1) {
                    if (segmentStart >= s.length()) break;
                    out.write(s.substring(segmentStart));
                    break;
                }
                if (pos > segmentStart) {
                    out.write(s.substring(segmentStart, pos));
                }
                segmentStart = pos + 1;
                searchOffset = pos + 2;
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }
}

