/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.replacer;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.aoju.bus.core.lang.Chain;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.text.replacer.TextReplacer;

public class ReplacerChain
extends TextReplacer
implements Chain<TextReplacer, ReplacerChain> {
    private static final long serialVersionUID = 1L;
    private final List<TextReplacer> replacers = new LinkedList<TextReplacer>();

    public ReplacerChain(TextReplacer ... replacers) {
        for (TextReplacer replacer : replacers) {
            this.addChain(replacer);
        }
    }

    @Override
    public Iterator<TextReplacer> iterator() {
        return this.replacers.iterator();
    }

    @Override
    public ReplacerChain addChain(TextReplacer element) {
        this.replacers.add(element);
        return this;
    }

    @Override
    protected int replace(CharSequence text, int indexes, TextBuilder builder) {
        int consumed = 0;
        for (TextReplacer replacer : this.replacers) {
            consumed = replacer.replace(text, indexes, builder);
            if (0 == consumed) continue;
            return consumed;
        }
        return consumed;
    }
}

