/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BooleanKit {
    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    public static boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    public static boolean isFalse(Boolean value) {
        return Boolean.FALSE.equals(value);
    }

    public static boolean toBoolean(String text) {
        if (StringKit.isNotBlank(text)) {
            text = text.trim().toLowerCase();
            return ArrayKit.contains(Normal.TRUE_ARRAY, text);
        }
        return false;
    }

    public static Boolean toBooleanObject(String text) {
        if (StringKit.isNotBlank(text)) {
            if (ArrayKit.contains(Normal.TRUE_ARRAY, text = text.trim().toLowerCase())) {
                return true;
            }
            if (ArrayKit.contains(Normal.FALSE_ARRAY, text)) {
                return false;
            }
        }
        return null;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanKit.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanKit.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanKit.toInt(value);
    }

    public static Byte toByteObject(boolean value) {
        return BooleanKit.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Long toLongObject(boolean value) {
        return BooleanKit.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanKit.toInt(value);
    }

    public static Short toShortObject(boolean value) {
        return BooleanKit.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Float toFloatObject(boolean value) {
        return Float.valueOf(BooleanKit.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Double toDoubleObject(boolean value) {
        return BooleanKit.toDouble(value);
    }

    public static String toStringTrueFalse(boolean value) {
        return BooleanKit.toString(value, "true", "false");
    }

    public static String toStringOnOff(boolean value) {
        return BooleanKit.toString(value, "on", "off");
    }

    public static String toStringYesNo(boolean value) {
        return BooleanKit.toString(value, "yes", "no");
    }

    public static String toString(boolean value, String trueString, String falseString) {
        return value ? trueString : falseString;
    }

    public static boolean and(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (element) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanKit.and(primitive);
    }

    public static boolean or(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanKit.or(primitive);
    }

    public static boolean xor(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : array) {
            result ^= element;
        }
        return result;
    }

    public static Boolean xor(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanKit.xor(primitive);
    }

    public static Boolean negate(Boolean value) {
        if (null == value) {
            return null;
        }
        return value != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean negate(boolean value) {
        return !value;
    }

    public static int compare(boolean x, boolean y) {
        if (x == y) {
            return 0;
        }
        return x ? 1 : -1;
    }
}

