/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.aoju.bus.core.beans.NullWrapper;
import org.aoju.bus.core.beans.copier.BeanCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.compiler.JavaSourceCompiler;
import org.aoju.bus.core.convert.BasicType;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.instance.Instances;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.System;
import org.aoju.bus.core.lang.mutable.MutableObject;
import org.aoju.bus.core.loader.JarLoaders;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;
import org.aoju.bus.core.toolkit.UriKit;

public class ClassKit {
    public static final JavaCompiler SYSTEM_COMPILER = ToolProvider.getSystemJavaCompiler();
    private static final Map<String, Class<?>> PRIMITIVE_WRAPPER_MAP = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_MAP = new HashMap();
    private static final int ACCESS_TEST = 7;
    private static final Class<?>[] ORDERED_PRIMITIVE_TYPES = new Class[]{Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    public static <T> Class<T> getClass(T object) {
        return null == object ? null : object.getClass();
    }

    public static String getClassName(Object object, boolean isSimple) {
        if (null == object) {
            return null;
        }
        Class<?> clazz = object.getClass();
        return ClassKit.getClassName(clazz, isSimple);
    }

    public static String getClassName(Class<?> clazz, boolean isSimple) {
        if (null == clazz) {
            return null;
        }
        return isSimple ? clazz.getSimpleName() : clazz.getName();
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            classes[i] = object instanceof NullWrapper ? ((NullWrapper)object).getWrappedClass() : (null == object ? Object.class : object.getClass());
        }
        return classes;
    }

    public static boolean equals(Class<?> clazz, String className, boolean ignoreCase) {
        if (null == clazz || StringKit.isBlank(className)) {
            return false;
        }
        if (ignoreCase) {
            return className.equalsIgnoreCase(clazz.getName()) || className.equalsIgnoreCase(clazz.getSimpleName());
        }
        return className.equals(clazz.getName()) || className.equals(clazz.getSimpleName());
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = ClassKit.getPublicMethods(clazz)) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Predicate<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ClassKit.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.test(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollKit.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet<Method> excludeMethodSet = CollKit.newHashSet(excludeMethods);
        return ClassKit.getPublicMethods(clazz, (Method method) -> false == excludeMethodSet.contains(method));
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet<String> excludeMethodNameSet = CollKit.newHashSet(excludeMethodNames);
        return ClassKit.getPublicMethods(clazz, (Method method) -> false == excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        return ReflectKit.getMethodNames(clazz);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectKit.getMethods(clazz);
    }

    public static Method getDeclaredMethodOfObject(Object object, String methodName, Object ... args) throws SecurityException {
        return ClassKit.getDeclaredMethod(object.getClass(), methodName, ClassKit.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException {
        return ReflectKit.getMethod(clazz, methodName, parameterTypes);
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return clazz.getDeclaredFields();
    }

    public static String[] getJavaClassPaths() {
        return System.get("java.class.path").split(System.get("path.separator"));
    }

    public static String getUserHome() {
        return System.get("user.home");
    }

    public static String getTmpDir() {
        return System.get("java.io.tmpdir");
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayKit.isEmpty(types1) && ArrayKit.isEmpty(types2)) {
            return true;
        }
        if (types1.length != types2.length) {
            return false;
        }
        for (int i = 0; i < types1.length; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (!(ClassKit.isBasicType(type1) && ClassKit.isBasicType(type2) ? BasicType.unWrap(type1) != BasicType.unWrap(type2) : false == type1.isAssignableFrom(type2))) continue;
            return false;
        }
        return true;
    }

    public static <T> T invoke(String classNameWithMethodName, Object[] args) {
        return ClassKit.invoke(classNameWithMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object ... args) {
        if (StringKit.isBlank(classNameWithMethodName)) {
            throw new InternalException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new InternalException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return ClassKit.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return ClassKit.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object ... args) {
        Class<T> clazz = ClassKit.loadClass(className);
        try {
            Method method = ClassKit.getDeclaredMethod(clazz, methodName, ClassKit.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StringKit.format((CharSequence)"No such method: [{}]", methodName));
            }
            if (ClassKit.isStatic(method)) {
                return ReflectKit.invoke(null, method, args);
            }
            return ReflectKit.invoke(isSingleton ? Instances.singletion(clazz) : clazz.getConstructor(new Class[0]).newInstance(new Object[0]), method, args);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.WRAPPER_PRIMITIVE_MAP.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassKit.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassKit.isSimpleValueType(clazz) || clazz.isArray() && ClassKit.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassKit.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class) || TemporalAccessor.class.isAssignableFrom(clazz);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?> ... toClassArray) {
        return ClassKit.isAssignable(classArray, toClassArray, true);
    }

    public static boolean isAssignable(Class<?> classArray, Class<?> toClassArray) {
        return ClassKit.isAssignable(classArray, toClassArray, true);
    }

    public static boolean isAssignable(Class<?>[] classArray, Class<?>[] toClassArray, boolean autoboxing) {
        if (!ArrayKit.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (null == classArray) {
            classArray = Normal.EMPTY_CLASS_ARRAY;
        }
        if (null == toClassArray) {
            toClassArray = Normal.EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (ClassKit.isAssignable(classArray[i], toClassArray[i], autoboxing)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass, boolean autoboxing) {
        if (null == toClass) {
            return false;
        }
        if (null == cls) {
            return !toClass.isPrimitive();
        }
        if (autoboxing) {
            if (cls.isPrimitive() && !toClass.isPrimitive() && null == (cls = ClassKit.primitiveToWrapper(cls))) {
                return false;
            }
            if (toClass.isPrimitive() && !cls.isPrimitive() && null == (cls = ClassKit.wrapperToPrimitive(cls))) {
                return false;
            }
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        if (null == method) {
            throw new NullPointerException("Method to provided is null.");
        }
        return ClassKit.isPublic(method.getDeclaringClass());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassKit.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassKit.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && !method.canAccess(method)) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isSynthetic(Field field) {
        return field.isSynthetic();
    }

    public static boolean isSynthetic(Method method) {
        return method.isSynthetic();
    }

    public static boolean isSynthetic(Class<?> clazz) {
        return clazz.isSynthetic();
    }

    public static boolean isAbstract(Method method) {
        return BeanKit.hasModifier(method, BeanKit.ModifierType.ABSTRACT);
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassKit.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static boolean isEnum(Class<?> clazz) {
        return null != clazz && clazz.isEnum();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassKit.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type argumentType = TypeKit.getTypeArgument(clazz, index);
        if (null != argumentType && argumentType instanceof Class) {
            return (Class)argumentType;
        }
        return null;
    }

    public static String getPackage(Class<?> clazz) {
        if (null == clazz) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassKit.getPackage(clazz).replace('.', '/');
    }

    public static Object getDefaultValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ClassKit.getPrimitiveDefaultValue(clazz);
        }
        return null;
    }

    public static Object getPrimitiveDefaultValue(Class<?> clazz) {
        if (Long.TYPE == clazz) {
            return 0L;
        }
        if (Integer.TYPE == clazz) {
            return 0;
        }
        if (Short.TYPE == clazz) {
            return (short)0;
        }
        if (Character.TYPE == clazz) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE == clazz) {
            return (byte)0;
        }
        if (Double.TYPE == clazz) {
            return 0.0;
        }
        if (Float.TYPE == clazz) {
            return Float.valueOf(0.0f);
        }
        if (Boolean.TYPE == clazz) {
            return false;
        }
        return null;
    }

    public static Object[] getDefaultValues(Class<?> ... classes) {
        Object[] values = new Object[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            values[i] = ClassKit.getDefaultValue(classes[i]);
        }
        return values;
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader && null == (classLoader = ClassKit.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static String getClassPath() {
        return ClassKit.getClassPath(false);
    }

    public static String getClassPath(boolean isEncoded) {
        URL classPathURL = FileKit.getUrl("");
        String url = isEncoded ? classPathURL.getPath() : UriKit.getDecodedPath(classPathURL);
        return FileKit.normalize(url);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.create(valueProvider, bean, copyOptions).copy();
    }

    public static <T> Class<T> loadClass(String name) throws InternalException {
        return ClassKit.loadClass(name, true);
    }

    public static <T> Class<T> loadClass(String name, boolean isInitialized) throws InternalException {
        return ClassKit.loadClass(name, isInitialized, null);
    }

    public static Class<?> loadClass(String name, boolean isInitialized, ClassLoader classLoader) throws InternalException {
        Class<?> clazz;
        Assert.notNull(name, "Name must not be null", new Object[0]);
        name = name.replace("/", ".");
        if (null == classLoader) {
            classLoader = ClassKit.getClassLoader();
        }
        if ((clazz = ClassKit.loadPrimitiveClass(name)) == null) {
            clazz = ClassKit.doLoadClass(name, isInitialized, classLoader);
        }
        return clazz;
    }

    public static Class<?> loadPrimitiveClass(String name) {
        Class<?> result = null;
        if (StringKit.isNotBlank(name) && (name = name.trim()).length() <= 8) {
            result = PRIMITIVE_WRAPPER_MAP.get(name);
        }
        return result;
    }

    public static JarLoaders getJarClassLoader(File jarOrDir) {
        return JarLoaders.load(jarOrDir);
    }

    public static Class<?> loadClass(File jarOrDir, String name) {
        try {
            return ClassKit.getJarClassLoader(jarOrDir).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new InternalException(e);
        }
    }

    public static boolean isPresent(String className) {
        return ClassKit.isPresent(className, null);
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassKit.loadClass(className, false, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static String getPackageName(Class<?> clazz) {
        return ClassKit.getPackageName(clazz.getName());
    }

    public static String getPackageName(String className) {
        Assert.notNull(className, "Class name must not be null", new Object[0]);
        int lastDotIndex = className.lastIndexOf(46);
        return lastDotIndex != -1 ? className.substring(0, lastDotIndex) : "";
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull(name, "Name must not be null", new Object[0]);
        Class<?> clazz = ClassKit.resolvePrimitiveClassName(name);
        if (null != clazz) {
            return clazz;
        }
        if (name.endsWith("[]")) {
            String elementClassName = name.substring(0, name.length() - "[]".length());
            Class<?> elementClass = ClassKit.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[L") && name.endsWith(";")) {
            String elementName = name.substring("[L".length(), name.length() - 1);
            Class<?> elementClass = ClassKit.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith("[")) {
            String elementName = name.substring("[".length());
            Class<?> elementClass = ClassKit.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader clToUse = classLoader;
        if (null == clToUse) {
            clToUse = ClassKit.getDefaultClassLoader();
        }
        try {
            return Class.forName(name, false, clToUse);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + "$" + name.substring(lastDotIndex + 1);
                try {
                    return Class.forName(innerClassName, false, clToUse);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    private static Class<?> forName(String name, boolean initialize, ClassLoader loader) {
        try {
            return Class.forName(name, initialize, loader);
        }
        catch (ClassNotFoundException ex2) {
            return null;
        }
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (null != name && name.length() <= 8) {
            result = PRIMITIVE_WRAPPER_MAP.get(name);
        }
        return result;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (null == cl && null == (cl = ClassKit.class.getClassLoader())) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static Class<?> resolveClassName(String className, ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassKit.forName(className, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot find class [" + className + "]", ex);
        }
        catch (LinkageError ex) {
            throw new IllegalArgumentException("Error loading class [" + className + "]: problem with class file or dependent class.", ex);
        }
    }

    public static String getShortClassName(Object object, String valueIfNull) {
        if (null == object) {
            return valueIfNull;
        }
        return ClassKit.getShortClassName(object.getClass());
    }

    public static String getShortClassName(Class<?> cls) {
        if (null == cls) {
            return "";
        }
        return ClassKit.getShortClassName(cls.getName());
    }

    public static String getShortClassName(String className) {
        List<String> packages = StringKit.split((CharSequence)className, '.');
        if (null == packages || packages.size() < 2) {
            return className;
        }
        int size = packages.size();
        StringBuilder result = StringKit.builder();
        result.append(packages.get(0).charAt(0));
        for (int i = 1; i < size - 1; ++i) {
            result.append('.').append(packages.get(i).charAt(0));
        }
        result.append('.').append(packages.get(size - 1));
        return result.toString();
    }

    public static String getSimpleName(Class<?> cls) {
        return ClassKit.getSimpleName(cls, "");
    }

    public static String getSimpleName(Class<?> cls, String valueIfNull) {
        return null == cls ? valueIfNull : cls.getSimpleName();
    }

    public static String getSimpleName(Object object) {
        return ClassKit.getSimpleName(object, "");
    }

    public static String getSimpleName(Object object, String valueIfNull) {
        return null == object ? valueIfNull : object.getClass().getSimpleName();
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (null != cls && cls.isPrimitive()) {
            convertedClass = PRIMITIVE_WRAPPER_MAP.get(cls);
        }
        return convertedClass;
    }

    public static Class<?>[] primitivesToWrappers(Class<?> ... classes) {
        if (null == classes) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassKit.primitiveToWrapper(classes[i]);
        }
        return convertedClasses;
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return WRAPPER_PRIMITIVE_MAP.get(cls);
    }

    public static Class<?>[] wrappersToPrimitives(Class<?> ... classes) {
        if (null == classes) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = ClassKit.wrapperToPrimitive(classes[i]);
        }
        return convertedClasses;
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (null == cls) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        ClassKit.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    public static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (null != cls) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ClassKit.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        if (null == cls) {
            return null;
        }
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); null != superclass; superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static Class<?>[] toClass(Object ... array) {
        if (null == array) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[array.length];
        for (int i = 0; i < array.length; ++i) {
            classes[i] = null == array[i] ? null : array[i].getClass();
        }
        return classes;
    }

    public static Iterable<Class<?>> hierarchy(Class<?> type) {
        return ClassKit.hierarchy(type, Interfaces.EXCLUDE);
    }

    public static Iterable<Class<?>> hierarchy(Class<?> type, Interfaces interfacesBehavior) {
        Iterable<Class<?>> classes = () -> {
            final MutableObject<Class> next = new MutableObject<Class>(type);
            return new Iterator<Class<?>>(){

                @Override
                public boolean hasNext() {
                    return null != next.get();
                }

                @Override
                public Class<?> next() {
                    Class result = (Class)next.get();
                    next.set(result.getSuperclass());
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
        if (interfacesBehavior != Interfaces.INCLUDE) {
            return classes;
        }
        return () -> {
            final HashSet seenInterfaces = new HashSet();
            final Iterator wrapped = classes.iterator();
            return new Iterator<Class<?>>(){
                Iterator<Class<?>> interfaces = Collections.emptyIterator();

                @Override
                public boolean hasNext() {
                    return this.interfaces.hasNext() || wrapped.hasNext();
                }

                @Override
                public Class<?> next() {
                    if (this.interfaces.hasNext()) {
                        Class<?> nextInterface = this.interfaces.next();
                        seenInterfaces.add(nextInterface);
                        return nextInterface;
                    }
                    Class nextSuperclass = (Class)wrapped.next();
                    LinkedHashSet currentInterfaces = new LinkedHashSet();
                    this.walkInterfaces(currentInterfaces, nextSuperclass);
                    this.interfaces = currentInterfaces.iterator();
                    return nextSuperclass;
                }

                private void walkInterfaces(Set<Class<?>> addTo, Class<?> c) {
                    for (Class<?> iface : c.getInterfaces()) {
                        if (!seenInterfaces.contains(iface)) {
                            addTo.add(iface);
                        }
                        this.walkInterfaces(addTo, iface);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        };
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (null == type) {
            return false;
        }
        return type.isPrimitive() || ClassKit.isPrimitiveWrapper(type);
    }

    public static boolean isUserLevelMethod(Method method) {
        Assert.notNull(method, "Method must not be null", new Object[0]);
        return method.isBridge() || !method.isSynthetic() && !ClassKit.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull(className, "Class name must not be null", new Object[0]);
        return className.replace('.', '/');
    }

    public static String getClassVar(String className) {
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public static List<Field> getAllFieldList(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class tempClass = clazz; null != tempClass; tempClass = tempClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tempClass.getDeclaredFields()));
        }
        for (Field field : fieldList) {
            field.setAccessible(true);
        }
        return fieldList;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Method> getAllFieldsReadMethods(Class clazz) throws IntrospectionException {
        List<Field> fieldList = ClassKit.getAllFieldList(clazz);
        if (CollKit.isEmpty(fieldList)) {
            return Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Field field : fieldList) {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
            Method getMethod = pd.getReadMethod();
            methods.add(getMethod);
        }
        return methods;
    }

    public static Object invokeMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassKit.invokeMethod(object, methodName, Normal.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassKit.invokeMethod(object, forceAccess, methodName, Normal.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassKit.toClass(args);
        return ClassKit.invokeMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassKit.toClass(args);
        return ClassKit.invokeMethod(object, forceAccess, methodName, args, parameterTypes);
    }

    public static Object invokeMethod(Object object, boolean forceAccess, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        String messagePrefix;
        parameterTypes = ArrayKit.nullToEmpty(parameterTypes);
        args = ArrayKit.nullToEmpty(args);
        if (forceAccess) {
            messagePrefix = "No such method: ";
            method = ClassKit.getMatchingMethod(object.getClass(), methodName, parameterTypes);
            if (null != method && !method.canAccess(method)) {
                method.setAccessible(true);
            }
        } else {
            messagePrefix = "No such accessible method: ";
            method = ClassKit.getMatchingAccessibleMethod(object.getClass(), methodName, parameterTypes);
        }
        if (null == method) {
            throw new NoSuchMethodException(messagePrefix + methodName + "() on object: " + object.getClass().getName());
        }
        args = ClassKit.toVarArgs(method, args);
        return method.invoke(object, args);
    }

    public static Object invokeMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassKit.invokeMethod(object, false, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ClassKit.invokeExactMethod(object, methodName, Normal.EMPTY_OBJECT_ARRAY, null);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassKit.toClass(args);
        return ClassKit.invokeExactMethod(object, methodName, args, parameterTypes);
    }

    public static Object invokeExactMethod(Object object, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        parameterTypes = ArrayKit.nullToEmpty(parameterTypes);
        Method method = ClassKit.getAccessibleMethod(object.getClass(), methodName, parameterTypes);
        if (null == method) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        return method.invoke(object, args);
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Method method = ClassKit.getAccessibleMethod(cls, methodName, parameterTypes = ArrayKit.nullToEmpty(parameterTypes));
        if (null == method) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        return method.invoke(null, args);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassKit.toClass(args);
        return ClassKit.invokeStaticMethod(cls, methodName, args, parameterTypes);
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Object[] args, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Method method = ClassKit.getMatchingAccessibleMethod(cls, methodName, parameterTypes = ArrayKit.nullToEmpty(parameterTypes));
        if (null == method) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on class: " + cls.getName());
        }
        args = ClassKit.toVarArgs(method, args);
        return method.invoke(null, args);
    }

    private static Object[] toVarArgs(Method method, Object[] args) {
        if (method.isVarArgs()) {
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            args = ClassKit.getVarArgs(args, methodParameterTypes);
        }
        return args;
    }

    static Object[] getVarArgs(Object[] args, Class<?>[] methodParameterTypes) {
        if (args.length == methodParameterTypes.length && args[args.length - 1].getClass().equals(methodParameterTypes[methodParameterTypes.length - 1])) {
            return args;
        }
        Object[] newArgs = new Object[methodParameterTypes.length];
        java.lang.System.arraycopy(args, 0, newArgs, 0, methodParameterTypes.length - 1);
        Class<?> varArgComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
        int varArgLength = args.length - methodParameterTypes.length + 1;
        Object varArgsArray = Array.newInstance(ClassKit.primitiveToWrapper(varArgComponentType), varArgLength);
        java.lang.System.arraycopy(args, methodParameterTypes.length - 1, varArgsArray, 0, varArgLength);
        if (varArgComponentType.isPrimitive()) {
            varArgsArray = ArrayKit.toPrimitive(varArgsArray);
        }
        newArgs[methodParameterTypes.length - 1] = varArgsArray;
        return newArgs;
    }

    public static Object invokeExactStaticMethod(Class<?> cls, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        args = ArrayKit.nullToEmpty(args);
        Class<?>[] parameterTypes = ClassKit.toClass(args);
        return ClassKit.invokeExactStaticMethod(cls, methodName, args, parameterTypes);
    }

    public static Method getAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            return ClassKit.getAccessibleMethod(cls.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getAccessibleMethod(Method method) {
        Class<?>[] parameterTypes;
        if (!ClassKit.isAccessible(method)) {
            return null;
        }
        Class<?> cls = method.getDeclaringClass();
        if (Modifier.isPublic(cls.getModifiers())) {
            return method;
        }
        String methodName = method.getName();
        if (null == (method = ClassKit.getAccessibleMethodFromInterfaceNest(cls, methodName, parameterTypes = method.getParameterTypes()))) {
            method = ClassKit.getAccessibleMethodFromSuperclass(cls, methodName, parameterTypes);
        }
        return method;
    }

    private static Method getAccessibleMethodFromSuperclass(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        for (Class<?> parentClass = cls.getSuperclass(); null != parentClass; parentClass = parentClass.getSuperclass()) {
            if (!Modifier.isPublic(parentClass.getModifiers())) continue;
            try {
                return parentClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Method getAccessibleMethodFromInterfaceNest(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        while (null != cls) {
            Class<?>[] interfaces;
            for (Class<?> anInterface : interfaces = cls.getInterfaces()) {
                if (!Modifier.isPublic(anInterface.getModifiers())) continue;
                try {
                    return anInterface.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = ClassKit.getAccessibleMethodFromInterfaceNest(anInterface, methodName, parameterTypes);
                    if (null == method) continue;
                    return method;
                }
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static Method getMatchingAccessibleMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = cls.getMethod(methodName, parameterTypes);
            ClassKit.setAccessibleWorkaround(method);
            return method;
        }
        catch (NoSuchMethodException method) {
            Method[] methods;
            Method bestMatch = null;
            for (Method method2 : methods = cls.getMethods()) {
                Method accessibleMethod;
                if (!method2.getName().equals(methodName) || !ClassKit.isMatchingMethod(method2, parameterTypes) || null == (accessibleMethod = ClassKit.getAccessibleMethod(method2)) || null != bestMatch && ClassKit.compareMethodFit(accessibleMethod, bestMatch, parameterTypes) >= 0) continue;
                bestMatch = accessibleMethod;
            }
            if (null != bestMatch) {
                ClassKit.setAccessibleWorkaround(bestMatch);
            }
            if (null != bestMatch && bestMatch.isVarArgs() && bestMatch.getParameterTypes().length > 0 && parameterTypes.length > 0) {
                Class<?>[] methodParameterTypes = bestMatch.getParameterTypes();
                Class<?> methodParameterComponentType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
                String methodParameterComponentTypeName = ClassKit.primitiveToWrapper(methodParameterComponentType).getName();
                String parameterTypeName = parameterTypes[parameterTypes.length - 1].getName();
                String parameterTypeSuperClassName = parameterTypes[parameterTypes.length - 1].getSuperclass().getName();
                if (!methodParameterComponentTypeName.equals(parameterTypeName) && !methodParameterComponentTypeName.equals(parameterTypeSuperClassName)) {
                    return null;
                }
            }
            return bestMatch;
        }
    }

    public static Method getMatchingMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull(cls, "Null class not allowed.", new Object[0]);
        Assert.notEmpty(methodName, "Null or blank methodName not allowed.", new Object[0]);
        Method[] methodArray = cls.getDeclaredMethods();
        List<Class<?>> superclassList = ClassKit.getAllSuperclasses(cls);
        for (Class<?> klass : superclassList) {
            methodArray = ArrayKit.addAll(methodArray, klass.getDeclaredMethods());
        }
        Method inexactMatch = null;
        for (Method method : methodArray) {
            if (methodName.equals(method.getName()) && Objects.deepEquals(parameterTypes, method.getParameterTypes())) {
                return method;
            }
            if (!methodName.equals(method.getName()) || !ClassKit.isAssignable(parameterTypes, method.getParameterTypes(), true)) continue;
            if (null == inexactMatch) {
                inexactMatch = method;
                continue;
            }
            if (ClassKit.distance(parameterTypes, method.getParameterTypes()) >= ClassKit.distance(parameterTypes, inexactMatch.getParameterTypes())) continue;
            inexactMatch = method;
        }
        return inexactMatch;
    }

    private static int distance(Class<?>[] classArray, Class<?>[] toClassArray) {
        int answer = 0;
        if (!ClassKit.isAssignable(classArray, toClassArray, true)) {
            return -1;
        }
        for (int offset = 0; offset < classArray.length; ++offset) {
            if (classArray[offset].equals(toClassArray[offset])) continue;
            if (ClassKit.isAssignable(classArray[offset], toClassArray[offset], true) && !ClassKit.isAssignable(classArray[offset], toClassArray[offset], false)) {
                ++answer;
                continue;
            }
            answer += 2;
        }
        return answer;
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return ClassKit.getMethodsWithAnnotation(cls, annotationCls, false, false);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        return ClassKit.getMethodsListWithAnnotation(cls, annotationCls, false, false);
    }

    public static Method[] getMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        List<Method> annotatedMethodsList = ClassKit.getMethodsListWithAnnotation(cls, annotationCls, searchSupers, ignoreAccess);
        return annotatedMethodsList.toArray(new Method[annotatedMethodsList.size()]);
    }

    public static List<Method> getMethodsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Assert.isTrue(null != cls, "The class must not be null", new Object[0]);
        Assert.isTrue(null != annotationCls, "The annotation class must not be null", new Object[0]);
        ArrayList classes = searchSupers ? ClassKit.getAllSuperclassesAndInterfaces(cls) : new ArrayList();
        classes.add(0, cls);
        ArrayList<Method> annotatedMethods = new ArrayList<Method>();
        for (Class clazz : classes) {
            Method[] methods;
            for (Method method : methods = ignoreAccess ? clazz.getDeclaredMethods() : clazz.getMethods()) {
                if (null == method.getAnnotation(annotationCls)) continue;
                annotatedMethods.add(method);
            }
        }
        return annotatedMethods;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationCls, boolean searchSupers, boolean ignoreAccess) {
        Assert.isTrue(null != method, "The method must not be null", new Object[0]);
        Assert.isTrue(null != annotationCls, "The annotation class must not be null", new Object[0]);
        if (!ignoreAccess && !ClassKit.isAccessible(method)) {
            return null;
        }
        A annotation = method.getAnnotation(annotationCls);
        if (null == annotation && searchSupers) {
            Class<?> mcls = method.getDeclaringClass();
            List<Class<?>> classes = ClassKit.getAllSuperclassesAndInterfaces(mcls);
            for (Class<?> acls : classes) {
                Method equivalentMethod;
                try {
                    equivalentMethod = ignoreAccess ? acls.getDeclaredMethod(method.getName(), method.getParameterTypes()) : acls.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                annotation = equivalentMethod.getAnnotation(annotationCls);
                if (null == annotation) continue;
                break;
            }
        }
        return annotation;
    }

    private static List<Class<?>> getAllSuperclassesAndInterfaces(Class<?> cls) {
        if (null == cls) {
            return null;
        }
        ArrayList allSuperClassesAndInterfaces = new ArrayList();
        List<Class<?>> allSuperclasses = ClassKit.getAllSuperclasses(cls);
        int superClassIndex = 0;
        List<Class<?>> allInterfaces = ClassKit.getAllInterfaces(cls);
        int interfaceIndex = 0;
        while (interfaceIndex < allInterfaces.size() || superClassIndex < allSuperclasses.size()) {
            Class<?> acls = interfaceIndex >= allInterfaces.size() ? allSuperclasses.get(superClassIndex++) : (superClassIndex >= allSuperclasses.size() ? allInterfaces.get(interfaceIndex++) : (interfaceIndex < superClassIndex ? allInterfaces.get(interfaceIndex++) : (superClassIndex < interfaceIndex ? allSuperclasses.get(superClassIndex++) : allInterfaces.get(interfaceIndex++))));
            allSuperClassesAndInterfaces.add(acls);
        }
        return allSuperClassesAndInterfaces;
    }

    public static Field getField(Class<?> cls, String fieldName) {
        Field field = ClassKit.getField(cls, fieldName, false);
        ClassKit.setAccessibleWorkaround(field);
        return field;
    }

    public static Field getField(Class<?> cls, String fieldName, boolean forceAccess) {
        Assert.isTrue(null != cls, "The class must not be null", new Object[0]);
        Assert.isTrue(StringKit.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        for (Class<?> acls = cls; null != acls; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (!forceAccess) continue;
                    field.setAccessible(true);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        Field match = null;
        for (Class<?> class1 : ClassKit.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName);
                Assert.isTrue(null == match, "Reference to field %s is ambiguous relative to %s; a matching field exists on two or more implemented interfaces.", fieldName, cls);
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName) {
        if (null == clazz || StringKit.isBlank(fieldName)) {
            return null;
        }
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String fieldName, boolean forceAccess) {
        Assert.isTrue(null != clazz, "The class must not be null", new Object[0]);
        Assert.isTrue(StringKit.isNotBlank(fieldName), "The field name must not be blank/empty", new Object[0]);
        try {
            Field field = clazz.getDeclaredField(fieldName);
            if (!ClassKit.isAccessible(field)) {
                if (forceAccess) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Field[] getAllFields(Class<?> cls) {
        List<Field> allFieldsList = ClassKit.getAllFieldsList(cls);
        return allFieldsList.toArray(new Field[allFieldsList.size()]);
    }

    public static List<Field> getAllFieldsList(Class<?> cls) {
        Assert.isTrue(null != cls, "The class must not be null", new Object[0]);
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; null != currentClass; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static Field[] getFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        List<Field> annotatedFieldsList = ClassKit.getFieldsListWithAnnotation(cls, annotationCls);
        return annotatedFieldsList.toArray(new Field[annotatedFieldsList.size()]);
    }

    public static List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        Assert.isTrue(null != annotationCls, "The annotation class must not be null", new Object[0]);
        List<Field> allFields = ClassKit.getAllFieldsList(cls);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (null == field.getAnnotation(annotationCls)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static Object readStaticField(Field field) throws IllegalAccessException {
        return ClassKit.readStaticField(field, false);
    }

    public static Object readStaticField(Field field, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != field, "The field must not be null", new Object[0]);
        Assert.isTrue(Modifier.isStatic(field.getModifiers()), "The field '%s' is not static", field.getName());
        return ClassKit.readField(field, null, forceAccess);
    }

    public static Object readStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        return ClassKit.readStaticField(cls, fieldName, false);
    }

    public static Object readStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field = ClassKit.getField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate field '%s' on %s", fieldName, cls);
        return ClassKit.readStaticField(field, false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName) throws IllegalAccessException {
        return ClassKit.readDeclaredStaticField(cls, fieldName, false);
    }

    public static Object readDeclaredStaticField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Field field = ClassKit.getDeclaredField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        return ClassKit.readStaticField(field, false);
    }

    public static Object readField(Field field, Object target) throws IllegalAccessException {
        return ClassKit.readField(field, target, false);
    }

    public static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != field, "The field must not be null", new Object[0]);
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            ClassKit.setAccessibleWorkaround(field);
        }
        return field.get(target);
    }

    public static Object readField(Object target, String fieldName) throws IllegalAccessException {
        return ClassKit.readField(target, fieldName, false);
    }

    public static Object readField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != target, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = ClassKit.getField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate field %s on %s", fieldName, cls);
        return ClassKit.readField(field, target, false);
    }

    public static Object readDeclaredField(Object target, String fieldName) throws IllegalAccessException {
        return ClassKit.readDeclaredField(target, fieldName, false);
    }

    public static Object readDeclaredField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != target, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = ClassKit.getDeclaredField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate declared field %s.%s", cls, fieldName);
        return ClassKit.readField(field, target, false);
    }

    public static void writeStaticField(Field field, Object value) throws IllegalAccessException {
        ClassKit.writeStaticField(field, value, false);
    }

    public static void writeStaticField(Field field, Object value, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != field, "The field must not be null", new Object[0]);
        Assert.isTrue(Modifier.isStatic(field.getModifiers()), "The field %s.%s is not static", field.getDeclaringClass().getName(), field.getName());
        ClassKit.writeField(field, null, value, forceAccess);
    }

    public static void writeStaticField(Class<?> cls, String fieldName, Object value) throws IllegalAccessException {
        ClassKit.writeStaticField(cls, fieldName, value, false);
    }

    public static void writeStaticField(Class<?> cls, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Field field = ClassKit.getField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate field %s on %s", fieldName, cls);
        ClassKit.writeStaticField(field, value, false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value) throws IllegalAccessException {
        ClassKit.writeDeclaredStaticField(cls, fieldName, value, false);
    }

    public static void writeDeclaredStaticField(Class<?> cls, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Field field = ClassKit.getDeclaredField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        ClassKit.writeField(field, null, value, false);
    }

    public static void writeField(Field field, Object target, Object value) throws IllegalAccessException {
        ClassKit.writeField(field, target, value, false);
    }

    public static void writeField(Field field, Object target, Object value, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != field, "The field must not be null", new Object[0]);
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            ClassKit.setAccessibleWorkaround(field);
        }
        field.set(target, value);
    }

    public static void removeFinalModifier(Field field) {
        ClassKit.removeFinalModifier(field, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFinalModifier(Field field, boolean forceAccess) {
        block7: {
            Assert.isTrue(null != field, "The field must not be null", new Object[0]);
            try {
                boolean doForceAccess;
                if (!Modifier.isFinal(field.getModifiers())) break block7;
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                boolean bl = doForceAccess = forceAccess && !modifiersField.isAccessible();
                if (doForceAccess) {
                    modifiersField.setAccessible(true);
                }
                try {
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                finally {
                    if (doForceAccess) {
                        modifiersField.setAccessible(false);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static void writeField(Object target, String fieldName, Object value) throws IllegalAccessException {
        ClassKit.writeField(target, fieldName, value, false);
    }

    public static void writeField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != target, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = ClassKit.getField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        ClassKit.writeField(field, target, value, false);
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value) throws IllegalAccessException {
        ClassKit.writeDeclaredField(target, fieldName, value, false);
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Assert.isTrue(null != target, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = ClassKit.getDeclaredField(cls, fieldName, forceAccess);
        Assert.isTrue(null != field, "Cannot locate declared field %s.%s", cls.getName(), fieldName);
        ClassKit.writeField(field, target, value, false);
    }

    public static Class<?> getUserClass(Object instance) {
        return ClassKit.getUserClass(instance.getClass());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains("$$") && null != (superclass = clazz.getSuperclass()) && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    public static boolean isNumberOrStringType(Class<?> type) {
        if (type == String.class) {
            return true;
        }
        if (type.getGenericSuperclass() == Number.class) {
            return true;
        }
        return type.isPrimitive();
    }

    public static boolean setAccessibleWorkaround(AccessibleObject accessibleObject) {
        if (null == accessibleObject || accessibleObject.isAccessible()) {
            return false;
        }
        Member m = (Member)((Object)accessibleObject);
        if (!accessibleObject.isAccessible() && Modifier.isPublic(m.getModifiers()) && ClassKit.isPackageAccess(m.getDeclaringClass().getModifiers())) {
            try {
                accessibleObject.setAccessible(true);
                return true;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isPackageAccess(int modifiers) {
        return (modifiers & 7) == 0;
    }

    public static boolean isAccessible(Member member) {
        return null != member && Modifier.isPublic(member.getModifiers()) && !member.isSynthetic();
    }

    public static int compareConstructorFit(Constructor<?> left, Constructor<?> right, Class<?>[] actual) {
        return ClassKit.compareParameterTypes(Executable.of(left), Executable.of(right), actual);
    }

    public static int compareMethodFit(Method left, Method right, Class<?>[] actual) {
        return ClassKit.compareParameterTypes(Executable.of(left), Executable.of(right), actual);
    }

    public static int compareParameterTypes(Executable left, Executable right, Class<?>[] actual) {
        float rightCost;
        float leftCost = ClassKit.getTotalTransformationCost(actual, left);
        return leftCost < (rightCost = ClassKit.getTotalTransformationCost(actual, right)) ? -1 : (rightCost < leftCost ? 1 : 0);
    }

    public static float getTotalTransformationCost(Class<?>[] srcArgs, Executable executable) {
        long normalArgsLen;
        Class<?>[] destArgs = executable.getParameterTypes();
        boolean isVarArgs = executable.isVarArgs();
        float totalCost = 0.0f;
        long l = normalArgsLen = isVarArgs ? (long)(destArgs.length - 1) : (long)destArgs.length;
        if ((long)srcArgs.length < normalArgsLen) {
            return Float.MAX_VALUE;
        }
        int i = 0;
        while ((long)i < normalArgsLen) {
            totalCost += ClassKit.getObjectTransformationCost(srcArgs[i], destArgs[i]);
            ++i;
        }
        if (isVarArgs) {
            boolean noVarArgsPassed = srcArgs.length < destArgs.length;
            boolean explicitArrayForVarags = srcArgs.length == destArgs.length && srcArgs[srcArgs.length - 1].isArray();
            float varArgsCost = 0.001f;
            Class<?> destClass = destArgs[destArgs.length - 1].getComponentType();
            if (noVarArgsPassed) {
                totalCost += ClassKit.getObjectTransformationCost(destClass, Object.class) + 0.001f;
            } else if (explicitArrayForVarags) {
                Class<?> sourceClass = srcArgs[srcArgs.length - 1].getComponentType();
                totalCost += ClassKit.getObjectTransformationCost(sourceClass, destClass) + 0.001f;
            } else {
                for (int i2 = destArgs.length - 1; i2 < srcArgs.length; ++i2) {
                    Class<?> srcClass = srcArgs[i2];
                    totalCost += ClassKit.getObjectTransformationCost(srcClass, destClass) + 0.001f;
                }
            }
        }
        return totalCost;
    }

    public static float getObjectTransformationCost(Class<?> srcClass, Class<?> destClass) {
        if (destClass.isPrimitive()) {
            return ClassKit.getPrimitivePromotionCost(srcClass, destClass);
        }
        float cost = 0.0f;
        while (null != srcClass && !destClass.equals(srcClass)) {
            if (destClass.isInterface() && ClassKit.isAssignable(srcClass, destClass)) {
                cost += 0.25f;
                break;
            }
            cost += 1.0f;
            srcClass = srcClass.getSuperclass();
        }
        if (null == srcClass) {
            cost += 1.5f;
        }
        return cost;
    }

    public static float getPrimitivePromotionCost(Class<?> srcClass, Class<?> destClass) {
        float cost = 0.0f;
        Class<?> cls = srcClass;
        if (!cls.isPrimitive()) {
            cost += 0.1f;
            cls = ClassKit.wrapperToPrimitive(cls);
        }
        for (int i = 0; cls != destClass && i < ORDERED_PRIMITIVE_TYPES.length; ++i) {
            if (cls != ORDERED_PRIMITIVE_TYPES[i]) continue;
            cost += 0.1f;
            if (i >= ORDERED_PRIMITIVE_TYPES.length - 1) continue;
            cls = ORDERED_PRIMITIVE_TYPES[i + 1];
        }
        return cost;
    }

    public static boolean isMatchingMethod(Method method, Class<?>[] parameterTypes) {
        return ClassKit.isMatchingExecutable(Executable.of(method), parameterTypes);
    }

    public static boolean isMatchingConstructor(Constructor<?> method, Class<?>[] parameterTypes) {
        return ClassKit.isMatchingExecutable(Executable.of(method), parameterTypes);
    }

    public static boolean isMatchingExecutable(Executable method, Class<?>[] parameterTypes) {
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        if (ClassKit.isAssignable(parameterTypes, methodParameterTypes, true)) {
            return true;
        }
        if (method.isVarArgs()) {
            int i;
            for (i = 0; i < methodParameterTypes.length - 1 && i < parameterTypes.length; ++i) {
                if (ClassKit.isAssignable(parameterTypes[i], methodParameterTypes[i], true)) continue;
                return false;
            }
            Class<?> varArgParameterType = methodParameterTypes[methodParameterTypes.length - 1].getComponentType();
            while (i < parameterTypes.length) {
                if (!ClassKit.isAssignable(parameterTypes[i], varArgParameterType, true)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isCglibProxy(Object object) {
        return ClassKit.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return null != clazz && ClassKit.isCglibProxyClassName(clazz.getName());
    }

    public static boolean isCglibProxyClassName(String className) {
        return null != className && className.contains("$$");
    }

    public static Class<?> getCglibActualClass(Class<?> clazz) {
        Class<?> actualClass = clazz;
        while (ClassKit.isCglibProxyClass(actualClass)) {
            actualClass = actualClass.getSuperclass();
        }
        return actualClass;
    }

    public static <T> T loadFirstAvailable(Class<T> clazz) {
        Iterator<T> iterator = ClassKit.load(clazz).iterator();
        while (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        return null;
    }

    public static <T> T loadFirst(Class<T> clazz) {
        Iterator<T> iterator = ClassKit.load(clazz).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz) {
        return ClassKit.load(clazz, null);
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz, ClassLoader loader) {
        return ServiceLoader.load(clazz, ObjectKit.defaultIfNull(loader, ClassKit::getClassLoader));
    }

    public static <T> List<T> loadList(Class<T> clazz) {
        return ClassKit.loadList(clazz, null);
    }

    public static <T> List<T> loadList(Class<T> clazz, ClassLoader loader) {
        return CollKit.list(false, ClassKit.load(clazz, loader));
    }

    public static Manifest getManifest(Class<?> cls) {
        URLConnection connection;
        URL url = FileKit.getUrl(null, cls);
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (connection instanceof JarURLConnection) {
            JarURLConnection conn = (JarURLConnection)connection;
            return ClassKit.getManifest(conn);
        }
        return null;
    }

    public static Manifest getManifest(File classpathItem) throws InternalException {
        Manifest manifest;
        block18: {
            manifest = null;
            if (classpathItem.isFile()) {
                try (JarFile jarFile = new JarFile(classpathItem);){
                    manifest = ClassKit.getManifest(jarFile);
                    break block18;
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
            File metaDir = new File(classpathItem, "META-INF");
            File manifestFile = null;
            String[] MANIFEST_NAMES = new String[]{"Manifest.mf", "manifest.mf", "MANIFEST.MF"};
            if (metaDir.isDirectory()) {
                for (String name : MANIFEST_NAMES) {
                    File mFile = new File(metaDir, name);
                    if (!mFile.isFile()) continue;
                    manifestFile = mFile;
                    break;
                }
            }
            if (null != manifestFile) {
                try (FileInputStream fis = new FileInputStream(manifestFile);){
                    manifest = new Manifest(fis);
                }
                catch (IOException e) {
                    throw new InternalException(e);
                }
            }
        }
        return manifest;
    }

    public static Manifest getManifest(JarURLConnection connection) throws InternalException {
        JarFile jarFile;
        try {
            jarFile = connection.getJarFile();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return ClassKit.getManifest(jarFile);
    }

    public static Manifest getManifest(JarFile jarFile) throws InternalException {
        try {
            return jarFile.getManifest();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean compile(String ... sourceFiles) {
        return 0 == SYSTEM_COMPILER.run(null, null, null, sourceFiles);
    }

    public static StandardJavaFileManager getFileManager() {
        return ClassKit.getFileManager(null);
    }

    public static StandardJavaFileManager getFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener) {
        return SYSTEM_COMPILER.getStandardFileManager(diagnosticListener, null, null);
    }

    public static JavaCompiler.CompilationTask getTask(JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<? extends JavaFileObject> compilationUnits) {
        return SYSTEM_COMPILER.getTask(null, fileManager, diagnosticListener, options, null, compilationUnits);
    }

    public static JavaSourceCompiler getCompiler(ClassLoader parent) {
        return JavaSourceCompiler.create(parent);
    }

    private static Class<?> doLoadClass(String name, boolean isInitialized, ClassLoader classLoader) {
        Class<?> clazz;
        block8: {
            if ((name = StringKit.trim(name, 1, c -> '.' == c.charValue())).endsWith("[]")) {
                String elementClassName = name.substring(0, name.length() - "[]".length());
                Class<?> elementClass = ClassKit.loadClass(elementClassName, isInitialized, classLoader);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith("[L") && name.endsWith(";")) {
                String elementName = name.substring("[L".length(), name.length() - 1);
                Class<?> elementClass = ClassKit.loadClass(elementName, isInitialized, classLoader);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else if (name.startsWith("[")) {
                String elementName = name.substring("[".length());
                Class<?> elementClass = ClassKit.loadClass(elementName, isInitialized, classLoader);
                clazz = Array.newInstance(elementClass, 0).getClass();
            } else {
                try {
                    clazz = Class.forName(name, isInitialized, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    clazz = ClassKit.tryLoadInnerClass(name, isInitialized, classLoader);
                    if (null != clazz) break block8;
                    throw new InternalException(ex);
                }
            }
        }
        return clazz;
    }

    private static Class<?> tryLoadInnerClass(String name, boolean isInitialized, ClassLoader classLoader) {
        int lastDotIndex = ((String)name).lastIndexOf(46);
        Class<?> clazz = null;
        while (lastDotIndex > 0 && Character.isUpperCase(((String)name).charAt(lastDotIndex + 1)) && null == (clazz = ClassKit.forName((String)(name = ((String)name).substring(0, lastDotIndex) + "$" + ((String)name).substring(lastDotIndex + 1)), isInitialized, classLoader))) {
            lastDotIndex = ((String)name).lastIndexOf(46);
        }
        return clazz;
    }

    public static URL getLocation(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        return clazz.getProtectionDomain().getCodeSource().getLocation();
    }

    public static String getLocationPath(Class<?> clazz) {
        URL location = ClassKit.getLocation(clazz);
        if (null == location) {
            return null;
        }
        return location.getPath();
    }

    public static boolean isAbstractOrInterface(Class<?> clazz) {
        return ClassKit.isAbstract(clazz) || ClassKit.isInterface(clazz);
    }

    public static boolean isJdkClass(Class<?> clazz) {
        Package objectPackage = clazz.getPackage();
        if (null == objectPackage) {
            return false;
        }
        String objectPackageName = objectPackage.getName();
        return objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || clazz.getClassLoader() == null;
    }

    public static boolean isInterface(Class<?> clazz) {
        return clazz.isInterface();
    }

    static {
        ArrayList primitiveTypes = new ArrayList(32);
        primitiveTypes.addAll(BasicType.PRIMITIVE_WRAPPER_MAP.keySet());
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_WRAPPER_MAP.put(clazz.getName(), clazz);
        }
    }

    public static enum Interfaces {
        INCLUDE,
        EXCLUDE;

    }

    private static final class Executable {
        private final Class<?>[] parameterTypes;
        private final boolean isVarArgs;

        private Executable(Method method) {
            this.parameterTypes = method.getParameterTypes();
            this.isVarArgs = method.isVarArgs();
        }

        private Executable(Constructor<?> constructor) {
            this.parameterTypes = constructor.getParameterTypes();
            this.isVarArgs = constructor.isVarArgs();
        }

        private static Executable of(Method method) {
            return new Executable(method);
        }

        private static Executable of(Constructor<?> constructor) {
            return new Executable(constructor);
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public boolean isVarArgs() {
            return this.isVarArgs;
        }
    }
}

