/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import org.aoju.bus.core.text.escape.EscapeCodeValues;
import org.aoju.bus.core.text.translate.CharSequenceTranslator;

public class EscapeKit {
    public static Builder builder(CharSequenceTranslator translator) {
        return new Builder(translator);
    }

    public static final String escapeJava(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.ESCAPE_JAVA.translate(input);
    }

    public static final String escapeEcmaScript(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.ESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String escapeJson(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.ESCAPE_JSON.translate(input);
    }

    public static final String unescapeJava(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_JAVA.translate(input);
    }

    public static final String unescapeEcmaScript(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String unescapeJson(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_JSON.translate(input);
    }

    public static final String escapeHtml4(String input) {
        return EscapeCodeValues.ESCAPE_HTML4.translate(input);
    }

    public static final String escapeHtml3(String input) {
        return EscapeCodeValues.ESCAPE_HTML3.translate(input);
    }

    public static final String unescapeHtml4(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_HTML4.translate(input);
    }

    public static final String unescapeHtml3(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_HTML3.translate(input);
    }

    public static String escapeXml10(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.ESCAPE_XML10.translate(input);
    }

    public static String escapeXml11(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.ESCAPE_XML11.translate(input);
    }

    public static final String unescapeXml(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_XML.translate(input);
    }

    public static final String escapeXSI(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.ESCAPE_XSI.translate(input);
    }

    public static final String unescapeXSI(String input) {
        new EscapeCodeValues();
        return EscapeCodeValues.UNESCAPE_XSI.translate(input);
    }

    public static final class Builder {
        private final StringBuilder sb = new StringBuilder();
        private final CharSequenceTranslator translator;

        private Builder(CharSequenceTranslator translator) {
            this.translator = translator;
        }

        public Builder escape(String input) {
            this.sb.append(this.translator.translate(input));
            return this;
        }

        public Builder append(String input) {
            this.sb.append(input);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

