/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron;

import org.aoju.bus.cron.Scheduler;
import org.aoju.bus.cron.factory.CronTask;
import org.aoju.bus.cron.factory.Task;

public class Executor
implements Runnable {
    private final Scheduler scheduler;
    private final CronTask task;

    public Executor(Scheduler scheduler, CronTask task) {
        this.scheduler = scheduler;
        this.task = task;
    }

    public Task getTask() {
        return this.task.getRaw();
    }

    public CronTask getCronTask() {
        return this.task;
    }

    @Override
    public void run() {
        try {
            this.scheduler.listenerManager.notifyTaskStart(this);
            this.task.execute();
            this.scheduler.listenerManager.notifyTaskSucceeded(this);
        }
        catch (Exception e) {
            this.scheduler.listenerManager.notifyTaskFailed(this, e);
        }
        finally {
            this.scheduler.manager.notifyExecutorCompleted(this);
        }
    }
}

