/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.symmetric;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Optional;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.crypto.Ciphers;
import org.aoju.bus.crypto.Mode;
import org.aoju.bus.crypto.Padding;
import org.aoju.bus.crypto.symmetric.Decryptor;
import org.aoju.bus.crypto.symmetric.Encryptor;

public class Crypto
implements Encryptor,
Decryptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Lock lock = new ReentrantLock();
    private SecretKey secretKey;
    private Ciphers ciphers;
    private boolean isZeroPadding;

    public Crypto(Algorithm algorithm) {
        this(algorithm, (byte[])null);
    }

    public Crypto(String algorithm) {
        this(algorithm, (byte[])null);
    }

    public Crypto(Algorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public Crypto(Algorithm algorithm, SecretKey key) {
        this(algorithm.getValue(), key);
    }

    public Crypto(String algorithm, byte[] key) {
        this(algorithm, Builder.generateKey(algorithm, key));
    }

    public Crypto(String algorithm, SecretKey key) {
        this(algorithm, key, null);
    }

    public Crypto(String algorithm, SecretKey key, AlgorithmParameterSpec paramsSpec) {
        this.init(algorithm, key);
        this.initParams(algorithm, paramsSpec);
    }

    private static void copyForZeroPadding(CipherInputStream in, OutputStream out, int blockSize) throws IOException {
        int i;
        int readSize;
        int n = 1;
        if (8192 > blockSize) {
            n = Math.max(n, 8192 / blockSize);
        }
        int bufSize = blockSize * n;
        byte[] preBuffer = new byte[bufSize];
        byte[] buffer = new byte[bufSize];
        boolean isFirst = true;
        int preReadSize = 0;
        while ((readSize = in.read(buffer)) != -1) {
            if (isFirst) {
                isFirst = false;
            } else {
                out.write(preBuffer, 0, preReadSize);
            }
            ArrayKit.copy(buffer, preBuffer, readSize);
            preReadSize = readSize;
        }
        for (i = preReadSize - 1; i >= 0 && 0 == preBuffer[i]; --i) {
        }
        out.write(preBuffer, 0, i + 1);
        out.flush();
    }

    public Crypto init(String algorithm, SecretKey key) {
        Assert.notBlank(algorithm, "'Algorithm' must be not blank !", new Object[0]);
        this.secretKey = key;
        if (algorithm.contains(Padding.ZeroPadding.name())) {
            algorithm = StringKit.replace((CharSequence)algorithm, (CharSequence)Padding.ZeroPadding.name(), Padding.NoPadding.name());
            this.isZeroPadding = true;
        }
        this.ciphers = new Ciphers(algorithm);
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.ciphers.getRaw();
    }

    public Crypto setParams(AlgorithmParameterSpec params) {
        this.ciphers.setParams(params);
        return this;
    }

    public Crypto setIv(IvParameterSpec iv) {
        return this.setParams(iv);
    }

    public Crypto setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }

    public Crypto setRandom(SecureRandom random) {
        this.ciphers.setRandom(random);
        return this;
    }

    public Crypto setMode(Mode.Cipher mode) {
        this.lock.lock();
        try {
            this.initMode(mode.getValue());
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public byte[] update(byte[] data) {
        Cipher cipher = this.ciphers.getRaw();
        this.lock.lock();
        try {
            byte[] byArray = cipher.update(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String updateHex(byte[] data) {
        return HexKit.encodeHexString(this.update(data));
    }

    @Override
    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(1);
            byte[] byArray = cipher.doFinal(this.paddingDataWithZero(data, cipher.getBlockSize()));
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encrypt(InputStream data, OutputStream out, boolean isClose) throws CryptoException {
        this.lock.lock();
        CipherOutputStream cipherOutputStream = null;
        try {
            int remainLength;
            int blockSize;
            Cipher cipher = this.initMode(1);
            cipherOutputStream = new CipherOutputStream(out, cipher);
            long length = IoKit.copy(data, cipherOutputStream);
            if (this.isZeroPadding && (blockSize = cipher.getBlockSize()) > 0 && (remainLength = (int)(length % (long)blockSize)) > 0) {
                cipherOutputStream.write(new byte[blockSize - remainLength]);
                cipherOutputStream.flush();
            }
        }
        catch (CryptoException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new CryptoException(e2);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IoKit.close(cipherOutputStream);
                if (!isClose) throw throwable;
                IoKit.close(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoKit.close(cipherOutputStream);
        if (!isClose) return;
        IoKit.close(data);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        byte[] decryptData;
        int blockSize;
        this.lock.lock();
        try {
            Cipher cipher = this.initMode(2);
            blockSize = cipher.getBlockSize();
            decryptData = cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return this.removePadding(decryptData, blockSize);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decrypt(InputStream data, OutputStream out, boolean isClose) throws CryptoException {
        CipherInputStream cipherInputStream;
        block7: {
            int blockSize;
            this.lock.lock();
            cipherInputStream = null;
            Cipher cipher = this.initMode(2);
            cipherInputStream = new CipherInputStream(data, cipher);
            if (!this.isZeroPadding || (blockSize = cipher.getBlockSize()) <= 0) break block7;
            Crypto.copyForZeroPadding(cipherInputStream, out, blockSize);
            this.lock.unlock();
            IoKit.close(cipherInputStream);
            if (!isClose) return;
            IoKit.close(data);
            return;
        }
        try {
            IoKit.copy((InputStream)cipherInputStream, out);
        }
        catch (IOException e) {
            try {
                throw new CryptoException(e);
                catch (CryptoException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new CryptoException(e3);
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                IoKit.close(cipherInputStream);
                if (!isClose) throw throwable;
                IoKit.close(data);
                throw throwable;
            }
        }
        this.lock.unlock();
        IoKit.close(cipherInputStream);
        if (!isClose) return;
        IoKit.close(data);
        return;
    }

    private Crypto initParams(String algorithm, AlgorithmParameterSpec paramsSpec) {
        if (null == paramsSpec) {
            byte[] iv = Optional.ofNullable(this.ciphers).map(Ciphers::getRaw).map(Cipher::getIV).get();
            if (StringKit.startWithIgnoreCase(algorithm, "PBE")) {
                if (null == iv) {
                    iv = RandomKit.randomBytes(8);
                }
                paramsSpec = new PBEParameterSpec(iv, 100);
            } else if (StringKit.startWithIgnoreCase(algorithm, Algorithm.AES.getValue()) && null != iv) {
                paramsSpec = new IvParameterSpec(iv);
            }
        }
        return this.setParams(paramsSpec);
    }

    private Cipher initMode(int mode) throws InvalidKeyException, InvalidAlgorithmParameterException {
        return this.ciphers.initMode(mode, this.secretKey).getRaw();
    }

    private byte[] paddingDataWithZero(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && (remainLength = (length = data.length) % blockSize) > 0) {
            return ArrayKit.resize(data, length + blockSize - remainLength);
        }
        return data;
    }

    private byte[] removePadding(byte[] data, int blockSize) {
        int length;
        int remainLength;
        if (this.isZeroPadding && blockSize > 0 && (remainLength = (length = data.length) % blockSize) == 0) {
            int i;
            for (i = length - 1; i >= 0 && 0 == data[i]; --i) {
            }
            return ArrayKit.resize(data, i + 1);
        }
        return data;
    }
}

