/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.extra.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.image.Images;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.ansi.Ansi8BitColor;
import org.aoju.bus.core.lang.ansi.AnsiEncoder;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ImageKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.extra.qrcode.LuminanceSource;
import org.aoju.bus.extra.qrcode.QrConfig;

public class QrCodeKit {
    public static File generate(String content, int width, int height, File targetFile) {
        String extName;
        switch (extName = FileKit.getSuffix(targetFile)) {
            case "svg": {
                String svg = QrCodeKit.generateAsSvg(content, new QrConfig(width, height));
                FileKit.writeString(svg, targetFile, Charset.UTF_8);
                break;
            }
            case "txt": {
                String txt = QrCodeKit.generateAsAsciiArt(content, new QrConfig(width, height));
                FileKit.writeString(txt, targetFile, Charset.UTF_8);
                break;
            }
            default: {
                BufferedImage image = QrCodeKit.generate(content, width, height);
                ImageKit.write(image, targetFile);
            }
        }
        return targetFile;
    }

    public static File generate(String content, QrConfig config, File targetFile) {
        String extName;
        switch (extName = FileKit.getSuffix(targetFile)) {
            case "svg": {
                String svg = QrCodeKit.generateAsSvg(content, config);
                FileKit.writeString(svg, targetFile, Charset.UTF_8);
                break;
            }
            case "txt": {
                String txt = QrCodeKit.generateAsAsciiArt(content, config);
                FileKit.writeString(txt, targetFile, Charset.UTF_8);
                break;
            }
            default: {
                BufferedImage image = QrCodeKit.generate(content, config);
                ImageKit.write(image, targetFile);
            }
        }
        return targetFile;
    }

    public static void generate(String content, int width, int height, String imageType, OutputStream out) {
        switch (imageType) {
            case "svg": {
                String svg = QrCodeKit.generateAsSvg(content, new QrConfig(width, height));
                IoKit.writeUtf8(out, false, svg);
                break;
            }
            case "txt": {
                String txt = QrCodeKit.generateAsAsciiArt(content, new QrConfig(width, height));
                IoKit.writeUtf8(out, false, txt);
                break;
            }
            default: {
                BufferedImage image = QrCodeKit.generate(content, width, height);
                ImageKit.write((Image)image, imageType, out);
            }
        }
    }

    public static void generate(String content, QrConfig config, String imageType, OutputStream out) {
        switch (imageType) {
            case "svg": {
                String svg = QrCodeKit.generateAsSvg(content, config);
                IoKit.writeUtf8(out, false, svg);
                break;
            }
            case "txt": {
                String txt = QrCodeKit.generateAsAsciiArt(content, config);
                IoKit.writeUtf8(out, false, txt);
                break;
            }
            default: {
                BufferedImage image = QrCodeKit.generate(content, config);
                ImageKit.write((Image)image, imageType, out);
            }
        }
    }

    public static BufferedImage generate(String content, int width, int height) {
        return QrCodeKit.generate(content, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, BarcodeFormat format, int width, int height) {
        return QrCodeKit.generate(content, format, new QrConfig(width, height));
    }

    public static BufferedImage generate(String content, QrConfig config) {
        return QrCodeKit.generate(content, BarcodeFormat.QR_CODE, config);
    }

    public static BufferedImage generate(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix = QrCodeKit.encode(content, format, config);
        BufferedImage image = QrCodeKit.toImage(bitMatrix, config.foreColor, config.backColor);
        Image logoImage = config.img;
        if (null != logoImage && BarcodeFormat.QR_CODE == format) {
            int height;
            int width;
            int qrHeight;
            int qrWidth = image.getWidth();
            if (qrWidth < (qrHeight = image.getHeight())) {
                width = qrWidth / config.ratio;
                height = logoImage.getHeight(null) * width / logoImage.getWidth(null);
            } else {
                height = qrHeight / config.ratio;
                width = logoImage.getWidth(null) * height / logoImage.getHeight(null);
            }
            Images.from(image).pressImage(Images.from(logoImage).round(0.3).getImg(), new Rectangle(width, height), 1.0f);
        }
        return image;
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType, String logoBase64) {
        return QrCodeKit.generateAsBase64(content, qrConfig, imageType, Base64.decode(logoBase64));
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType, byte[] logo) {
        return QrCodeKit.generateAsBase64(content, qrConfig, imageType, ImageKit.toImage(logo));
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType, Image logo) {
        qrConfig.setImg(logo);
        return QrCodeKit.generateAsBase64(content, qrConfig, imageType);
    }

    public static String generateAsBase64(String content, QrConfig qrConfig, String imageType) {
        return switch (imageType) {
            case "svg" -> {
                String svg = QrCodeKit.generateAsSvg(content, qrConfig);
                yield UriKit.toURL("image/svg+xml", "base64", Base64.encode(svg));
            }
            case "txt" -> {
                String txt = QrCodeKit.generateAsAsciiArt(content, qrConfig);
                yield UriKit.toURL("text/plain", "base64", Base64.encode(txt));
            }
            default -> {
                BufferedImage img = QrCodeKit.generate(content, qrConfig);
                yield ImageKit.toBase64Uri(img, imageType);
            }
        };
    }

    public static byte[] generatePng(String content, int width, int height) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, width, height, "png", out);
        return out.toByteArray();
    }

    public static byte[] generatePng(String content, QrConfig config) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        QrCodeKit.generate(content, config, "png", out);
        return out.toByteArray();
    }

    public static String generateAsSvg(String content, QrConfig qrConfig) {
        return QrCodeKit.toSVG(QrCodeKit.encode(content, qrConfig), qrConfig.foreColor, qrConfig.backColor, qrConfig.img, qrConfig.getRatio());
    }

    public static String generateAsAsciiArt(String content) {
        return QrCodeKit.generateAsAsciiArt(content, 0, 0, 1);
    }

    public static String generateAsAsciiArt(String content, QrConfig qrConfig) {
        return QrCodeKit.toAsciiArt(QrCodeKit.encode(content, qrConfig), qrConfig);
    }

    public static String generateAsAsciiArt(String content, int width, int height, int margin) {
        QrConfig qrConfig = new QrConfig(width, height).setMargin(margin);
        return QrCodeKit.generateAsAsciiArt(content, qrConfig);
    }

    public static BitMatrix encode(String content, int width, int height) {
        return QrCodeKit.encode(content, BarcodeFormat.QR_CODE, width, height);
    }

    public static BitMatrix encode(String content, QrConfig config) {
        return QrCodeKit.encode(content, BarcodeFormat.QR_CODE, config);
    }

    public static BitMatrix encode(String content, BarcodeFormat format, int width, int height) {
        return QrCodeKit.encode(content, format, new QrConfig(width, height));
    }

    public static BitMatrix encode(String content, BarcodeFormat format, QrConfig config) {
        BitMatrix bitMatrix;
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        if (null == config) {
            config = new QrConfig();
        }
        try {
            bitMatrix = multiFormatWriter.encode(content, format, config.width, config.height, config.toHints(format));
        }
        catch (WriterException e) {
            throw new InternalException(e);
        }
        return bitMatrix;
    }

    public static String decode(InputStream qrCodeInputstream) {
        return QrCodeKit.decode(ImageKit.read(qrCodeInputstream));
    }

    public static String decode(File qrCodeFile) {
        return QrCodeKit.decode(ImageKit.read(qrCodeFile));
    }

    public static String decode(Image image) {
        return QrCodeKit.decode(image, true, false);
    }

    public static String decode(Image image, boolean isTryHarder, boolean isPureBarcode) {
        return QrCodeKit.decode(image, QrCodeKit.buildHints(isTryHarder, isPureBarcode));
    }

    public static String decode(Image image, Map<DecodeHintType, Object> hints) {
        MultiFormatReader formatReader = new MultiFormatReader();
        formatReader.setHints(hints);
        LuminanceSource source = new LuminanceSource(ImageKit.toBufferedImage(image));
        Result result = QrCodeKit._decode(formatReader, (Binarizer)new HybridBinarizer((com.google.zxing.LuminanceSource)source));
        if (null == result) {
            result = QrCodeKit._decode(formatReader, (Binarizer)new GlobalHistogramBinarizer((com.google.zxing.LuminanceSource)source));
        }
        return null != result ? result.getText() : null;
    }

    public static BufferedImage toImage(BitMatrix matrix, int foreColor, Integer backColor) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, null == backColor ? 2 : 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrix.get(x, y)) {
                    image.setRGB(x, y, foreColor);
                    continue;
                }
                if (null == backColor) continue;
                image.setRGB(x, y, backColor);
            }
        }
        return image;
    }

    public static String toSVG(BitMatrix matrix, int foreColor, Integer backColor, Image logoImg, int ratio) {
        StringBuilder sb = new StringBuilder();
        int qrWidth = matrix.getWidth();
        int qrHeight = matrix.getHeight();
        int moduleHeight = qrHeight == 1 ? qrWidth / 2 : 1;
        for (int y = 0; y < qrHeight; ++y) {
            for (int x = 0; x < qrWidth; ++x) {
                if (!matrix.get(x, y)) continue;
                sb.append(" M" + x + "," + y + "h1v" + moduleHeight + "h-1z");
            }
        }
        qrHeight *= moduleHeight;
        String logoBase64 = "";
        int logoWidth = 0;
        int logoHeight = 0;
        int logoX = 0;
        int logoY = 0;
        if (logoImg != null) {
            logoBase64 = ImageKit.toBase64Uri(logoImg, "png");
            if (qrWidth < qrHeight) {
                logoWidth = qrWidth / ratio;
                logoHeight = logoImg.getHeight(null) * logoWidth / logoImg.getWidth(null);
            } else {
                logoHeight = qrHeight / ratio;
                logoWidth = logoImg.getWidth(null) * logoHeight / logoImg.getHeight(null);
            }
            logoX = (qrWidth - logoWidth) / 2;
            logoY = (qrHeight - logoHeight) / 2;
        }
        Color fore = new Color(foreColor, true);
        StringBuilder result = StringKit.builder();
        result.append("<svg width=\"" + qrWidth + "\" height=\"" + qrHeight + "\" \n");
        if (backColor != null) {
            Color back = new Color(backColor, true);
            result.append("style=\"background-color:rgba(" + back.getRed() + "," + back.getGreen() + "," + back.getBlue() + "," + back.getAlpha() + ")\"\n");
        }
        result.append("viewBox=\"0 0 " + qrWidth + " " + qrHeight + "\" \n");
        result.append("xmlns=\"http://www.w3.org/2000/svg\" \n");
        result.append("xmlns:xlink=\"http://www.w3.org/1999/xlink\" >\n");
        result.append("<path d=\"" + sb + "\" stroke=\"rgba(" + fore.getRed() + "," + fore.getGreen() + "," + fore.getBlue() + "," + fore.getAlpha() + ")\" /> \n");
        if (StringKit.isNotBlank(logoBase64)) {
            result.append("<image xlink:href=\"" + logoBase64 + "\" height=\"" + logoHeight + "\" width=\"" + logoWidth + "\" y=\"" + logoY + "\" x=\"" + logoX + "\" />\n");
        }
        result.append("</svg>");
        return result.toString();
    }

    public static String toAsciiArt(BitMatrix bitMatrix, QrConfig qrConfig) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        Ansi8BitColor foreground = qrConfig.foreColor == null ? null : Ansi8BitColor.foreground(QrCodeKit.rgbToAnsi8BitValue(qrConfig.foreColor));
        Ansi8BitColor background = qrConfig.backColor == null ? null : Ansi8BitColor.background(QrCodeKit.rgbToAnsi8BitValue(qrConfig.backColor));
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= height; i += 2) {
            StringBuilder rowBuilder = new StringBuilder();
            for (int j = 0; j < width; ++j) {
                boolean bt;
                boolean tp = bitMatrix.get(i, j);
                boolean bl = bt = i + 1 >= height || bitMatrix.get(i + 1, j);
                if (tp && bt) {
                    rowBuilder.append(' ');
                    continue;
                }
                if (tp) {
                    rowBuilder.append('\u2584');
                    continue;
                }
                if (bt) {
                    rowBuilder.append('\u2580');
                    continue;
                }
                rowBuilder.append('\u2588');
            }
            builder.append(AnsiEncoder.encode(foreground, background, rowBuilder)).append('\n');
        }
        return builder.toString();
    }

    private static int rgbToAnsi8BitValue(int rgb) {
        int i;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int l = r == g && g == b ? ((i = (int)MathKit.div(MathKit.mul((double)r - 10.625, 23.0f), 244.375, 0)) >= 0 ? 232 + i : 0) : 16 + (int)(36.0 * MathKit.div(MathKit.mul((float)r, 5.0f), 255.0f, 0)) + (int)(6.0 * ((double)g / 256.0 * 6.0)) + (int)((double)b / 256.0 * 6.0);
        return l;
    }

    private static Map<DecodeHintType, Object> buildHints(boolean isTryHarder, boolean isPureBarcode) {
        HashMap<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, Charset.UTF_8);
        if (isTryHarder) {
            hints.put(DecodeHintType.TRY_HARDER, true);
        }
        if (isPureBarcode) {
            hints.put(DecodeHintType.PURE_BARCODE, true);
        }
        return hints;
    }

    private static Result _decode(MultiFormatReader formatReader, Binarizer binarizer) {
        try {
            return formatReader.decodeWithState(new BinaryBitmap(binarizer));
        }
        catch (NotFoundException e) {
            return null;
        }
    }
}

