/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.goalie.Registry;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractRegistry<T>
implements Registry<T>,
InitializingBean {
    private final Map<String, T> cache = new ConcurrentHashMap<String, T>();

    @Override
    public abstract void init();

    @Override
    public boolean add(String key, T reg) {
        if (null != this.cache.get(key)) {
            return false;
        }
        this.cache.put(key, reg);
        return true;
    }

    @Override
    public boolean remove(String id) {
        return null != this.cache.remove(id);
    }

    @Override
    public boolean amend(String key, T reg) {
        this.cache.remove(key);
        return this.add(key, reg);
    }

    @Override
    public void refresh() {
        this.cache.clear();
        this.init();
    }

    @Override
    public T get(String key) {
        return this.cache.get(key);
    }

    public void afterPropertiesSet() {
        this.refresh();
    }
}

