/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin;

import java.io.Serializable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Platform;

public class Java
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String JAVA_VERSION = Platform.get("java.version", false);
    private final float JAVA_VERSION_FLOAT = this.getJavaVersionAsFloat();
    private final int JAVA_VERSION_INT = this.getJavaVersionAsInt();
    private final String JAVA_VENDOR = Platform.get("java.vendor", false);
    private final String JAVA_VENDOR_URL = Platform.get("java.vendor.url", false);
    private final boolean IS_JAVA_1_8 = this.getJavaVersionMatches("1.8");
    private final boolean IS_JAVA_9 = this.getJavaVersionMatches("9");
    private final boolean IS_JAVA_10 = this.getJavaVersionMatches("10");
    private final boolean IS_JAVA_11 = this.getJavaVersionMatches("11");
    private final boolean IS_JAVA_12 = this.getJavaVersionMatches("12");
    private final boolean IS_JAVA_13 = this.getJavaVersionMatches("13");
    private final boolean IS_JAVA_14 = this.getJavaVersionMatches("14");
    private final boolean IS_JAVA_15 = this.getJavaVersionMatches("15");
    private final boolean IS_JAVA_16 = this.getJavaVersionMatches("16");
    private final boolean IS_JAVA_17 = this.getJavaVersionMatches("17");
    private final boolean IS_JAVA_18 = this.getJavaVersionMatches("18");

    public final String getVersion() {
        return this.JAVA_VERSION;
    }

    public final float getVersionFloat() {
        return this.JAVA_VERSION_FLOAT;
    }

    public final int getVersionInt() {
        return this.JAVA_VERSION_INT;
    }

    private float getJavaVersionAsFloat() {
        if (null == this.JAVA_VERSION) {
            return 0.0f;
        }
        Object text = this.JAVA_VERSION.substring(0, 3);
        if (this.JAVA_VERSION.length() >= 5) {
            text = (String)text + this.JAVA_VERSION.charAt(4);
        }
        return Float.parseFloat((String)text);
    }

    private int getJavaVersionAsInt() {
        if (null == this.JAVA_VERSION) {
            return 0;
        }
        Object text = this.JAVA_VERSION.substring(0, 1);
        text = (String)text + this.JAVA_VERSION.charAt(2);
        text = this.JAVA_VERSION.length() >= 5 ? (String)text + this.JAVA_VERSION.charAt(4) : (String)text + "0";
        return Integer.parseInt((String)text);
    }

    public final String getVendor() {
        return this.JAVA_VENDOR;
    }

    public final String getVendorURL() {
        return this.JAVA_VENDOR_URL;
    }

    public final boolean isJava1_8() {
        return this.IS_JAVA_1_8;
    }

    public final boolean isJava9() {
        return this.IS_JAVA_9;
    }

    public final boolean isJava10() {
        return this.IS_JAVA_10;
    }

    public final boolean isJava11() {
        return this.IS_JAVA_11;
    }

    public final boolean isJava12() {
        return this.IS_JAVA_12;
    }

    public final boolean isJava13() {
        return this.IS_JAVA_13;
    }

    public final boolean isJava14() {
        return this.IS_JAVA_14;
    }

    public final boolean isJava15() {
        return this.IS_JAVA_15;
    }

    public final boolean isJava16() {
        return this.IS_JAVA_16;
    }

    public final boolean isJava17() {
        return this.IS_JAVA_17;
    }

    public final boolean isJava18() {
        return this.IS_JAVA_18;
    }

    private boolean getJavaVersionMatches(String versionPrefix) {
        if (null == this.JAVA_VERSION) {
            return false;
        }
        return this.JAVA_VERSION.startsWith(versionPrefix);
    }

    public final boolean isJavaVersionAtLeast(float requiredVersion) {
        return this.getVersionFloat() >= requiredVersion;
    }

    public final boolean isJavaVersionAtLeast(int requiredVersion) {
        return this.getVersionInt() >= requiredVersion;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        Builder.append(builder, "Java Version:    ", this.getVersion());
        Builder.append(builder, "Java Vendor:     ", this.getVendor());
        Builder.append(builder, "Java Vendor URL: ", this.getVendorURL());
        return builder.toString();
    }
}

