/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.mac.hardware;

import com.sun.jna.platform.mac.IOKit;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.builtin.hardware.AbstractSensors;
import org.aoju.bus.health.mac.SmcKit;

@ThreadSafe
final class MacSensors
extends AbstractSensors {
    private int numFans = 0;

    MacSensors() {
    }

    @Override
    public double queryCpuTemperature() {
        IOKit.IOConnect conn = SmcKit.smcOpen();
        double temp = SmcKit.smcGetFloat(conn, "TC0P");
        SmcKit.smcClose(conn);
        if (temp > 0.0) {
            return temp;
        }
        return 0.0;
    }

    @Override
    public int[] queryFanSpeeds() {
        IOKit.IOConnect conn = SmcKit.smcOpen();
        if (this.numFans == 0) {
            this.numFans = (int)SmcKit.smcGetLong(conn, "FNum");
        }
        int[] fanSpeeds = new int[this.numFans];
        for (int i = 0; i < this.numFans; ++i) {
            fanSpeeds[i] = (int)SmcKit.smcGetFloat(conn, String.format("F%dAc", i));
        }
        SmcKit.smcClose(conn);
        return fanSpeeds;
    }

    @Override
    public double queryCpuVoltage() {
        IOKit.IOConnect conn = SmcKit.smcOpen();
        double volts = SmcKit.smcGetFloat(conn, "VC0C") / 1000.0;
        SmcKit.smcClose(conn);
        return volts;
    }
}

