/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractVirtualMemory;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdGlobalMemory;

@ThreadSafe
final class OpenBsdVirtualMemory
extends AbstractVirtualMemory {
    private final OpenBsdGlobalMemory global;
    private final Supplier<Triple<Integer, Integer, Integer>> usedTotalPgin = Memoize.memoize(OpenBsdVirtualMemory::queryVmstat, Memoize.defaultExpiration());
    private final Supplier<Integer> pgout = Memoize.memoize(OpenBsdVirtualMemory::queryUvm, Memoize.defaultExpiration());

    OpenBsdVirtualMemory(OpenBsdGlobalMemory freeBsdGlobalMemory) {
        this.global = freeBsdGlobalMemory;
    }

    private static Triple<Integer, Integer, Integer> queryVmstat() {
        int used = 0;
        int total = 0;
        int swapIn = 0;
        for (String line : Executor.runNative("vmstat -s")) {
            if (line.contains("swap pages in use")) {
                used = Builder.getFirstIntValue(line);
                continue;
            }
            if (line.contains("swap pages")) {
                total = Builder.getFirstIntValue(line);
                continue;
            }
            if (!line.contains("pagein operations")) continue;
            swapIn = Builder.getFirstIntValue(line);
        }
        return Triple.of(used, total, swapIn);
    }

    private static int queryUvm() {
        for (String line : Executor.runNative("systat -ab uvm")) {
            if (!line.contains("pdpageouts")) continue;
            return Builder.getFirstIntValue(line);
        }
        return 0;
    }

    @Override
    public long getSwapUsed() {
        return (long)this.usedTotalPgin.get().getLeft().intValue() * this.global.getPageSize();
    }

    @Override
    public long getSwapTotal() {
        return (long)this.usedTotalPgin.get().getMiddle().intValue() * this.global.getPageSize();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getTotal() + this.getSwapTotal();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getTotal() - this.global.getAvailable() + this.getSwapUsed();
    }

    @Override
    public long getSwapPagesIn() {
        return (long)this.usedTotalPgin.get().getRight().intValue() * this.global.getPageSize();
    }

    @Override
    public long getSwapPagesOut() {
        return (long)this.pgout.get().intValue() * this.global.getPageSize();
    }
}

