/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.solaris.Kstat2;
import com.sun.jna.platform.unix.solaris.Kstat2StatusException;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.annotation.GuardeBy;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ThreadKit;
import org.aoju.bus.health.Formats;
import org.aoju.bus.health.unix.solaris.software.SolarisOperatingSystem;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public final class KstatKit {
    private static final Lock CHAIN = new ReentrantLock();
    @GuardeBy(value="CHAIN")
    private static LibKstat.KstatCtl kstatCtl = null;

    private KstatKit() {
    }

    public static String dataLookupString(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = LibKstat.INSTANCE.kstat_data_lookup(ksp, name);
        if (p == null) {
            Logger.debug("Failed to lookup kstat value for key {}", name);
            return "";
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 0: {
                return Native.toString((byte[])data.value.charc, (java.nio.charset.Charset)Charset.UTF_8);
            }
            case 1: {
                return Integer.toString(data.value.i32);
            }
            case 2: {
                return Formats.toUnsignedString(data.value.ui32);
            }
            case 3: {
                return Long.toString(data.value.i64);
            }
            case 4: {
                return Formats.toUnsignedString(data.value.ui64);
            }
            case 9: {
                return data.value.str.addr.getString(0L);
            }
        }
        Logger.error("Unimplemented kstat data type {}", data.data_type);
        return "";
    }

    public static synchronized KstatChain openChain() {
        CHAIN.lock();
        if (kstatCtl == null) {
            kstatCtl = LibKstat.INSTANCE.kstat_open();
        }
        return new KstatChain(kstatCtl);
    }

    public static long dataLookupLong(LibKstat.Kstat ksp, String name) {
        if (ksp.ks_type != 1 && ksp.ks_type != 4) {
            throw new IllegalArgumentException("Not a kstat_named or kstat_timer kstat.");
        }
        Pointer p = LibKstat.INSTANCE.kstat_data_lookup(ksp, name);
        if (p == null) {
            if (Logger.isDebug()) {
                Logger.debug("Failed lo lookup kstat value on {}:{}:{} for key {}", Native.toString((byte[])ksp.ks_module, (java.nio.charset.Charset)Charset.US_ASCII), ksp.ks_instance, Native.toString((byte[])ksp.ks_name, (java.nio.charset.Charset)Charset.US_ASCII), name);
            }
            return 0L;
        }
        LibKstat.KstatNamed data = new LibKstat.KstatNamed(p);
        switch (data.data_type) {
            case 1: {
                return data.value.i32;
            }
            case 2: {
                return Formats.getUnsignedInt(data.value.ui32);
            }
            case 3: {
                return data.value.i64;
            }
            case 4: {
                return data.value.ui64;
            }
        }
        Logger.error("Unimplemented or non-numeric kstat data type {}", data.data_type);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] queryKstat2(String mapStr, String ... names) {
        if (!SolarisOperatingSystem.HAS_KSTAT2) {
            throw new UnsupportedOperationException("Kstat2 requires Solaris 11.4+. Use SolarisOperatingSystem#HAS_KSTAT2 to test this.");
        }
        Object[] result = new Object[names.length];
        Kstat2.Kstat2MatcherList matchers = new Kstat2.Kstat2MatcherList();
        CHAIN.lock();
        try {
            matchers.addMatcher(0, mapStr);
            try (Kstat2.Kstat2Handle handle = new Kstat2.Kstat2Handle();){
                Kstat2.Kstat2Map map = handle.lookupMap(mapStr);
                for (int i = 0; i < names.length; ++i) {
                    result[i] = map.getValue(names[i]);
                }
            }
        }
        catch (Kstat2StatusException e) {
            Logger.debug("Failed to get stats on {} for names {}: {}", mapStr, Arrays.toString(names), e.getMessage());
        }
        finally {
            CHAIN.unlock();
            matchers.free();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object[]> queryKstat2List(String beforeStr, String afterStr, String ... names) {
        if (!SolarisOperatingSystem.HAS_KSTAT2) {
            throw new UnsupportedOperationException("Kstat2 requires Solaris 11.4+. Use SolarisOperatingSystem#HAS_KSTAT2 to test this.");
        }
        ArrayList<Object[]> results = new ArrayList<Object[]>();
        int s = 0;
        Kstat2.Kstat2MatcherList matchers = new Kstat2.Kstat2MatcherList();
        CHAIN.lock();
        try {
            matchers.addMatcher(1, beforeStr + "*" + afterStr);
            try (Kstat2.Kstat2Handle handle = new Kstat2.Kstat2Handle();){
                for (s = 0; s < Integer.MAX_VALUE; ++s) {
                    Object[] result = new Object[names.length];
                    Kstat2.Kstat2Map map = handle.lookupMap(beforeStr + s + afterStr);
                    for (int i = 0; i < names.length; ++i) {
                        result[i] = map.getValue(names[i]);
                    }
                    results.add(result);
                }
            }
        }
        catch (Kstat2StatusException e) {
            Logger.debug("Failed to get stats on {}{}{} for names {}: {}", beforeStr, s, afterStr, Arrays.toString(names), e.getMessage());
        }
        finally {
            CHAIN.unlock();
            matchers.free();
        }
        return results;
    }

    public static final class KstatChain
    implements AutoCloseable {
        private final LibKstat.KstatCtl localCtlRef;

        private KstatChain(LibKstat.KstatCtl ctl) {
            this.localCtlRef = ctl;
            this.update();
        }

        @GuardeBy(value="CHAIN")
        public boolean read(LibKstat.Kstat ksp) {
            int retry = 0;
            while (0 > LibKstat.INSTANCE.kstat_read(this.localCtlRef, ksp, null)) {
                if (11 != Native.getLastError() || 5 <= ++retry) {
                    if (Logger.isDebug()) {
                        Logger.debug("Failed to read kstat {}:{}:{}", Native.toString((byte[])ksp.ks_module, (java.nio.charset.Charset)Charset.US_ASCII), ksp.ks_instance, Native.toString((byte[])ksp.ks_name, (java.nio.charset.Charset)Charset.US_ASCII));
                    }
                    return false;
                }
                ThreadKit.sleep(8 << retry);
            }
            return true;
        }

        @GuardeBy(value="CHAIN")
        public LibKstat.Kstat lookup(String module, int instance, String name) {
            return LibKstat.INSTANCE.kstat_lookup(this.localCtlRef, module, instance, name);
        }

        @GuardeBy(value="CHAIN")
        public List<LibKstat.Kstat> lookupAll(String module, int instance, String name) {
            ArrayList<LibKstat.Kstat> kstats = new ArrayList<LibKstat.Kstat>();
            for (LibKstat.Kstat ksp = LibKstat.INSTANCE.kstat_lookup(this.localCtlRef, module, instance, name); ksp != null; ksp = ksp.next()) {
                if (module != null && !module.equals(Native.toString((byte[])ksp.ks_module, (java.nio.charset.Charset)Charset.US_ASCII)) || instance >= 0 && instance != ksp.ks_instance || name != null && !name.equals(Native.toString((byte[])ksp.ks_name, (java.nio.charset.Charset)Charset.US_ASCII))) continue;
                kstats.add(ksp);
            }
            return kstats;
        }

        @GuardeBy(value="CHAIN")
        public int update() {
            return LibKstat.INSTANCE.kstat_chain_update(this.localCtlRef);
        }

        @Override
        public void close() {
            CHAIN.unlock();
        }
    }
}

