/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.bodys;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.buffer.Buffer;
import org.aoju.bus.core.io.source.BufferSource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Builder;

public abstract class ResponseBody
implements Closeable {
    private Reader reader;

    public static ResponseBody create(MediaType mediaType, String content) {
        java.nio.charset.Charset charset = Charset.UTF_8;
        if (mediaType != null && (charset = mediaType.charset()) == null) {
            charset = Charset.UTF_8;
            mediaType = MediaType.valueOf(String.valueOf(mediaType) + "; charset=utf-8");
        }
        Buffer buffer = new Buffer().writeString(content, charset);
        return ResponseBody.create(mediaType, buffer.size(), buffer);
    }

    public static ResponseBody create(MediaType mediaType, byte[] content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(mediaType, content.length, buffer);
    }

    public static ResponseBody create(MediaType mediaType, ByteString content) {
        Buffer buffer = new Buffer().write(content);
        return ResponseBody.create(mediaType, content.size(), buffer);
    }

    public static ResponseBody create(final MediaType mediaType, final long length, final BufferSource content) {
        if (null == content) {
            throw new NullPointerException("source == null");
        }
        return new ResponseBody(){

            @Override
            public MediaType mediaType() {
                return mediaType;
            }

            @Override
            public long length() {
                return length;
            }

            @Override
            public BufferSource source() {
                return content;
            }
        };
    }

    public abstract MediaType mediaType();

    public abstract long length();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferSource source();

    public final byte[] bytes() throws IOException {
        byte[] bytes;
        long contentLength = this.length();
        if (contentLength > Integer.MAX_VALUE) {
            throw new IOException("Cannot buffer entire body for content length: " + contentLength);
        }
        try (BufferSource source = this.source();){
            bytes = source.readByteArray();
        }
        if (contentLength != -1L && contentLength != (long)bytes.length) {
            throw new IOException("Content-Length (" + contentLength + ") and stream length (" + bytes.length + ") disagree");
        }
        return bytes;
    }

    public final Reader charStream() {
        Reader r = this.reader;
        return null != r ? r : (this.reader = new BomAwareReader(this.source(), this.charset()));
    }

    public final String string() throws IOException {
        try (BufferSource source = this.source();){
            java.nio.charset.Charset charset = Builder.bomAwareCharset(source, this.charset());
            String string = source.readString(charset);
            return string;
        }
    }

    private java.nio.charset.Charset charset() {
        MediaType mediaType = this.mediaType();
        return null != mediaType ? mediaType.charset(Charset.UTF_8) : Charset.UTF_8;
    }

    @Override
    public void close() {
        IoKit.close(this.source());
    }

    static class BomAwareReader
    extends Reader {
        private final BufferSource source;
        private final java.nio.charset.Charset charset;
        private boolean closed;
        private Reader delegate;

        BomAwareReader(BufferSource source, java.nio.charset.Charset charset) {
            this.source = source;
            this.charset = charset;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            Reader delegate = this.delegate;
            if (null == delegate) {
                java.nio.charset.Charset charset = Builder.bomAwareCharset(this.source, this.charset);
                delegate = this.delegate = new InputStreamReader(this.source.inputStream(), charset);
            }
            return delegate.read(cbuf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (null != this.delegate) {
                this.delegate.close();
            } else {
                this.source.close();
            }
        }
    }
}

