/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Callback;
import org.aoju.bus.http.plugin.httpv.CoverHttp;
import org.aoju.bus.http.plugin.httpv.CoverTasks;

public class Downloads {
    private final Object lock = new Object();
    protected boolean nextOnIO = false;
    private File file;
    private InputStream input;
    private Callback<File> onSuccess;
    private Callback<Failure> onFailure;
    private CoverTasks.Executor executor;
    private long doneBytes;
    private int buffSize = 0;
    private long seekBytes = 0L;
    private boolean appended;
    private volatile int status;
    private boolean sOnIO;
    private boolean fOnIO;
    private Control control;

    public Downloads(File file, InputStream input, CoverTasks.Executor executor, long skipBytes) {
        this.file = file;
        this.input = input;
        this.executor = executor;
        this.seekBytes = skipBytes;
        this.control = new Control();
    }

    public Downloads setBuffSize(int buffSize) {
        if (buffSize > 0) {
            this.buffSize = buffSize;
        }
        return this;
    }

    public Downloads setAppended() {
        this.appended = true;
        return this;
    }

    public Downloads setFilePointer(long seekBytes) {
        this.seekBytes = seekBytes;
        return this;
    }

    public Downloads nextOnIO() {
        this.nextOnIO = true;
        return this;
    }

    public Downloads setOnSuccess(Callback<File> onSuccess) {
        this.onSuccess = onSuccess;
        this.sOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Downloads setOnFailure(Callback<Failure> onFailure) {
        this.onFailure = onFailure;
        this.fOnIO = this.nextOnIO;
        this.nextOnIO = false;
        return this;
    }

    public Control start() {
        if (this.buffSize == 0) {
            this.buffSize = 8192;
        }
        RandomAccessFile raFile = this.randomAccessFile();
        this.status = 1;
        this.executor.execute(() -> this.doDownload(raFile), true);
        return this.control;
    }

    public Control getCtrl() {
        return this.control;
    }

    private RandomAccessFile randomAccessFile() {
        try {
            return new RandomAccessFile(this.file, "rw");
        }
        catch (FileNotFoundException e) {
            this.status = 4;
            IoKit.close(this.input);
            throw new InternalException("Can't get file [" + this.file.getAbsolutePath() + "] Input stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doDownload(RandomAccessFile raFile) {
        try {
            if (this.appended && this.seekBytes > 0L) {
                long length = raFile.length();
                if (this.seekBytes <= length) {
                    raFile.seek(this.seekBytes);
                    this.doneBytes = this.seekBytes;
                } else {
                    raFile.seek(length);
                    this.doneBytes = length;
                }
            }
            while (this.status != -1 && this.status != 3) {
                if (this.status != 1) continue;
                byte[] buff = new byte[this.buffSize];
                int len = -1;
                while ((len = this.input.read(buff)) != -1) {
                    raFile.write(buff, 0, len);
                    this.doneBytes += (long)len;
                    if (this.status != -1 && this.status != 2) continue;
                }
                if (len != -1) continue;
                Object object = this.lock;
                // MONITORENTER : object
                this.status = 3;
                // MONITOREXIT : object
            }
        }
        catch (IOException e) {
            Object object = this.lock;
            // MONITORENTER : object
            this.status = 4;
            // MONITOREXIT : object
            if (null == this.onFailure) throw new InternalException("Streaming failed!", e);
            this.executor.execute(() -> this.onFailure.on(new Failure(e)), this.fOnIO);
        }
        finally {
            IoKit.close(raFile);
            IoKit.close(this.input);
            if (this.status == -1) {
                this.file.delete();
            }
        }
        if (this.status != 3) return;
        if (null == this.onSuccess) return;
        this.executor.execute(() -> this.onSuccess.on(this.file), this.sOnIO);
    }

    public class Control {
        public static final int STATUS__CANCELED = -1;
        public static final int STATUS__DOWNLOADING = 1;
        public static final int STATUS__PAUSED = 2;
        public static final int STATUS__DONE = 3;
        public static final int STATUS__ERROR = 4;

        public int status() {
            return Downloads.this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            Object object = Downloads.this.lock;
            synchronized (object) {
                if (Downloads.this.status == 1) {
                    Downloads.this.status = 2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resume() {
            Object object = Downloads.this.lock;
            synchronized (object) {
                if (Downloads.this.status == 2) {
                    Downloads.this.status = 1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            Object object = Downloads.this.lock;
            synchronized (object) {
                if (Downloads.this.status == 2 || Downloads.this.status == 1) {
                    Downloads.this.status = -1;
                }
            }
        }
    }

    public class Failure {
        private IOException exception;

        Failure(IOException exception) {
            this.exception = exception;
        }

        public File getFile() {
            return Downloads.this.file;
        }

        public long getDoneBytes() {
            return Downloads.this.doneBytes;
        }

        public IOException getException() {
            return this.exception;
        }
    }

    public static interface Listener {
        public void listen(CoverHttp<?> var1, Downloads var2);
    }
}

