/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.secure;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class Challenge {
    private final String scheme;
    private final Map<String, String> authParams;

    public Challenge(String scheme, Map<String, String> authParams) {
        if (null == scheme) {
            throw new NullPointerException("scheme == null");
        }
        if (null == authParams) {
            throw new NullPointerException("authParams == null");
        }
        this.scheme = scheme;
        LinkedHashMap<String, String> newAuthParams = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> authParam : authParams.entrySet()) {
            String key = null == authParam.getKey() ? null : authParam.getKey().toLowerCase(Locale.US);
            newAuthParams.put(key, authParam.getValue());
        }
        this.authParams = Collections.unmodifiableMap(newAuthParams);
    }

    public Challenge(String scheme, String realm) {
        if (null == scheme) {
            throw new NullPointerException("scheme == null");
        }
        if (null == realm) {
            throw new NullPointerException("realm == null");
        }
        this.scheme = scheme;
        this.authParams = Collections.singletonMap("realm", realm);
    }

    public Challenge withCharset(Charset charset) {
        if (null == charset) {
            throw new NullPointerException("charset == null");
        }
        LinkedHashMap<String, String> authParams = new LinkedHashMap<String, String>(this.authParams);
        authParams.put("charset", charset.name());
        return new Challenge(this.scheme, authParams);
    }

    public String scheme() {
        return this.scheme;
    }

    public Map<String, String> authParams() {
        return this.authParams;
    }

    public String realm() {
        return this.authParams.get("realm");
    }

    public Charset charset() {
        String charset = this.authParams.get("charset");
        if (null != charset) {
            try {
                return Charset.forName(charset);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return org.aoju.bus.core.lang.Charset.ISO_8859_1;
    }

    public boolean equals(Object other) {
        return other instanceof Challenge && ((Challenge)other).scheme.equals(this.scheme) && ((Challenge)other).authParams.equals(this.authParams);
    }

    public int hashCode() {
        int result = 29;
        result = 31 * result + this.scheme.hashCode();
        result = 31 * result + this.authParams.hashCode();
        return result;
    }

    public String toString() {
        return this.scheme + " authParams=" + String.valueOf(this.authParams);
    }
}

