/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.util.ServiceLoader;
import org.aoju.bus.image.galaxy.data.StandardDictionary;
import org.aoju.bus.image.galaxy.data.VR;

public abstract class ElementDictionary {
    private static final ServiceLoader<ElementDictionary> loader = ServiceLoader.load(ElementDictionary.class);
    private final String privateCreator;
    private final Class<?> tagClass;

    protected ElementDictionary(String privateCreator, Class<?> tagClass) {
        this.privateCreator = privateCreator;
        this.tagClass = tagClass;
    }

    public static ElementDictionary getStandardElementDictionary() {
        return StandardDictionary.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElementDictionary getElementDictionary(String privateCreator) {
        if (null != privateCreator) {
            ServiceLoader<ElementDictionary> serviceLoader = loader;
            synchronized (serviceLoader) {
                for (ElementDictionary dict : loader) {
                    if (!privateCreator.equals(dict.getPrivateCreator())) continue;
                    return dict;
                }
            }
        }
        return ElementDictionary.getStandardElementDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        ServiceLoader<ElementDictionary> serviceLoader = loader;
        synchronized (serviceLoader) {
            loader.reload();
        }
    }

    public static VR vrOf(int tag, String privateCreator) {
        return ElementDictionary.getElementDictionary(privateCreator).vrOf(tag);
    }

    public static String keywordOf(int tag, String privateCreator) {
        return ElementDictionary.getElementDictionary(privateCreator).keywordOf(tag);
    }

    public static int tagForKeyword(String keyword, String privateCreatorID) {
        return ElementDictionary.getElementDictionary(privateCreatorID).tagForKeyword(keyword);
    }

    public final String getPrivateCreator() {
        return this.privateCreator;
    }

    public abstract VR vrOf(int var1);

    public abstract String keywordOf(int var1);

    public int tmTagOf(int daTag) {
        return 0;
    }

    public int daTagOf(int tmTag) {
        return 0;
    }

    public int tagForKeyword(String keyword) {
        if (null != this.tagClass) {
            try {
                return this.tagClass.getField(keyword).getInt(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }
}

