/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.galaxy.data;

import java.io.Serializable;
import java.util.Objects;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.AttributesSelector;
import org.aoju.bus.image.galaxy.data.ItemPointer;

public class ValueSelector
implements Serializable {
    private final AttributesSelector attributesSelector;
    private final int valueIndex;
    private String text;

    public ValueSelector(int tag, String privateCreator, int index, ItemPointer ... itemPointers) {
        this(new AttributesSelector(tag, privateCreator, itemPointers), index);
    }

    public ValueSelector(AttributesSelector attributesSelector, int index) {
        this.attributesSelector = Objects.requireNonNull(attributesSelector);
        this.valueIndex = index;
    }

    public static ValueSelector valueOf(String s) {
        int fromIndex = s.lastIndexOf("DicomAttribute");
        try {
            return new ValueSelector(AttributesSelector.valueOf(s), AttributesSelector.selectNumber(s, fromIndex) - 1);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(s);
        }
    }

    public int tag() {
        return this.attributesSelector.tag();
    }

    public String privateCreator() {
        return this.attributesSelector.privateCreator();
    }

    public int level() {
        return this.attributesSelector.level();
    }

    public ItemPointer itemPointer(int index) {
        return this.attributesSelector.itemPointer(index);
    }

    public int valueIndex() {
        return this.valueIndex;
    }

    public String selectStringValue(Attributes attrs, String defVal) {
        return this.attributesSelector.selectStringValue(attrs, this.valueIndex, defVal);
    }

    public String toString() {
        if (null == this.text) {
            this.text = this.attributesSelector.toStringBuilder().append("/Value[@number=\"").append(this.valueIndex + 1).append("\"]").toString();
        }
        return this.text;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueSelector)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }
}

